/*------------------------------------------------------------------------

      File:  global.h
   Project:  Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  22:01:47, 1/17/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tclHash.h>

/* init.c */
extern int   TieStdout(void);
extern int   UnTieStdout(int);
extern int   Initialize_Tcl(Tcl_Interp**, int, char*[]);
extern int   Setup_Environment(Tcl_Interp*);

/* utility.c */
extern int   output_set_shell_info(const char*, const char*);
extern int   output_unset_shell_info(const char*);
extern int   Flush_Shell_Changes(void);
extern int   set_shell_variable(const char*, const char*);
extern int   unset_shell_variable(const char*);
extern int   set_shell_alias(const char*, const char*);
extern int   unset_shell_alias(const char*);
extern char* set_derelict(const char*);
extern int   store_env(void);
extern int   free_stored_env(void);
extern char* set_backup(Tcl_HashTable*, char*, char*);
extern char* get_backup(Tcl_HashTable*, char*);
extern Tcl_HashTable*  environ_changes;
extern Tcl_HashTable*  alias_changes;

/* cmdSetenv.c */
extern int   cmdSetEnv(ClientData, Tcl_Interp*, int, char*[]);
extern int   cmdUnsetEnv(ClientData, Tcl_Interp*, int, char*[]);

/* cmdPath.c */
extern int   cmdSetPath(ClientData, Tcl_Interp*, int, char*[]);
extern int   cmdRemovePath(ClientData, Tcl_Interp*, int, char*[]);
extern char* chk_nullvars(char*);

/* cmdInfo.c */
extern int   cmdModuleInfo(ClientData, Tcl_Interp*, int, char*[]);

/* cmdAlias.c */
extern int   cmdSetAlias(ClientData, Tcl_Interp*, int, char*[]);

/* cmdConflict.c */
extern int   cmdConflict(ClientData, Tcl_Interp*, int, char*[]);
extern int   cmdPrereq(ClientData, Tcl_Interp*, int, char*[]);

/* cmdMisc.c */
extern int   cmdSystem(ClientData, Tcl_Interp*, int, char*[]);

/* cmdModule.c */
extern int   cmdModule(ClientData, Tcl_Interp*, int, char*[]);
extern int   Init_Modules(Tcl_Interp*, int, char*[]);
extern int   Available_Modules(Tcl_Interp*, char*[]);
extern int   Load_Modules(Tcl_Interp*, char*[]);
extern int   Switch_Modules(Tcl_Interp*, int, char*[]);
extern int   Unload_Modules(Tcl_Interp*, char*[]);
extern int   Display_Modules(Tcl_Interp*, char*[]);
extern int   List_Modules(Tcl_Interp*, char*[]);
extern int   Prepend_ModulePath(Tcl_Interp*, int, char*[]);
extern int   Clear_LoadedModules(Tcl_Interp*, int, char*[]);
extern int   Read_Modulefile(char*, Tcl_Interp*);
extern int   Update_LoadedList(Tcl_Interp*, char*);
extern int   IsLoaded(char*);
extern void  SetStartupFiles(void);

/* LocateModule.c */
extern char*  Locate_ModuleFile(Tcl_Interp*, char*, char**);
extern char*  GetModuleName(Tcl_Interp*, char*, char*);
extern char** SortedDirList(Tcl_Interp*, char*, char*, int*);
extern char** SplitIntoList(Tcl_Interp*, char*, int*);
extern void   FreeList(char**, int);

/* Tcl Library */
extern void             setenv(char *name, char *value);
extern void             unsetenv(char *name);
extern int              FindVariable(char *name, int *lengthPtr);


/* flags values */
#define      M_REMOVE   0x0001
#define      M_DISPLAY  0x0002
#define      M_SWSTATE1 0x0004
#define      M_SWSTATE2 0x0008
#define      M_SWSTATE3 0x0010
#define      M_SWITCH   (M_SWSTATE1 | M_SWSTATE2 | M_SWSTATE3)
#define      M_LOAD     0x0020
#define      M_CLEAR    0x0040
#define      M_PREPEND  0x0080

#define      SWMARKER   "--MARKER--"

#define TCL_LEVEL0_RETURN  11

/* global vars */
extern int    errno;
extern char** environ;

extern char*  current_module;
extern char** shell_startups;
extern char   shell_name[];
extern char   shell_derelict[];
extern int    flags;

extern Tcl_HashTable   set_changes_env_table;
extern Tcl_HashTable   unset_changes_env_table;
extern Tcl_HashTable   backup_alias_table;
extern Tcl_HashTable   backup_env_table;

extern Tcl_HashTable*  set_environ_changes;
extern Tcl_HashTable*  unset_environ_changes;
extern Tcl_HashTable*  backup_environ_changes;
extern Tcl_HashTable*  backup_alias_changes;

