/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	91/10/23
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      The Tcl module-info routine which provides information about the state
 *  of Modules as the modulefile is being parsed. 
 *	
 * $Log: cmdInfo.c,v $
 *
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: cmdInfo.c,v 2.0 1993/02/21 00:00:41 jlf Exp jlf $";

#include "global.h"

int
cmdModuleInfo(ClientData client_data,
	      Tcl_Interp* interp,
	      int argc,
	      char* argv[])
{
    if(argc < 2) {
        Tcl_AppendResult(interp, "internal error: unknown \"", argv[0],
                         " info-descriptor descriptor-args\"", (char *) NULL);
    }
  
    if(!strcmp(argv[1], "flags")) {
        char tmpbuf[6];
        sprintf(tmpbuf, "%d", flags);
        Tcl_SetResult(interp, tmpbuf, NULL);
    } if(!strcmp(argv[1], "mode")) {
        if(argc < 3) {
            if(flags & M_SWSTATE1)
                Tcl_SetResult(interp, "switch1", TCL_STATIC);
            else if(flags & M_SWSTATE2)
                Tcl_SetResult(interp, "switch2", TCL_STATIC);
            else if(flags & M_SWSTATE3)
                Tcl_SetResult(interp, "switch3", TCL_STATIC);
            else if(flags & M_LOAD)
                Tcl_SetResult(interp, "load", TCL_STATIC);
            else if(flags & M_REMOVE)
                Tcl_SetResult(interp, "remove", TCL_STATIC);
            else if(flags & M_DISPLAY)
                Tcl_SetResult(interp, "display", TCL_STATIC);
            else
                Tcl_SetResult(interp, "unknown", TCL_STATIC);
            
            return TCL_OK;
        }
        
        Tcl_SetResult(interp, "0", TCL_STATIC);

        if(!strcmp(argv[2], "load")) {
            if(flags & M_LOAD) Tcl_SetResult(interp, "1", TCL_STATIC);
        }
        else if(!strcmp(argv[2], "remove")) {
            if(flags & M_REMOVE) Tcl_SetResult(interp, "1", TCL_STATIC);
        }
        else if(!strcmp(argv[2], "display")) {
            if(flags & M_DISPLAY) Tcl_SetResult(interp, "1", TCL_STATIC);
        }
        else if(!strcmp(argv[2], "switch1")) {
            if(flags & M_SWSTATE1) Tcl_SetResult(interp, "1", TCL_STATIC);
        }
        else if(!strcmp(argv[2], "switch2")) {
            if(flags & M_SWSTATE2) Tcl_SetResult(interp, "1", TCL_STATIC);
        }
        else if(!strcmp(argv[2], "switch3")) {
            if(flags & M_SWSTATE3) Tcl_SetResult(interp, "1", TCL_STATIC);
        }
        else if(!strcmp(argv[2], "switch")) {
            if(flags & M_SWITCH) Tcl_SetResult(interp, "1", TCL_STATIC);
        } else {
            Tcl_AppendResult(interp, 
                             "Unrecognized module-info mode type: ", argv[2],
                             (char *) NULL);
            return TCL_ERROR;
        }
    } else if(!strcmp(argv[1], "name")) {
        Tcl_SetResult(interp, current_module, TCL_VOLATILE);
    } else {
        Tcl_AppendResult(interp, "Unrecognized module-info descriptor: ", argv[1],
                         (char *) NULL);
        return TCL_ERROR;
    }

  return TCL_OK;
}
    
