/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	91/10/23
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      The Tcl set-alias command.
 *	
 * $Log: cmdAlias.c,v $
 *
 *
 * Revision 1.2  1993/01/20  03:34:39  jlf
 * Fixed bug where aliases were not being unset properly when removing
 * modulefiles.
 *
 * Revision 1.1  1992/11/05  23:29:12  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: cmdAlias.c,v 2.0 1993/02/21 00:00:29 jlf Exp jlf $";

#include "global.h"

int
cmdSetAlias(ClientData client_data,
	  Tcl_Interp* interp,
	  int argc,
	  char* argv[])
{
    if(!strncmp(argv[0], "un", 2) && (argc != 2)) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                         " variable\"", (char *) NULL);
        return TCL_ERROR;
    } else if(!strncmp(argv[0], "set", 3) && (argc != 3)) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                         " variable\"", (char *) NULL);
        return TCL_ERROR;
    }

    if(flags & M_DISPLAY) {
        if(*argv[0] == 'u')
            fprintf(stderr, "Unset Alias %s\n", argv[1]);
        else
            fprintf(stderr, "Set Alias %s to '%s'\n", argv[1], argv[2]);
        return 0;
    }

    if(flags & M_SWSTATE1) {
        set_marked_entry(markAliasHashTable, argv[1], M_SWSTATE1);
        return TCL_OK;
    } else if(flags & M_SWSTATE2) {
        set_marked_entry(markAliasHashTable, argv[1], M_SWSTATE2);
    } else if(flags & M_SWSTATE3) {
        int marked_val;
        if(marked_val = chk_marked_entry(markAliasHashTable, argv[1])) {
            if(marked_val == M_SWSTATE1)
                store_shell_alias(aliasUnsetHashTable, argv[1], argv[2]);
            else
              return TCL_OK;
      }
    } else if(flags & M_REMOVE) {
        store_shell_alias(aliasUnsetHashTable, argv[1], argv[2]);
    }

    if(*argv[0] == 'u' || (flags & M_REMOVE))
        store_shell_alias(aliasUnsetHashTable, argv[1], argv[2]);
    else
        store_shell_alias(aliasSetHashTable, argv[1], argv[2]);
  
    return TCL_OK;
}
