/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/06/20
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Clears out Modules' concept of the currently loaded modules.
 *	
 * $Log: ModuleCmd_Clear.c,v $
 *
 *
 * Revision 1.2  1993/01/20  03:29:53  jlf
 * Modified to clear the new _LOADED_MODULEFILES_ environment variable too.
 * Removed code to selectively clear modulefiles from the list.
 *
 * Revision 1.1  1992/11/05  23:43:38  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_Clear.c,v 2.0 1993/02/20 23:59:46 jlf Exp jlf $";

#include "global.h"

int ModuleCmd_Clear(Tcl_Interp* interp,
		    int         argc,
		    char*       argv[])
{
    char         buf[10];
    char*        clearargv[4];
    int          i = 0;
    
    fprintf(stderr, "\nAre you sure you want to clear all \
loaded modules!? [n] ");
    fgets(buf, 10, stdin);
	
    if(buf[0] == 'y') {
        clearargv[0] = "setenv";
        clearargv[1] = "LOADEDMODULES";
        clearargv[2] = "";
        clearargv[3] = NULL;
        cmdSetEnv((ClientData) 0, interp, 3, clearargv);

        clearargv[0] = "setenv";
        clearargv[1] = "_LMFILES_";
        clearargv[2] = "";
        clearargv[3] = NULL;
        cmdSetEnv((ClientData) 0, interp, 3, clearargv);
    } else {
        fprintf(stderr, "\nLOADEDMODULES was NOT cleared.\n");
    }
    
    return TCL_OK;
}
