/* File: /u1/oystr/HRPC/hrpcErrCodes.h  Date: 23-Oct-1986  */

/*
 * $Header$
 * INTERFACE:	None, merely definitions
 *
 * FUNCTION:	Error codes reported by various runtime
 *		facilities.
 *
 * IMPORTS:	None.
 *
 * EXPORTS:	Error codes.
 *			>>>> WARNING <<<<
 *		Does NOT include Import/Export error codes.  These
 *		are defined in HRPC/Interfaces/HCS_NS_BA.cr.
 *
 * DESIGN:	You are looking at it.
 *
 * $Log$
 * 23-Oct-1986:	Initial implementation, Jan Sanislo
 */

#ifndef hrpcErrCodes
#define hrpcErrCodes

typedef long HRPCErrVal;

/** related to RPC calls themselves **/

#define HRPC_NORMAL   0x0
#define HRPC_REPLYTMO 0x10001
#define HRPC_PEERDIED 0x10002
#define HRPC_BADPROGN 0x10003
#define HRPC_BADPROCN 0x10004
#define HRPC_BADPARAM 0x10005
#define HRPC_BADVERSN 0x10006
#define HRPC_BADAUTHN 0x10007
#define HRPC_WRNGSTUB 0x10008
#define HRPC_RPCVERSN 0x10009
#define HRPC_SYSERR   0x1000a
#define HRPC_UNKNERR  0x1000b
#define HRPC_NOSERVER 0x1000c

typedef struct {
    HRPCErrVal hrpcErr;
    /* case hrpcErr of */
    char *errDetails;
} HRPCErrRec;

/*
 * A few macros...
 */
#define NOHRPCERR     (HRPCErrRec *) 0
#define mNoError(x)   ( ((x) == NOHRPCERR) || ((x)->hrpcErr == 0) )
#define mSomeErr(x)   ( ((x) != NOHRPCERR) && ((x)->hrpcErr != 0) )
#define mIsSysErr(x)  ( ((x)->hrpcErr & 0xF0000) == 0 )
#define mIsHrpcErr(x) ( ((x)->hrpcErr & 0xF0000) != 0 )

extern HRPCErrRec *NewHRPCErrRec();

#endif
