/****************************************************************
 * Standard include file for HRPC.  Mainly concerned with	*
 * definitions of the HRPCBinding structure.			*
 *								*
 * 06-Feb-86 oystr						*
 *   Initial version						*
 ****************************************************************/

#ifndef basicRpc
#define basicRpc

#ifndef cCourierTypes
#include "HRPC/cCourierTypes.h"
#endif

/*
 * Have to include these because of sockaddr use
 * in TransControl structure.
 */
#ifndef makedev
#include <sys/types.h>
#endif
#ifndef SOCK_STREAM
#include <sys/socket.h>
#endif

#ifndef SpeakDefs
#include <HRPC/CIncludes/SpeakDefs.h>
#endif

/*
 * Individual "speak" components: RPC protocol, OTW representation,
 * transport protocols.
 */
#define SUNRPC 1
#define COURRPC 2
#define RAWRPC 3
#define SUNOTW 1
#define COUROTW 2
#define RAWOTW 3
#define TCPTRANSP 1
#define UDPTRANSP 2
#define XNSTRANSP 3
#define RAWTCPTRANSP 4
#define RAWUDPTRANSP 5

typedef char * TBD;
typedef char * memory;

/*
 * contains interface specific info.
 */
typedef struct {
	LongCardinal progNum;   /* program number */
	Cardinal versNum;       /* version number */
	TBD configInfo;         /* location dep. config. info */
} InterfaceDescr;

/*
 * RPC protocol specific routines
 * this is really all wrong - need reassembly routines
 */
typedef struct {
	int (*InitOutgoing)(), (*PacketOutgoing)(), (*FinishOutgoing)();
				/* for client transmission */
	int (*InitIncoming)(), (*PacketIncoming)(), (*FinishIncoming)();
				/* for server reception */
	int (*InitReply)(),    (*ReplyPacket)(),    (*FinishReply)();
				/* for server transmission */
	int (*InitAnswer)(),   (*AnswerPacket)(),   (*FinishAnswer)();
				/* for client reception */
	int (*PutPacket)();	/* stuffed with PacketOutgoing() or
				   ReplyPacket() from this control block, or
				   SendPacket() from the Transport control
				   block */
	int (*GetPacket)();	/* stuffed with PacketIncoming() or
				   AnswerPacket() from this control block, or
				   RecvPacket() from the Transport control
				   block */
	int (*CloseRpc)();	/* Free all resources */
	int (*RpcError)();	/* Later... */
	int (*GetReplyId)();	/* obtains replyId from packet header - used
				   to determine whom packet is for in env
				   with multiple threads */
	u_long	replyId;	/* replyId placed in outgoing packet
				 * header by InitOutGoing - value used
				 * to determine whom packet is for
				 * in env with multiple threads */
	memory callState; /* private data - protocol dependent */
} RpcControl;

/*
 * Transport protocol specific routines
 */

struct PacketQelement {
        struct PacketQelement   *Next;
        struct PacketQelement   *Prev;
        int                     BufSize;
        memory                  BufMark;
        memory                  CurrentBuffer;
	int			fd;	/* fd on which packet was received */
        struct sockaddr         From;   /* used by UDP & TCP Transport */
};
typedef struct {
	int (*MaxBufferSize)();
	int (*OpenLink)(),   (*CloseLink)();
	int (*SendPacket)(), (*RecvPacket)();
	int (*InitSend)(), (*FinishSend)(), (*InitRecv)(), (*FinishRecv)();
	memory (*BufAlloc)(), (*BufDealloc)();
	int packetArrived;	/* set when packet has arrived for LWP by STM
				/* & reset by HRPC_SelectAndReadPacket */
	struct PacketQelement *arrivedPacketQ; /* Queue of packets for LWP */
	struct PacketQelement *TAIL_arrivedPacketQ; /* keeps track of each
					* arrivedPacketQ's last element */
	struct sockaddr	replyTo;
	/* following are OS specific */
	struct sockaddr	netAddr;
	int sockfd;     /* > 0 ==> open */
	int tmp_sockfd;
	memory transInfo;
} TransControl;

/*
 * Data rep. "protocol" - mostly stolen from SUN
 * One procedure for each Courier base data type
 * and one for each Courier constructor type.
 * Names should probably be qualified by 'Otw'.
 */

typedef struct {
	int (*Cardinal)();	int (*LongCardinal)();
	int (*Integer)();	int (*LongInteger)();
	int (*Boolean)();	int (*Unspecified)();
	int (*LongUnspecified)(); int (*String)();
	int (*Array)();		int (*Choice)();
	int (*Enumeration)();	int (*Sequence)();
	int (*Record)();	int (*Procedure)();
	int (*Error)();		int (*Deallocate)();
	int (*NilRecord)();	int (*CloseOtw)();
} OtwControl;

#define OTW_ENCODE 0
#define OTW_DECODE 1
#define OTW_FREE   2

/*
 * Describes how we talk to a particular instance
 * at a particular place & communications area for
 * underlying protocols.
 */
typedef struct {
	InterfaceDescr *ifdPtr;		/* back pointer to interface */
	int		otwOp;		/* one of OTW_ above */
	int		maxBufSize;	/* total buffer size */
	int		curBufSize;	/* space REMAINING in buffer */
        memory		curBufMark;	/* position in buffer */
	memory		currentBuffer;  /* start of buffer */
	int		connectionId;	/* low-level dispatcher hook */
        int             rpcType;        /* SUNRPC|COURRPC */
	RpcControl	rpcDescr;	/* RPC protocol */
        int             transType;      /* TCPTRANSP|UDPTRANSP|XNSTRANSP */
	TransControl	transDescr;	/* transport protocol */
        int             otwType;        /* SUNOTW|COUROTW */
        OtwControl      otwDescr;       /* Data rep. */
	LongCardinal    bndProgNum;	/* Program number we're bound 2 */
	SpeakDefs_Speak speaking;	/* full protocol we are using */
	int		connState;	/* connection state - part of binding
					 * (instead of connection state) since
					 * multiple LWPs can share a single
					 * connection (thus, a connection can
					 * be in multiple states at a given
					 * instant) */
	memory		unwindTo;	/* (jmp_buf *) for Unix */
} HRPCBinding;

struct BindingQIdTableEntry {
	int	(*getPacketIdValue)();
	u_long  IdValue;
};
#define BindingQIdTableMax	5
struct BindingQelement {
        struct BindingQelement  *Next;
        struct BindingQelement  *Prev;
        HRPCBinding             *fBptr;
	int			In_Dispatcher;
        int                     NumIdValues;
        struct BindingQIdTableEntry	IdTable[BindingQIdTableMax];
};

/*
 * Export flags bitmask.
 *  IN:
 */
#define EXPF_SERVER   0
#define EXPF_CALLBACK 1
#define EXPF_UNIQUE   2
#define EXPF_UNBIND   4
/*
 *  OUT:
 */
#define EXPF_AUTOACT 32
#define EXPF_PREACT  64

#endif ifndef basicRpc

/*
 * miscellaneous constants
 */

#ifndef TRUE
#define TRUE (1)
#endif

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef NULL
#define NULL ((char*) 0)
#endif

