/* File: /u1/oystr/HRPC/HRpcRTS//Transports/sppTransp.c  Date:  5-Mar-1986  */

/*
 * $Header: sppTransp.c,v 1.5 86/04/02 15:01:09 dtc Exp $
 * INTERFACE:	Dummy interface for now
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log:	sppTransp.c,v $
 *
 * Revision 1.7  87/08/20  ??:??:?? mss
 * Changes for lightweight process support.
 *
 * Revision 1.6  86/06/13  13:34:10 oystr
 * General clean up as part of merge.
 *
 * Revision 1.5  86/04/02  15:01:09  dtc
 * proper use (hopefully) of CheckEND(), within SPPInitSend().
 * Probably other fine touches related to encapsulation.
 * 
 * Revision 1.4  86/03/31  20:37:54  dtc
 * working "lawnmower" version, client side only
 * 
 * Revision 1.3  86/03/28  15:15:06  dtc
 * version with "lawnmower" for client message transmission
 * 
 * Revision 1.1  86/03/27  08:31:10  dtc
 * Initial revision
 * 
 *  5-Mar-1986:	Initial implementation, Jan Sanislo
 */

#include "../HRpcRTS/sysSpecific.h"
#ifdef HAS_XNS43

/*
 * Taking a chance here by not defining things if
 * no XNS, but the only references to these routines
 * should be in configCCS.c, which is properly wired.
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netns/ns.h>
/* #include <sys/time.h> */
#include <errno.h>
#include <netns/sp.h>
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>
#include "../Transports/sppTransp.h"
#include <HRPC/LWP/kEvents.h>
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "../Transports/connDefs.h"

extern int AllocateBuffer();
extern int DeallocateBuffer();
extern int	errno;


int SPPMaxBufferSize( fBptr )
    HRPCBinding *fBptr;
{
    return( SPPMAXDATA );	/* in bytes */
}

/*
 * Create a SPP socket for ourselves and
 * attempt connection to remote entity.
 * Close only via associated socket file descriptor.
 */
int SPPOpenLink( fBptr )
    HRPCBinding *fBptr;
{
    struct sockaddr_ns *destAddr;
    register TransControl *tcptr = &(fBptr->transDescr);
    register ConnDescr *connptr;
    int spktyp = (int) fBptr->speaking;
    STMconnDescr *stmconnptr = &STMconnStates[spktyp];
    HRPCBinding *STMfBptr;
    SppTransInfo *tiptr;
    char *ME = "SPPOpenLink: ";
    extern void setConnReadProc();
    extern int HRPC_AddToREADFDS();
    extern int HRPC_SetSocketAsync();
    extern int HRPC_SetSocketNdelay();
    extern int HRPC_LWPcreateSTM();
    lwpPROCESS STMpid;
    int sigsheldprevious;
    
    destAddr = (struct sockaddr_ns *) &(tcptr->netAddr);
    if ( (destAddr->sns_family != AF_NS) ||
	 (destAddr->sns_addr.x_port <= 0) ) {
	fatalerr("%s netAddr not initialized.\n",ME);
    }

    /*
     * check state.
     */
    if ( tcptr->sockfd > 0 ) {
	/* already open so return */
	/* tcptr->packetArrived = 0; */
	return;
    }
    
    /*
     * Create connection -
     * make socket, create SpeakTypeMgr and connect to remote
     */
    tcptr->sockfd = socket(destAddr->sns_family, SOCK_SEQPACKET, 0);
    if ( tcptr->sockfd < 0 )
	fatalperr("%s create (Courier) socket.\n",ME);
    if ( HRPC_lwpType != SingleThread ) {
	HRPC_SetSocketAsync(tcptr->sockfd,0);
	if ( stmconnptr->connCount == 0 ) {
	    HRPC_LWPcreateSTM(fBptr, &STMfBptr, &STMpid);
	}
    }

    /* connect to remote */
    if (connect(tcptr->sockfd, (struct sockaddr *) destAddr,
		   sizeof(struct sockaddr_ns)) < 0) {
	errmsg("%s can't connect to remote: %x%4x#%x.%x.%x.%x.%x.%x#%d\n", ME,
#ifdef ultrix
#define s_net ss_net
#endif
	   destAddr->sns_addr.x_net.s_net[0],
	   destAddr->sns_addr.x_net.s_net[1],
	   destAddr->sns_addr.x_host.c_host[0],
	   destAddr->sns_addr.x_host.c_host[1],
	   destAddr->sns_addr.x_host.c_host[2],
	   destAddr->sns_addr.x_host.c_host[3],
	   destAddr->sns_addr.x_host.c_host[4],
	   destAddr->sns_addr.x_host.c_host[5],
	   ntohs(destAddr->sns_addr.x_port));
#ifdef ultrix
#undef s_net
#endif
	tcptr->sockfd = 0;
	/* what about deleting STM ??? */
	longjmp(fBptr->unwindTo,
		NewHRPCErrRec(HRPC_NOSERVER,0) );
    }
    if ( HRPC_lwpType != SingleThread ) HRPC_SetSocketNdelay(tcptr->sockfd);
    connptr = &connStates[tcptr->sockfd];
    fBptr->connState = CONN_IDLE;
    tcptr->packetArrived = 0;
    DISABLE_SignalHandler
    connptr->masterfd = connptr->connfd = tcptr->sockfd;
    connptr->connbptr = fBptr;
    setConnReadProc(tcptr->sockfd,fBptr);
    connptr->connCount = 1;
    ENABLE_SignalHandler
    connptr->selmask = (1 << tcptr->sockfd);
    if ( HRPC_lwpType != SingleThread ) {
	if ( stmconnptr->connCount == 0 ) {
	    stmconnptr->STMpid = STMpid;
	    stmconnptr->BindingQ = (struct BindingQelement *) 0;
	    DISABLE_SignalHandler
	    stmconnptr->BufferQ = (struct BufferQelement *) 0;
	    stmconnptr->TaskQ = (struct PacketQelement *) 0;
	    stmconnptr->BufferQsize = 0;
	    stmconnptr->STMbptr = STMfBptr;
	    ENABLE_SignalHandler
	}
	DISABLE_SignalHandler
	HRPC_AddToREADFDS(tcptr->sockfd);
	(stmconnptr->connCount)++;
	ENABLE_SignalHandler
    } else {
	DISABLE_SignalHandler
	if ( stmconnptr->connCount == 0 ) {
	    stmconnptr->BufferQ = (struct BufferQelement *) 0;
	    stmconnptr->BufferQsize = 0;
            stmconnptr->STMbptr = fBptr;
	}
	(stmconnptr->connCount)++;
        ENABLE_SignalHandler
    }
}

SPPCloseLink( fBptr )
    HRPCBinding *fBptr;
{
    register struct sockaddr_ns *destAddr;
    register TransControl *tcptr = &(fBptr->transDescr);
    register ConnDescr *connptr;
    int		ConnStateFD, sigsheldprevious;
    extern struct BindingQelement *CleanUpBindingQ();
    
    destAddr = (struct sockaddr_ns *) &(fBptr->transDescr.netAddr);
    
    if ( tcptr->sockfd <= 0 ) {
	/* fatalerr("SPPCloseLink: link not open.\n"); */
	return;
    }

    connptr = &connStates[tcptr->sockfd];
    DISABLE_SignalHandler
    --(connptr->connCount);
    ENABLE_SignalHandler
    if ( connptr->connCount > 0 ) {
		/* connection still in use */
	DISABLE_SignalHandler
        --(STMconnStates[(int)fBptr->speaking].connCount);
	ENABLE_SignalHandler
	CleanUpBindingQ(fBptr,1);
        tcptr->packetArrived = 0;
	fBptr->connState = CONN_CLOSED;
	tcptr->sockfd = 0;
	destAddr->sns_addr.x_port = 0;
	destAddr->sns_family = 0;
	if ( tcptr->transInfo != NULL ) {
	    free( tcptr->transInfo );
	    tcptr->transInfo = NULL;
	}
	DeallocateBuffer( fBptr );
	return;
    }
    ConnStateFD = tcptr->sockfd;

    DISABLE_SignalHandler
    /* stolen straight from xnslib/sppclose.c */
    (void) SPPClose(tcptr->sockfd);
    if ( HRPC_lwpType != SingleThread ) HRPC_RmFromREADFDS(ConnStateFD);
    ENABLE_SignalHandler
    /* now fix up connection stuff */
    HRPC_LWPcloseSocket(fBptr, ConnStateFD);
    destAddr->sns_addr.x_port = 0;
    destAddr->sns_family = 0;
    free( tcptr->transInfo );
    tcptr->transInfo = NULL;
}

int SPPInitRecv(fBptr, fDirec)
    HRPCBinding *fBptr;
    int fDirec;
{
    SppTransInfo *tiptr;
    register TransControl *tcptr;

    tcptr = &(fBptr->transDescr);
    if ( tcptr->transInfo == NULL ) {
	tcptr->transInfo = (memory) calloc(1, sizeof( SppTransInfo ) );
	if ( tcptr->transInfo == NULL ) {
	    fatalerr("SPPInitRecv: can't alloc transInfo.\n");
	}
    }
    AllocateBuffer( fBptr );
    tiptr = (SppTransInfo *) tcptr->transInfo;
    tiptr->EndOfMessage = FALSE;
    fBptr->connState = fDirec;
    return( SPPRecvPacket( fBptr ) );
}

/*
 * Try to receive a chunk of data.  Note that there is a lot of
 * fooling around with EM bits, etc.
 *
 * Unwarranted assumptions:
 *   The memory buffer in the binding is "free".
 */

int SPPRecvPacket( fBptr )
    register HRPCBinding *fBptr;
{
    static struct timeval tmo = { 90, 0 };
    int	readmask, readables;
    register int cnt;
    register TransControl *tcptr = &fBptr->transDescr;
    SppTransInfo *transInfo;
    u_char dt;	/* data stream type */
    int selectStatus, readStatus;
    struct BindingQIdTableEntry	idTable[BindingQIdTableMax];
    extern int	AddToBindingQ();
    ConnDescr *connptr;
    
    transInfo = (SppTransInfo *) tcptr->transInfo;
    if (transInfo->EndOfMessage == TRUE) {
	fatalerr("SPPRecvPacket:  end-of-message flag seen prematurely.\n");
    }

    connptr = &connStates[tcptr->sockfd];
    readmask = 1 << tcptr->sockfd;

loop:
    readables = readmask;
    if ( HRPC_lwpType != SingleThread ) {
	/* construct BindingQelement & add to connStates[fd].BindingQ */
	    /* first, set IdTable */
	/* to be worked out */
	AddToBindingQ(fBptr,idTable,0,0);
    }
	/* make HRPC_SelectAndReadPacket call */
    (*HRPC_lwpDescr.SelectAndReadPacket)(fBptr, &tmo, &readables,
						&selectStatus, &readStatus);
    if ( selectStatus < 0 ) {
	    /* should not happen in env with multiple threads */
	if ( errno == EINTR ) goto loop;
	else
	    fatalperr("SPPRecvPacket: select error.\n");
    }

    if ( selectStatus == 0 ) return( HRPC_REPLYTMO ) /* timed out */;

    if ( readables != readmask ) {
	fatalerr("SPPRecvPacket: select mask mismatch.\n");
    }

    cnt = fBptr->curBufSize + sizeof(struct sphdr);
    if ( cnt <= 0 ) {
	fatalperr("SPPRecvPacket: read error.\n");
    }
    
    dt = ((struct sphdr *) fBptr->currentBuffer)->sp_dt;
    if ( dt == SPPSST_END ) {
	SPPCloseReply(tcptr->sockfd);
	fBptr->connState = CONN_CLOSED;
	connStates[connptr->masterfd].selmask &= ~(1 << tcptr->sockfd);
	tcptr->sockfd = connptr->masterfd;
	longjmp(fBptr->unwindTo,
		NewHRPCErrRec(HRPC_PEERDIED,0));
	/*NOTREACHED*/
    }
    else
    if ( (dt == SPPSST_BDT) && (fBptr->connState == CONN_IDLE) ) {
	/* Churn through any BDT garbage */
	goto loop;
    }
    else
    if ( dt != SPPSST_RPC ) {
	fatalerr("Courier stream type changed from %d to %d during message\n",
		 SPPSST_RPC, dt);
	/*NOTREACHED*/
    }

    if (((struct sphdr *) fBptr->currentBuffer)->sp_cc & SP_EM)
	transInfo->EndOfMessage = TRUE;

    if ( (fBptr->curBufSize < 0) || ( (cnt == 0) && (dt != SPPSST_END) ) ) {
	fatalerr("Short read in SPPRecvPacket\n");
	/*NOTREACHED*/
    }
    return( 0 );
}


SPPFinishRecv(fBptr, fDirec)
    register HRPCBinding *fBptr;
    int fDirec;
{
	fBptr->connState = CONN_IDLE;
}

/*
 * Initialize for sending.  Note that if we return non-zero
 * something has happened (in this case connection re-open)
 * that the RPC level is supposed to be able to deal with.
 */
SPPInitSend(fBptr, fDirec)
    register HRPCBinding *fBptr;
    int fDirec;
{
    register TransControl *tcptr = &fBptr->transDescr;
    struct sphdr *sphdrOpts;
    int retval;
    struct sockaddr_ns *destAddr;
    char *ME = "SPPInitSend: ";

    if ( (fDirec == CONN_CLCALL) && SPPCheckEND(fBptr) ) {
	/*
	 * make socket and connect to remote
	 */
	destAddr = (struct sockaddr_ns *) &(tcptr->netAddr);
	tcptr->sockfd = socket(destAddr->sns_family, SOCK_SEQPACKET, 0);
	if ( tcptr->sockfd < 0 ) {
	    fatalperr("%s create (Courier) socket.\n",ME);
	    /*NOTREACHED*/
	}
	if (connect(tcptr->sockfd, (struct sockaddr *) destAddr,
		   sizeof(struct sockaddr_ns)) < 0) {
	errmsg("%s can't connect to remote: %x%4x#%x.%x.%x.%x.%x.%x#%d\n", ME,
#ifdef ultrix
#define s_net ss_net
#endif
	    destAddr->sns_addr.x_net.s_net[0],
	    destAddr->sns_addr.x_net.s_net[1],
	    destAddr->sns_addr.x_host.c_host[0],
	    destAddr->sns_addr.x_host.c_host[1],
	    destAddr->sns_addr.x_host.c_host[2],
	    destAddr->sns_addr.x_host.c_host[3],
	    destAddr->sns_addr.x_host.c_host[4],
	    destAddr->sns_addr.x_host.c_host[5],
	    ntohs(destAddr->sns_addr.x_port));
#ifdef ultrix
#undef s_net
#endif
	    longjmp(fBptr->unwindTo,
		NewHRPCErrRec(HRPC_NOSERVER,0) );
        }
	retval = 1;
    }
    else {
	retval = 0;
    }
    
    sphdrOpts = (struct sphdr *) fBptr->curBufMark;
    sphdrOpts->sp_dt = SPPSST_RPC;
    sphdrOpts->sp_cc &=  ~SP_EM;
    fBptr->curBufMark += sizeof(struct sphdr);
    fBptr->curBufSize -= sizeof(struct sphdr);
    return( retval );
}

/*
 * Actually send a segment over the link to whatever
 * is on the other side.
 */
int SPPSendPacket( fBptr )
    register HRPCBinding *fBptr;
{
    register struct sphdr *sphdrOpts;
    
    if ( write(fBptr->transDescr.sockfd, fBptr->currentBuffer,
	        fBptr->curBufMark - fBptr->currentBuffer) < 0 ) {
	fatalperr("SPPSendPacket: can't send.\n");
	/*NOTREACHED*/
    }
    /*
     * Reset buffer for next packet.
     */
    fBptr->curBufMark = fBptr->currentBuffer;
    sphdrOpts = (struct sphdr *) fBptr->currentBuffer;
    sphdrOpts->sp_dt = SPPSST_RPC;
    sphdrOpts->sp_cc &=  ~SP_EM;
    fBptr->curBufMark += sizeof(struct sphdr);
    fBptr->curBufSize = fBptr->maxBufSize - sizeof(struct sphdr);
}

/*
 * Set EM bit and send it off.
 */
SPPFinishSend(fBptr, fDirec)
    register HRPCBinding *fBptr;
    int fDirec;
{
    struct sphdr *sphdrOpts;

    fBptr->connState = fDirec;

    sphdrOpts = (struct sphdr *) fBptr->currentBuffer;
    sphdrOpts->sp_cc |=  SP_EM;
    SPPSendPacket( fBptr );
}

/*
 * Low-level buffer allocation/deallocation routines.
 */

memory SPPBufAlloc()
{
    memory newmem;
    register int max = sizeof(struct sphdr) + SPPMAXDATA;
    
    newmem = (memory) malloc( max );
    if ( newmem == (memory) 0 ) {
	fatalerr("SPPBufAlloc: no memory.\n");
    }

    return( newmem );
}

SPPBufDealloc( buffer )
    memory buffer;
{
    if ( (int) buffer > 0 )
	free( buffer );
    else
	fatalerr("SPPBufDealloc: bad buffer.\n");
}

#else
/*
 * No XNS, but define a symbol to suppress ar's complaint
 * about "no symbol table".
 */
int QQzipQQ()
{
}
#endif
