/*
 * This file implements functions used by both client and servers in the
 * XNS courier library
 */

/*
 * $Log: readwrite.c,v $
 *
 * Revision 1.7  86/06/13  14:17:38  oystr
 * General clean up during merge.
 *
 * Revision 1.6  86/04/09  13:03:21  dtc
 * correction of failure-to-connect error message printing
 * 
 * Revision 1.5  86/04/02  14:59:18  dtc
 * rehabilitation of CheckEND()
 * 
 * Revision 1.4  86/03/31  20:37:43  dtc
 * working "lawnmower" version, client side only
 * 
 * Revision 1.2  86/03/28  15:14:50  dtc
 * version with "lawnmower" for client message transmission
 * 
 * Revision 1.1  86/03/27  08:23:34  dtc
 * Initial revision.  Derived from work done by J.Q. Johnson, et al,
 * Cornell University.
 * 
 */

#include "../HRpcRTS/sysSpecific.h"
#ifndef HAS_XNS43
SPPCheckEND()
{
    fatalerr("XNS protocols not supported by this system.\n");
}

#else

#include <stdio.h>
#include <sys/types.h>		/* for ns.h and socket.h */
#include <sys/socket.h>
#include <sys/time.h>
#include <netns/ns.h>	/* for XNS addresses and courierconnection.h */
#include <netns/idp.h>
#include <netns/sp.h>		/* for spphdr */
#include <HRPC/basicRpc.h>
#include "../Transports/sppTransp.h"
#include "../Transports/connDefs.h"

/*
 * look ahead on courier connection, checking for an END packet.
 * If seen, set state to closed.
 */
SPPCheckEND(fBptr)
    HRPCBinding *fBptr;
{
    int count;
    int fdmask;
    static struct timeval timeout = {0,0};
    int	sockfd;
    SppPackBuf	packbuf;

    sockfd = fBptr->transDescr.sockfd;
    fdmask = 1<<(sockfd);
    while ( select(sockfd+1,&fdmask,(int*)NULL,(int*)NULL,&timeout) > 0
	    && (count = 
		 recv(sockfd,(char*)&packbuf, sizeof(packbuf),MSG_PEEK)) > 0) {
	if (packbuf.hdr.sp_dt == SPPSST_END) {
	    read(sockfd, (char*)&packbuf, sizeof(packbuf));
	    (void) SPPCloseReply(sockfd);
	    fBptr->connState = CONN_CLOSED;
	    fBptr->transDescr.sockfd = 0;
	    return(TRUE);
	}
	else
        if (count == sizeof(struct sphdr))
	    read(sockfd, (char*)&packbuf, sizeof(packbuf));
	else return(FALSE);
    }
    return(FALSE);
}

#endif
