/* File: /u1/oystr/HRPC/Transports/connState.h  Date:  7-Jul-1986  */

/*
 * $Header$
 * INTERFACE:	
 *
 * FUNCTION:	Transport-protocol dependent connection state information.
 *		
 * IMPORTS:	basicRpc.h
 *
 * EXPORTS:	Type ConnState 
 *
 * DESIGN:	We need something to keep track of protocol-specific
 *		connection information.  This is it.  Presumably
 *		it will also be useful in the LWP implementation,
 *		when the anticipated SelectManager process will need a mapping
 *		from file descriptor -> protocol dependent network
 *		input routine.  For more information on why this
 *		stuff is needed, see the big design document section
 *		on connection control and message routing.
 *
 *		The general idea is to have connection information
 *		associated with each open file descriptor.  We do
 *		this by having a static array of descriptor blocks.
 *		The size of this array is determined by the maximum
 *		number of ports any one heavyweight process can have
 *		open.  This number is of course OS dependent (as is
 *		the use of "small integers" to designate files --
 *		you may have to write your own file descr. -> small
 *		integer mapping function.).
 *
 * DEFECTS:	Many.
 * $Log$
 *
 * Revision 1.1  87/08/25  ??:??:?? mss
 * Changes for lightweight process support.
 *
 *  7-Jul-1986:	Initial implementation, Jan Sanislo
 */

#ifndef connDefs
#define connDefs

#define NOFILE 64
#define NUM_SPEAKTYPES 32

#ifndef basicRpc
#include <HRPC/basicRpc.h>
#endif
#ifndef LWPdefs
#include <HRPC/LWP/LWPdefs.h>
#endif

struct BufferQelement {
	struct BufferQelement   *Next;
	struct BufferQelement   *Prev;
	memory                  Bufptr;
};
/* NOTE: The BufferQ and the TaskQ require exclusive access since the signal
 *	handler accesses them.  The routines in LWP/lwpSystemQs.c, which
 *	manipulate these queues, provide the necessary exclusive access.
 */

typedef struct {
    int				masterfd;  /* used primarily for TCP */
    int				connfd;
    int				selmask;
    HRPCBinding			*connbptr; /* Bptr of someone using conn */
    int				(*ReadProc)();
    int				connCount; /* # LWPs using connection */
} ConnDescr;
extern ConnDescr connStates[NOFILE];

typedef struct {
    struct BindingQelement	*BindingQ; /* Q used by LWPs & STM */
    struct PacketQelement	*TaskQ;    /* Q used by Signal Handler & STM */
    struct BufferQelement	*BufferQ;  /* Q used by Signal Handler */
    int				BufferQsize; /* # packet buffers on Q */
    HRPCBinding			*STMbptr;  /* Bptr of STM */
    lwpPROCESS			STMpid;    /* LWP pid of STM */
    int				connCount; /* # LWPs using STM */
} STMconnDescr;
extern STMconnDescr STMconnStates[NUM_SPEAKTYPES];

/*
 * Values assumed by connState....
 * Yes, I know this should be an enum.
 * Need explicit state transition diagram.
 */
#define CONN_IDLE   1
#define CONN_WCALL  2
#define CONN_WREPLY 3
#define CONN_CLCALL   4
#define CONN_CLREPLY  5
#define CONN_SRVCALL  6
#define CONN_SRVREPLY 7
#define CONN_CLOSED   8

#define CONN_CNTLPACK -13

#endif
