#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/errno.h>

extern int errno;
#define MSGSIZE 60

main(argc, argv)
int argc;
char **argv;
{
	static struct sockaddr_in from = {0};
	static struct  sockaddr_in MySocket = {AF_INET};
	int NumPending;
	long WriteFDs, ExceptFDs, CopyOfActiveFDs, ActiveFDs;
	char IncomingMsg[MSGSIZE], OutgoingMsg[MSGSIZE], *mp;
        int s, fromlen = sizeof (from);
	int ds, vs, WhichFD;
	int nbytes;

        if (argc !=2) {
                printf("Usage: %s portnum\n", argv[0]);
                exit(1);
        }

	mp = OutgoingMsg;
	*((short *)(mp)) = htons(4321);		/* "INTEGER" part */
	mp += sizeof(short);
	*((long *)(mp)) = htonl(765432);	/* long part */
	mp += sizeof(long);
	*((long *)(mp)) = htonl(1);		/* boolean part */
	mp += sizeof(long);
	strcpy(mp, "vanillaServer string");		/* string part */
	mp += strlen(mp);

        ds = socket(AF_INET, SOCK_DGRAM, 0);
        if (ds < 0) {
                perror("vanillaServer: datagram socket");
                exit(1);
        }
        vs = socket(AF_INET, SOCK_STREAM, 0);
        if (vs < 0) {
                perror("vanillaServer: stream socket");
                exit(1);
        }
	ActiveFDs = (1 << vs) | (1 << ds);

        MySocket.sin_port = htons(atoi(argv[1]));
        if (bind(ds, &MySocket, sizeof(MySocket), 0) < 0) {
                perror("vanillaServer: datagram bind");
                exit(1);
        }
        if (bind(vs, &MySocket, sizeof(MySocket), 0) < 0) {
                perror("vanillaServer: stream bind");
                exit(1);
        }

        listen(vs, 10);

        for (;;) {
		WriteFDs = ExceptFDs = 0;
		CopyOfActiveFDs = ActiveFDs;  
		NumPending = select(20, &CopyOfActiveFDs, &WriteFDs, 
                            &ExceptFDs, 0);   /* 0 means block indefinitely */
		if (NumPending < 0) {
			perror("vanillaServer: select");
			exit(1);
		}
		WhichFD = ffs(CopyOfActiveFDs) - 1;

		if (WhichFD == vs) {
			s = accept(vs, &from, &fromlen, 0);
			if (s < 0) {
				if (errno == EINTR)
					continue;
				perror("vanillaServer: accept");
				exit(1);
			}
			nbytes = recv(s, IncomingMsg, sizeof(IncomingMsg), 0);
			if (nbytes == -1) {
				perror("vanillaServer: recv");
				exit(1);
			}
			PrintVanillaMsg("vanillaServer: received stream msg", IncomingMsg);

			if (send(s, OutgoingMsg, sizeof(OutgoingMsg), 0) == -1) {
				perror("vanillaServer: send");
				exit(1);
			}
		}
		else {	/* Datagram */
			nbytes = recvfrom(ds, IncomingMsg,
					  sizeof(IncomingMsg), 0, &from,
					  &fromlen);
			if (nbytes == -1) {
				perror("vanillaServer: recvfrom");
				exit(1);
			}
			PrintVanillaMsg("vanillaServer: received datagram msg", IncomingMsg);

			if (sendto(ds, OutgoingMsg, sizeof(OutgoingMsg), 0,
				   &from, fromlen) == -1) {
				perror("vanillaServer: sendto");
				exit(1);
			}
		}
                close(s);
        }
}
