/*
 * HRPC who server for Suns/Vaxen
 */
#include <stdio.h>
#include <utmp.h>
#include <pwd.h>
#include <ctype.h>
#include <rpc/rpc.h>

#define NMAX sizeof(utmp.ut_name)
#define LMAX sizeof(utmp.ut_line)
#define	HMAX sizeof(utmp.ut_host)

struct	utmp utmp;
struct	passwd *pw;
struct	passwd *getpwuid();
struct  passwd *getpwnam();

int numUsers = 0;
#define MAX_USERS 40

typedef struct {
    char *fname;
    char *info;
} UserRec;

UserRec curUsers[MAX_USERS];

char stringTable[10000];
char *stindex;

char	hostname[32];

char	*ttyname(), *rindex(), *ctime(), *strcpy();

#define RUSERS 8000
#define RUVERS 1
#define LISTU  1

/* "forward" */
int FormatUsers();
int Dispatch();
int PackResults();

main(argc,argv)
    int  argc;
    char *argv[];
{
        SVCXPRT *transp;
    int proto;
    
    proto = IPPROTO_UDP;
    if ( argc > 1 ) {
	if ( ! strcmp(argv[1], "-T") ) {
	    printf("Using TCP...\n");
	    proto = IPPROTO_TCP;
	}
    }
    else {
	printf("Using UDP...\n");
    }

    if ( proto == IPPROTO_UDP )
	transp = svcudp_create( RPC_ANYSOCK );
    else
	transp = svctcp_create( RPC_ANYSOCK, 0, 0 );

    if ( transp == (SVCXPRT *) 0 ) {
	printf("Can't create server.\n");
	exit( 1 );
    }

    pmap_unset( RUSERS, RUVERS );
    if ( !svc_register(transp, RUSERS, RUVERS, Dispatch, proto ) ) {
	printf("Can't register RUSERS.\n");
	exit( 1 );
    }
    svc_run();
    printf("svc_run returned.\n");
    exit( 1 );
}

int Dispatch( fReq, fTransp )
    struct svc_req *fReq;
    SVCXPRT *fTransp;
{
    int i,j,k;
    int *iptr;
    
#ifdef DEBUG
    printf("Dispatch called...\n");
#endif

    switch ( fReq->rq_proc ) {
	case NULLPROC:
#ifdef DEBUG
printf("NULLPROC called.\n");
#endif
	    if ( !svc_sendreply( fTransp, xdr_void, 0 ) ) {
		printf("...could not reply to NULLPROC.\n");
	    }
	    return;

	case LISTU:
#ifdef DEBUG
printf("LISTU called.\n");
#endif
	    FormatUsers();
	    if ( ! svc_sendreply( fTransp, PackResults, curUsers ) ) {
		printf("..could not send reply.\n");
		exit( 1 );
	    }
#ifdef DEBUG
printf("...sent null reply.\n");
#endif
	    return;

	default:
	    printf("Default case.\n");
	    svcerr_noproc( fTransp );
	    return;
    }
}

FILE *fi = NULL;

FormatUsers()
{
	register char *tp, *s;
	int i;

	stindex = stringTable;
	numUsers = 0;
	
	s = "/etc/utmp";

        if ( fi == NULL ) {
	    if ((fi = fopen(s, "r")) == NULL) {
		puts("who: cannot open utmp");
		exit(1);
	    }
	}
	else 
	if ( fseek( fi, (long) 0, 0 ) < 0 ) {
	    perror("fseek");
	    return;
	}

	while (fread((char *)&utmp, sizeof(utmp), 1, fi) == 1) {
		if (utmp.ut_name[0] == '\0')
			continue;
		FormatLine();
		++numUsers;
	}
#ifdef DEBUG
	for( i = 0; i <numUsers; i++ ) {
	    printf("'%s' '%s'\n",curUsers[i].fname,curUsers[i].info);
	}
#endif
}

FormatLine()
{
	register char *cbuf;
	char utnam[20];
	char utline[20];
	char hname[20];
	char fullname[80];
	char fulldate[80];
	char junkline[200];
	char samename[30];
	
	sprintf(utnam,"%-*.*s ",NMAX,NMAX,utmp.ut_name);
	sprintf(utline,"%-*.*s ",LMAX,LMAX,utmp.ut_line);

	strncpy(fullname,utmp.ut_name,NMAX);
        fullname[NMAX] = '\0';
	strcpy(samename,fullname);
	if ( (samename[0] >= 'a') && (samename[0] <= 'z') ) {
	    samename[0] -= 0x20;
	}
	pw = getpwnam(fullname);
	if ( pw != (struct passwd *) 0 ) {
	    cbuf = fullname;
	    while ( (*pw->pw_gecos != ',') && (*pw->pw_gecos != '\0') ) {
		if ( *pw->pw_gecos == '&' ) {
		    strcat(cbuf,samename);
		    cbuf += (strlen(samename)+2);
		    pw->pw_gecos++;
		    cbuf++;
		    continue;
		}
		*cbuf++ = *pw->pw_gecos++;
	    }
	    *cbuf++ = ' ';
	    *cbuf = '\0';
	}
	else strcpy(fullname,"??? ");
	cbuf = ctime(&utmp.ut_time);
	sprintf(fulldate,"%.12s ", cbuf+4);
	if (utmp.ut_host[0])
		sprintf(hname,"(%.*s)", HMAX, utmp.ut_host);
	else strcpy(hname, " ");
	
	strcpy(junkline,utnam);
	strcat(junkline,utline);
	strcat(junkline,fulldate);
	strcat(junkline,hname);
	curUsers[numUsers].fname = stindex;
	strcpy(stindex,fullname);
	stindex += (strlen(fullname)+2);
	curUsers[numUsers].info = stindex;
	strcpy(stindex,junkline);
	stindex += (strlen(junkline)+2);
}

int PackResults( fxdr, fuptr )
    XDR *fxdr;
    UserRec *fuptr;
{
    int i;
    
    xdr_int( fxdr, &numUsers );
    for( i = 0; i < numUsers; i++ ) {
	xdr_string( fxdr, &curUsers[i].fname, 200 );
	xdr_string( fxdr, &curUsers[i].info, 200 );
    }
}
