#include "HRPC/basicRpc.h"
#include <HRPC/CIncludes/Binding_defs.h>
#include "SrvIF.h"
#define HRPC_SERVER
#include "ClIF.h"

HRPCBinding **meAsServer;
SpeakDefs_Speak prefs[3];
BINDING_DESCR myBD;

HRPCBinding *toServer;

main(argc, argv)
    int  argc;
    char *argv[];
{
    char machine[80];
    LongInteger startRes;
    int reuse = 0;
    int rexp  = 0;
    int reps  = 0;
    int nexported;
    int expFlags;
    HRPCErrRec *hrpcerr;

    while ( argc > 1 ) {
	if ( !strcmp(argv[argc-1], "rexp") )
	    rexp++;
	else
	if ( !strcmp(argv[argc-1], "reuse") )
	    reuse++;
	else
	    reps = atoi(argv[argc-1]);
	argc--;
    }
    
    /*
     * First import the real server.
     */
    printf("server machine? ");
    gets(machine);
    hrpcerr = SrvIF_Import(machine, &toServer);
    if ( hrpcerr ) {
	HRPCperror( hrpcerr );
	exit( 1 );
    }

    /*
     * Now export ourselves...
     */
    prefs[0] = SUN_XDR_TCP;
    prefs[1] = INVALID_SPEAK;
    nexported = 1;
    expFlags = EXPF_CALLBACK;

    ClIF_Export("anonymous", &expFlags, prefs, &nexported, &meAsServer);
    printf("ExpFlags: %d, nexported: %d.\n",expFlags, nexported);
    
    /*
     * Convert my server binding to a binding descriptor.
     */
    ConvBindingToBD( meAsServer[0], &myBD );
    PrintBD( &myBD );
    
    /*
     * Call the server asking to start a "session".
     */
reconnect:
    printf("Calling SrvIF_Connect...\n");
    SrvIF_Connect( toServer, &myBD, &startRes );
    if ( startRes ) {
	printf("Server rejects connection: %d.\n",startRes);
	exit( 1 );
    }
    else {
	printf("...connected.\n");
    }

    /*
     * Send over an a request to perform some operation. Actually
     * content is ignored on the other side.
     */
again:
    SrvIF_Doit( toServer, 1, &startRes );
    if ( startRes != 99 ) {
	printf("Gack! Can't request.\n");
	exit( 1 );
    }
    
    /*
     * Sit in server loop waiting for callback.
     */
    MyClIF_Server( 1, meAsServer );
    reps--;
    if ( reps > 0 ) goto again;

    printf("Finished reps, want more? ");
    scanf("%d",&reps);
    if ( reps > 0 ) goto again;
    SrvIF_Disconnect( toServer, 1, &startRes );
    if ( startRes != 98 ) {
	printf("Botched disconnect reply.\n");
    }
    if ( reps == 0 )
	exit( 0 );
    else {
	reps = -reps;
	goto reconnect;
    }
}

MyClIF_Server( fNB, fBptr )
	int fNB;
	HRPCBinding *fBptr[];
{
	long procnum;
	long programnum;
	long versionnum;
	HRPCBinding *readyBptr;
	int  status;

	for (;;) {
		HRPCDispatcher(fNB, fBptr, &readyBptr);
		(*readyBptr->rpcDescr.InitIncoming)(readyBptr,
			&programnum, &versionnum, &procnum, &status, 0 );
		if ( status ) {
		    printf("Bad InitIncoming status: %d.\n",status);
		    continue;
		}
		/* FIXME: should check prog# & vers# here */
		switch( procnum ) {
		case 2:
			server_ClIF_Ask( readyBptr );
			break;
		case 1:
			server_ClIF_Done( readyBptr );
			return;
			break;
		default:
			fatalerr("ClIF_Server: no such procedure no.: %d\n",procnum);
		} /* switch */
	} /* for */
}

/*
 * Server routines for client.
 */

void ClIF_Ask( fBptr, fPrompt, fVal )
    HRPCBinding *fBptr;
    String fPrompt;
    LongInteger *fVal;
{
    printf("Server asks: %s.\n> ",fPrompt);
    scanf("%d",fVal);
/*
    *fVal = 1;
 */
}

void ClIF_Done( fBptr, fRetVal, fThanks )
    HRPCBinding *fBptr;
    LongInteger fRetVal;
    LongInteger *fThanks;
{
    printf("Server says it's done, returns: %d.\n",fRetVal);
    *fThanks = 1;
}

PrintBD( fBD )
    BINDING_DESCR *fBD;
{
    Binding_SUN_XDR_TCP_BINDING_DESCR *bdptr;

    bdptr = &(fBD->data.SUN_XDR_TCP_case);
    printf("Descriptor:\n");
    printf("  Speak: %d, prog: %d, port: %d, addr: %x\n",
	   (int) fBD->data.designator,
	   bdptr->progNum, bdptr->portNum, *(int *)&bdptr->ipAddr);
}
