#define HRPC_SERVER
#include <HRPC/LWP/mssLWP/lwp.h>
#include <sys/time.h>
#include <HRPC/LWP/kEvents.h>
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include "remoteAdd.h"
#include <HRPC/Transports/connDefs.h>
#include <stdio.h>
char directory[100];

extern int LWP_InitializeProcessSupport();
extern int LWP_TerminateProcessSupport();
extern int LWP_CreateProcess();
extern int LWP_DestroyProcess();
extern int LWP_WaitProcess();
extern int LWP_MwaitProcess();
extern int LWP_NoYieldSignal();
extern int LWP_DispatchProcess();

#define MAXEXPBINDS 10

main( argc, argv )
    int  argc;
    char *argv[];
{
    SpeakDefs_Speak myPrefs[3];
    HRPCBinding **sBindings;
    int nbindings;
    int autoact = 0;
    PROCESS pid[10], mypid;
    char    *cptr, name[20], *Args[10];
    int     jj, ii, i, j, count, remoteAddProc();
    HRPCBinding	    ***fBindingsArr;
    HRPCBinding     **temp2fBptr, *tempfBptr;
    BINDING_DESCR   tempfBD;

        setbuf(stdout,NULL);
    LWP_InitializeProcessSupport(3, &mypid);
    i = SetupLwpSupport(LWP_CreateProcess, LWP_DestroyProcess,
				LWP_WaitProcess, LWP_MwaitProcess,
				LWP_NoYieldSignal, LWP_DispatchProcess);
    if ( i != LWP_SUCCESS ) {
        printf("\terror initializing support: code=%d\n",i);
        exit(1);
    }

    if ( argc > 1 && !strcmp(argv[1],"-B") ) {
	myPrefs[0] = SUN_XDR_TCP;
	myPrefs[1] = COURIER_COURIER_SPP;
	nbindings = 2;
	count = 2;
	printf("speaking SUN_XDR_TCP & COURIER_COURIER_SPP...\n");
    }
    else if ( argc > 1 && !strcmp(argv[1],"-T") ) {
	    myPrefs[0] = SUN_XDR_TCP;
	    count = 2;
	printf("speaking SUN_XDR_TCP...\n");
    }
    else {
	    myPrefs[0] = SUN_XDR_UDP;
	    count = 1;
	printf("speaking SUN_XDR_UDP...\n");
    }
    nbindings = 1;
    myPrefs[nbindings] = INVALID_SPEAK;
    if ( argc <= count )
        count = 1;
    else
        count = atoi(argv[count]);
 
	printf("attempt export\n");
    remoteAdd_Export( "Dummy", & autoact, myPrefs, &nbindings, &sBindings );
    printf("returned exp flags: %d.\n",autoact);
    printf("number of bindings: %d.\n",nbindings);
    fprintf(stderr,"Here is a line to stderr.\n");
    fprintf(stderr,"Current directory is: %s,\n",getwd(directory));
    
    if ( autoact & EXPF_AUTOACT ) {
	struct timeval tmo;

	tmo.tv_sec  = 30;
	tmo.tv_usec =  0;
	HRPCSetRequestTMO( &tmo, 0);
    }
	/* Use sBindings for first set of bindings.  HRPCExport NULL terminated
	 * the list in sBindings.  All subsequent sets of bindings will be
	 * "copies" of sBindings. */
    fBindingsArr = (HRPCBinding ***) calloc(count, sizeof(HRPCBinding **) );
    fBindingsArr[0] = sBindings;

    for ( ii=1; ii < count; ii++ ) {
	    /* create new set of bindings that match sBindings */
	fBindingsArr[ii] = (HRPCBinding **) calloc( nbindings + 1,
						sizeof(HRPCBinding *) );
	if ( fBindingsArr[ii] == (HRPCBinding **) NULL ) {
		fatalerr("remoteAddProc: can't alloc return binding space.\n");
        }
	for ( jj=0; jj < nbindings; jj++ ) {
	    ConvBindingToBD(sBindings[jj],&tempfBD);
	    ConvBDtoBinding(&tempfBD,&tempfBptr);
	    tempfBptr->transDescr.sockfd = sBindings[jj]->transDescr.sockfd;
	    tempfBptr->connState = CONN_IDLE;
	    tempfBptr->transDescr.packetArrived = 0;
	    fBindingsArr[ii][jj] = tempfBptr;
	}
	fBindingsArr[ii][nbindings] = sBindings[nbindings];
    }
    Args[0] = (char *) nbindings;
    printf("\n\t\t\tcreate processes\n");
    for ( i = 0; i < count; i++ ) {
        sprintf(name,"ADDER_%d",i);
	/* printf("\t...%s\n",name); */
	    /* pass new bindings to remoteAdd_Server */
        Args[1] = (char *) fBindingsArr[i];
        j = LWP_CreateProcess(remoteAddProc,16384,LWP_NORMAL_PRIORITY,
                        Args,name,&(pid[i]));
        if ( j != LWP_SUCCESS ) {
            printf("\terror starting up process %d: code=%d\n",i,j);
            exit(1);
        }
    }
    pid[count] = 0;
     
    cptr = (char *) pid;
    LWP_MwaitProcess(count,cptr);
 
    TerminateLwpSupport();
    LWP_TerminateProcessSupport();
}
int     remoteAddProc(Args)
    char        *Args[];
{
	int		i, nbindings;
        HRPCBinding	**sBindings;
 
	nbindings = (int) Args[0];
	sBindings = (HRPCBinding **) Args[1];

	remoteAdd_Server( nbindings, sBindings );
}
    
void remoteAdd_Add( fBptr, n1, n2, ans )
    HRPCBinding *fBptr;
    LongInteger n1;
    LongInteger n2;
    LongInteger *ans;
{
	int                     kk, i, ii, sigsheldprevious;
	char	*temp, temp2[2];
#ifdef DEBUG
printf("Add routine called, inputs are %d and %d.\n",n1,n2);
#endif

	temp = (LWP_ActiveProcess)->name;
	temp2[0] = temp[6];
	temp2[1] = '\0';
	ii = atoi(temp2);
	if ( ii < 0 || ii > 10 )
		fatalerr("remoteAdd_Add\n");
	if ( SigsHeld )
            sigsheldprevious = 1;
        else {
            sigsheldprevious = 0;
            HoldSigs(); /* disable interruption by HRPC_SignalHandler */
	}
#ifdef DEMO
	printf("\t");
	for ( i=0; i<=ii; i++ )
	    printf("\t");
    printf("%s: add %d & %d\n",temp,n1,n2);
#endif DEMO
	if ( !sigsheldprevious )
            ReleaseSigs();      /* enable interrupts */
    *ans = n1 +n2;
	for ( kk=0; kk < 6000; kk++ )
		;
    LWP_DispatchProcess();
	if ( SigsHeld )
            sigsheldprevious = 1;
        else {
            sigsheldprevious = 0;
            HoldSigs(); /* disable interruption by HRPC_SignalHandler */
	}
#ifdef DEMO
	printf("\t");
	for ( i=0; i<=ii; i++ )
            printf("\t");
    printf("%s: ret ans of %d\n",temp,*ans);
#endif DEMO
	if ( !sigsheldprevious )
            ReleaseSigs();      /* enable interrupts */
#ifdef DEBUG
printf("Answer is %d.\n",*ans);
#endif
}
