/****************************************************************
 * Test program for HRPC remoteAdd interface			*
 ****************************************************************/

#include <HRPC/LWP/mssLWP/lwp.h>
#include <HRPC/LWP/kEvents.h>
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "remoteAdd.h"
#include <HRPC/hrpcErrCodes.h>
#include <stdio.h>

extern int LWP_InitializeProcessSupport();
extern int LWP_TerminateProcessSupport();
extern int LWP_CreateProcess();
extern int LWP_DestroyProcess();
extern int LWP_WaitProcess();
extern int LWP_MwaitProcess();
extern int LWP_NoYieldSignal();
extern int LWP_DispatchProcess();
extern HRPCErrRec *remoteAdd_Import();
int	getMachFlag = 1;

main( argc, argv )
    int  argc;
    char *argv[];
{
	int ADDER();
        int     i, j, count;
        char    *cptr, name[20];
        PROCESS pid[10], mypid;

        setbuf(stdout,NULL);
	LWP_InitializeProcessSupport(3, &mypid);
	i = SetupLwpSupport(LWP_CreateProcess, LWP_DestroyProcess,
				LWP_WaitProcess, LWP_MwaitProcess,
				LWP_NoYieldSignal, LWP_DispatchProcess);
        if ( i != LWP_SUCCESS ) {
                printf("\terror initializing support: code=%d\n",i);
                exit(1);
        }
        if ( argc <= 1 ) {
                count = 1;
        } else {
	    i = 1;
	    if ( strcmp(argv[1],"-M") == 0 ) {
		getMachFlag = 0; i++; }
            count = atoi(argv[i]);
	}

        printf("create processes\n");
        for ( i = 0; i < count; i++ ) {
        sprintf(name,"ADD_%d",i);
        j = LWP_CreateProcess(ADDER,16384,LWP_NORMAL_PRIORITY,0,name,&(pid[i]));
                if ( j != LWP_SUCCESS ) {
                        printf("\terror starting up process %d: code=%d\n",i,j);                        exit(1);
                }
        }
        pid[count] = 0;

        cptr = (char *) pid;
	LWP_MwaitProcess(count,cptr);
 
	TerminateLwpSupport();
        LWP_TerminateProcessSupport();
}
 
int ADDER()
{
    HRPCBinding *bptr = (HRPCBinding *) 0;
    LongInteger sum;
    LongInteger n1, n2;
    char machine[80];
    char oldmachine[80];
    char linebuf[80];
    HRPCErrRec *impstat;
	int sigsheldprevious, ii, i, j, firstFlag = 1;
        char    *name,temp[2];
        PROCESS mypid;
    
    strcpy(oldmachine,"Big piece of junk");
	mypid = LWP_ActiveProcess;
        name = mypid->name;
	temp[0] = name[4];
	temp[1] = '\0';
	ii = atoi(temp);
	if ( ii < 0 || ii > 10 )
                fatalerr("ADDER\n");
	if ( !getMachFlag ) strcpy(machine,"roskilde");

    while ( 1 ) {
    if ( getMachFlag ) {
	if ( SigsHeld )
            sigsheldprevious = 1;
        else {
            sigsheldprevious = 0;
            HoldSigs(); /* disable interruption by HRPC_SignalHandler */
        }
#ifdef DEMO
        printf("\t");
        for ( i=0; i<=ii; i++ )
            printf("\t");
#endif DEMO
	printf("%s: machine? ",name);
	gets(linebuf);
	if ( !sigsheldprevious )
            ReleaseSigs();      /* enable interrupts */
	sscanf(linebuf,"%s",machine);
	if ( !strcmp(machine,"quit") ) break;
    }
	 
	if ( strcmp(machine,oldmachine) ) {
	    strcpy(oldmachine,machine);
	    if ( bptr ) CloseHRPCBinding(bptr);
	    printf("%s: Import new remote interface..\n",name);
	    impstat = remoteAdd_Import(machine,&bptr);
	    if ( impstat ) {
		HRPCperror( impstat );
		continue;
	    }
	}
	if ( SigsHeld )
            sigsheldprevious = 1;
        else {
            sigsheldprevious = 0;
            HoldSigs(); /* disable interruption by HRPC_SignalHandler */
        }
#ifdef DEMO
        printf("\t");
        for ( i=0; i<=ii; i++ )
            printf("\t");
#endif DEMO
	printf("%s: Two #s to add? ",name);
	if ( gets(linebuf) == NULL )
		break;
	if ( !sigsheldprevious )
            ReleaseSigs();      /* enable interrupts */
	sscanf(linebuf,"%d %d",&n1, &n2);
	printf("main: call remoteAdd_Add\n");
	impstat = remoteAdd_Add( bptr, n1, n2, &sum );
	printf("main: remoteAdd_Add returns\n");
	if ( SigsHeld )
            sigsheldprevious = 1;
        else {
            sigsheldprevious = 0;
            HoldSigs(); /* disable interruption by HRPC_SignalHandler */
        }
#ifdef DEMO
        printf("\t");
        for ( i=0; i<=ii; i++ )
            printf("\t");
#endif DEMO
	if ( impstat )
	    HRPCperror( impstat );
	else
	    printf("%s: Sum is: %d\n",name,sum);
	if ( !sigsheldprevious )
            ReleaseSigs();      /* enable interrupts */
	LWP_DispatchProcess();
    }
    if (bptr != (HRPCBinding *) NULL)
        CloseHRPCBinding(bptr);
    j  = LWP_NoYieldSignal((char *)mypid);
        if ( j != LWP_SUCCESS )
            printf("%s: error signalling: code=%d\n",name,j);
}
