/****************************************************************
 * Test program for HRPC remoteAdd interface			*
 ****************************************************************/

#include <HRPC/basicRpc.h>
#include "remoteAdd.h"
#include <HRPC/hrpcErrCodes.h>
#include <netinet/in.h>

extern HRPCErrRec *remoteAdd_Import();

main( argc, argv )
    int  argc;
    char *argv[];
{
    HRPCBinding *bptr;
    LongInteger sum;
    LongInteger n1, n2;
    char machine[80];
    char oldmachine[80];
    char linebuf[80];
    HRPCErrRec *impstat;
    struct sockaddr_in *sptr;
    int reverse = 0;
    
    strcpy(oldmachine,"Big piece of junk");

    if ( (argc > 1) && (!strcmp("-R",argv[1]) ) ){
	reverse = 1;
    }
    
    while ( 1 ) {
	printf("machine? ");
	gets(linebuf);
	sscanf(linebuf,"%s",machine);
	if ( !strcmp(machine,"quit") ) exit( 0 );
	if ( strcmp(machine,oldmachine) ) {
	    strcpy(oldmachine,machine);
	    printf("Import new remote interface..\n");
	    impstat = remoteAdd_Import(machine,&bptr);
	    if ( impstat ) {
		HRPCperror( impstat );
		continue;
	    }
	    sptr = (struct sockaddr_in *) &(bptr->transDescr.netAddr);
	    printf("Addr: AF = %d, port = %d, addr = %08x\n",
		sptr->sin_family, ntohs(sptr->sin_port),
		ntohl(sptr->sin_addr.s_addr));
	    if ( reverse ) {
		sptr->sin_port = ntohs(sptr->sin_port);
	    }
	}
	
	printf("Two numbers to add? ");
	gets(linebuf);
	sscanf(linebuf,"%d %d",&n1, &n2);
	impstat = remoteAdd_Add( bptr, n1, n2, &sum );
	if ( impstat )
	    HRPCperror( impstat );
	else
            printf("Sum is: %d.\n",sum);
    }
}
