#ifndef lint
static char RCSid[] = "$Header: main.c,v 3.1 87/04/05 17:58:44 kimi Exp $";
#endif


#include "compiler.h"
#include <errno.h>
#include <signal.h>

char *input_file;
static char header_file[MAXSTR];
FILE *header;
static char *header1_file[MAXSTR];
FILE *header1;
static char lcheader_file[MAXSTR];
FILE *lcheader;
static char lsheader_file[MAXSTR];
FILE *lsheader;
static char support_file1[MAXSTR];
FILE *support1;
static char support_file2[MAXSTR];
FILE *support2;
static char client_file[MAXSTR];
FILE *client;
static char server_file[MAXSTR];
FILE *server;

list Procedures, Errors;
int recursive_flag, errs;

struct type *Boolean_type, *Cardinal_type, *LongCardinal_type,
	*Integer_type, *LongInteger_type, *String_type,
	*Unspecified_type, *LongUnspecified_type, *NilRecord_type,
	*StreamEnum_type, *Lispval_type;

int transportType = BOTH;
int bindHack = 0;		/* 1 ==> don't go through fakeNS */
int chkProgNum = 1;		/* 0 ==> don't check binding prog# in client */

int registerOption = 1;		/* default for file types */
extern int fileDefined;		/* defined in fileaccess.c */

int freeResults = 1;	/* changed by pragma processing in scanner.l */

char clientLanguage = 'c';         /* default to C.  LISP == 1 */
char serverLanguage = 'c';

#ifdef DEBUG
int DebugFlag = 0;
#endif


interrupt()
{
	errs = 1;
	goodbye();
}

main(argc,argv)
	int argc;
	char **argv;
{
	if (argc < 2) {
usage:
		fprintf(stderr,
			"Usage: %s [-c{c,l}] [-s{c,l}] input_file\n",argv[0]);
		exit(1);
	}
	while ( argv[1][0] == '-' ) {
/*****
	    if ( !strcmp(&argv[1][1],"UDP") ) transportType = UDP;
	    else
	    if ( !strcmp(&argv[1][1],"TCP") ) transportType = TCP;
	    else
*****/
	    if ( !strcmp(&argv[1][1],"bhack") ) bindHack = 1;
	    else
	    if ( !strcmp(&argv[1][1],"nchk") ) chkProgNum = 0;
/*****
	    else
	    if ( !strcmp(&argv[1][1],"rt") || !strcmp(&argv[1][1],"rT") )
	     	registerOption = 1;
	    else
	    if ( !strcmp(&argv[1][1],"rf") || !strcmp(&argv[1][1],"rF") )
	      registerOption = 0;
*****/
	    else
	    if ( argv[1][1] == 'c' ) clientLanguage = argv[1][2];
	    else
	    if ( argv[1][1] == 's' ) serverLanguage = argv[1][2];
		
  
	    else goto usage;
	    argv++;
	}
	input_file = argv[1];
	if (freopen(input_file, "r",stdin) == NULL) {
		perror(input_file); exit(1);
	}
	tempname(header_file);
	tempname(header1_file);
	tempname(lcheader_file);    /* for lisp */
	tempname(lsheader_file);
	tempname(client_file); 
	tempname(server_file);
	tempname(support_file1);   /* these 2 become otw */
	tempname(support_file2);
	if ((header = fopen(header_file,"w")) == NULL) {
		perror(header_file); 
		goodbye();
	}
	if ((header1 = fopen(header1_file,"w")) == NULL) {
		perror(header1_file); 
		goodbye();
	}
	if ((lcheader = fopen(lcheader_file,"w")) == NULL) {
		perror(lcheader_file); 
		goodbye();
	}
	if ((lsheader = fopen(lsheader_file,"w")) == NULL) {
		perror(lsheader_file); 
		goodbye();
	}
	if ((client = fopen(client_file,"w")) == NULL) {
		perror(client_file); 
		goodbye();
	}
	if ((server = fopen(server_file,"w")) == NULL) {
		perror(server_file); 
		goodbye();
	}
	if ((support1 = fopen(support_file1,"w")) == NULL) {
		perror(support_file1); 
		goodbye();
	}
	if ((support2 = fopen(support_file2,"w")) == NULL) {
		perror(support_file2); 
		goodbye();
	}
	setup_predefs();

        setup_languages(clientLanguage, serverLanguage);

	(void) yyparse();
	(void) fclose(client); 
	(void) fclose(server);
	if (errs == 0) {
		register int c;

		if (Procedures != NIL) {
		    changename(client_file, "_client", clientLanguage);
		    if (!fileDefined) {
			changename(server_file, "_server", serverLanguage);
			} else {
			    (void) unlink(server_file);
			};
		} else {
			(void) unlink(client_file);
			(void) unlink(server_file);
		}


		/* C headers are always created, but not necessarily used */
		if (clientLanguage == 'c' || serverLanguage == 'c') {
		    (void) fclose(header1);
		    (void) fclose(header); 
		    changename(header_file, "", 'h');
		    changename(header1_file, "_defs",'h');
   		    
		    freopen(support_file2, "r", support2);
		    while ((c = getc(support2)) != EOF)
			(void) putc(c, support1);
		    (void) fclose(support1); 
		    (void) fclose(support2);
		    (void) unlink(support_file2);
		    changename(support_file1, "_otw", 'c');
		} else {
		    (void) unlink(header_file);
		    (void) unlink(header1_file);
		    (void) unlink(support_file1);
		    (void) unlink(support_file2);
		};

		if (clientLanguage == 'c' && serverLanguage == 'c') {
		    (void) unlink(lcheader_file);
		    (void) unlink(lsheader_file);
		} else {
		    (void) fclose(lcheader); 
		    changename(lcheader_file, "_defs", clientLanguage);

	            if (clientLanguage == serverLanguage) {
			(void) unlink(lsheader_file);
		    } else {
			(void) fclose (lsheader);
			changename (lsheader_file, "_defs", serverLanguage);
		    };
		    
		};
	}
	goodbye();

}


goodbye()
{
	if(errs) {
		(void) unlink(header_file);
		(void) unlink(header1_file);
		(void) unlink(lcheader_file);
		(void) unlink(lsheader_file);
		(void) unlink(client_file);
		(void) unlink(server_file);
		(void) unlink(support_file1);
		(void) unlink(support_file2);
	}
	exit(errs);
}

/*
 * Rename the source file to be <CurrentProgram><suffix> .
 */
changename(source, suffix, extension)
	char *source, *suffix, extension;
{
	char newname[MAXSTR];

	(void) sprintf(newname, "%s%s.%c", 
			CurrentProgram, suffix, extension);
	if (rename(source, newname) == -1)
		perror(newname);
}

/* VARARGS1 */
error(level, s, args)
	enum severity level;
	char *s;
{
	extern int yylineno;

	fprintf(stderr, "%s: %d: ", input_file, yylineno);
	if (level == WARNING)
		fprintf(stderr, "Warning: ");
	_doprnt(s, &args, stderr);
	(void) putc('\n', stderr);
	if (level == ERROR)
		errs++;
	if (level == FATAL)
		goodbye();
}

yyerror(s)
	char *s;
{
	error(ERROR, s);
}

tempname(bclient)
	char *bclient;
{
	static int n = 0;

	sprintf(bclient, "tmp%d.%d", n, getpid());
	n++;
}

struct type *
predefine_enum_type(name,elements)
	char *name;
	char **elements;
{
	struct object *symbol;
	list dlist;
	struct type *resulttype;
	char *id, *value;
	
	dlist = NIL;
	for ( ; *elements != (char*)NULL; elements += 2) {
		id = *elements;
		value = *(elements+1);
		if (check_def(id, (char*)NULL))
		  error(FATAL,"in predefine_enum_type, %s already declared",
			id);
		symbol = make_symbol(id, (char*)NULL);
		define_enumeration_symbol(symbol, value);
		dlist = cons(cons((list) symbol, (list) value),
			     dlist);
	}
	resulttype = enumeration_type(dlist);
	resulttype->type_name = name;
	resulttype->type_xsize = 1;
	return(resulttype);
}

#define PREDEFINE(xtype, xname, nwords, constr) { \
	xtype = make_type(constr); \
	xtype->type_name = xname; \
	xtype->type_xsize = nwords; \
	xtype->courBaseType = (char) 1; \
}

/*
 * This mess is needed because C doesn't handle initialization of unions.
 * Note that all of these must correspond to declarations, plus sizeof_,
 * externalize_, and internalize_ functions, in courier.h
 */
setup_predefs()
{
	static char *streamvals[] = {"nextSegment","0","lastSegment","1",
				     (char*)0};
#ifndef lint
	PREDEFINE(Boolean_type, "Boolean", 1, C_BOOLEAN);
	PREDEFINE(Cardinal_type, "Cardinal", 1, C_NUMERIC);
	PREDEFINE(LongCardinal_type, "LongCardinal", 2, C_NUMERIC);
	PREDEFINE(Integer_type, "Integer", 1, C_NUMERIC);
	PREDEFINE(LongInteger_type, "LongInteger", 2, C_NUMERIC);
	PREDEFINE(String_type, "String", -1, C_STRING);
	PREDEFINE(Unspecified_type, "Unspecified", 1, C_NUMERIC);
	PREDEFINE(LongUnspecified_type, "LongUnspecified", 2, C_NUMERIC);
	PREDEFINE(NilRecord_type, "NilRecord", 0, C_RECORD);
	StreamEnum_type = predefine_enum_type("StreamEnumerator", streamvals);
	PREDEFINE(Lispval_type, "Lispval", -1, C_CHOICE);
#endif
}
