
/* File: fileaccess.c  Date: August 24, 1986 Kimi Gosney
 *
 *
 *
 * $Log:	fileaccess.c,v $
 * Revision 1.7  86/12/23  01:24:47  kimi
 * with DataString emitted to headers (see also courier.y, vers 2.3)
 * 
 * Revision 1.5  86/12/14  01:17:33  kimi
 * before tinkering w/choice type dataStrings...
 * 
 * Revision 1.4  86/12/06  21:40:32  kimi
 * almost ready, just checkpointing...
 * 
 */

/*
 * INTERFACE:	define_filetype()
 *
 * FUNCTION:	called by stub compiler generator to handle recognition
 *		of a FileDeclaration
 *
 *   INPUT: 	Type : pointer to a typtr
 *   OUTPUT:	code to files
 *
 * IMPORTS:	compiler.h
 *		GetTypeUID() from GetTypeUID.c
 *		make_fileaccess_procs() from fileprocedures.c
 *		CurrentProgram,recursive_flag, registerOption from main.c
 *		typeStatusText[] from FileSystemStatusText.h
 *		DEPENDS UPON FileComponents module, Program number 7001,
 *			Version 1.  This dependency is compiled in.
 *
 * EXPORTS:	define_filetype(), ExtractTypeDesc()
 *		Boolean fileDefined
 *		String FileTypeName, typeDesc
 *
 * DESIGN:	check that this is an acceptable type (ie predefined, or a
 *		  constructed type that is not a procedure)
 *		GetTypeUID() from the TypeServer
 *		Call make_fileaccess_procs() in fileprocedures.c to
 *		  define all the automatically created arguments and return
 *		  variables for the file access procedures and
 *		  generate code for the file access procedures.
 *		Note that the file-type-ID is part of these arg lists, but
 *		is not manipulated by the user.  The fileDefined flag
 *		causes the code-emitting procedures in procedures.c to
 *		skip it as an argument when procedures are written into
 *		*_client.c, but to send it over-the-wire sub rosa.
 *
 *		Note the dependency on FileComponents.
 *	   >>>>	Also, note that WCS is assumed to be PROGRAM 3265 Version 1. <
 */



# include "compiler.h"

extern void GetTypeUID();		/* from GetTypeUID.c */
extern char *typeStatusText[];		/* from FileSystemStatusText.h */

extern error();					/* from main.c */
extern registerOption;


						/* from fileprocedures.c */
extern void make_fileaccess_procs();

					/* actually later in this file */
extern void itoReverseda();


		/* sizes come from TypeRegistry.cr */
char FileTypeName[50];
# define MAXTYPEDESC 250
char typeDesc[MAXTYPEDESC];

int indexIntoTypeDesc;

#ifdef BOOTVERS
extern int errs;
int fileDefined = 0;

void define_filetype()
{
    fprintf(stderr,"Cannot access WCS with bootstrap stubgenerator\n");
    errs = 1;
    goodbye();
}

ExtractTypeDesc()
{
    fprintf(stderr,"Cannot access WCS with bootstrap stubgenerator\n");
    errs = 1;
    goodbye();
}

#else BOOTVERS

int fileDefined = 0;   /* FALSE */
		/* set in setUpForIFS() in fileprocedures.c, used there.
		   also used in procedures.c, wrapup_program() in code.c.
		   Also causes main.c not to emit server code.
		 */

# include "TypeRegistry.h"
# include "FileSystemStatusText.h"

/*********************************************************************/

void
define_filetype( fileTyptr )
	struct type *fileTyptr;
   {
	char 	*tname, *procedName;

	int	counter = 0;
	Boolean newlyRegistered;
	LongCardinal typeUID;
	TypeRegistry_StatusCode returnStatus;
     



     /* make reference to support files, if it hasn't already been seen */

	if ( !check_module_def ("FileComponents", "7001", "1") ) {
	    ref_program ("FileComponents", "7001", "1");
	} else {
	    /* this may be a duplicate, but if the previous version was a
	       included file, this text got thrown away when we popped
	       back up to this level, so we put it in again */
	       fprintf (header,"\n\n/* DEPENDS UPON FileComponents NUMBER 7001 VERSION 1 */\n");
	       fprintf(header,"# include <HRPC/CIncludes/FileComponents.h>\n");
	};

     /* get typeDesc from fileTyptr */
	typeDesc[0] = '\0';	/* default for degenerate case */
	indexIntoTypeDesc = 0;
	if (ExtractTypeDesc ( fileTyptr, &indexIntoTypeDesc, TRUE ) == 0) {

	    /* for consistency with non-File types, we do this before the
	       name hacking stuff. It defines the dataString in .h file. 
	    if (!recursive_flag)
	    	emit_typeDesc ( typename(fileTyptr), typeDesc);

	--	commented out.  if put back, also need similar activity
		in courier.y at recognition of type decl.
	    */
     /* hack the name, so that we clip out the currentProgram prefix,
	unless is base type (which doesn't have one) */

	   if (fileTyptr->courBaseType) {
	        strcpy (FileTypeName, fileTyptr->type_name);
	   }
	   else {	       
		tname = fileTyptr->type_name;
		while (*tname++ != '_') {};
		while ((FileTypeName[counter++] = *tname++) != '\0') {};
	   };
	
     /* get TypeUID from TypeServer -- remote call */

#ifdef DEBUG
	   printf ("testing GetTypeUID() using %s\n", input_file);
	   printf ("registerOption is %d\n", registerOption);

#endif


	   GetTypeUID (FileTypeName, typeDesc, input_file,
			registerOption, &returnStatus, &typeUID);




	  if ( returnStatus != TR_newlyRegistered
	  	&& returnStatus != TR_reRegistered
		&& returnStatus != TR_alreadyRegistered )
             { 
#ifdef DEBUG
		printf ("got typeUID of %d, failing returnStatus of %s\n",
	     		typeUID, typeStatusText[(int)returnStatus]);
#endif
		if (returnStatus == TR_notRegisteredByRequest) {
		    fprintf (stderr, "\tNew type, not registered by user choice,\n\tor because syntax errors have been detected by the stub compiler.\n\tNo file access procedures are generated.\n");
		    exit(2);
		};

		fprintf( stderr, "Type not registered.  Quitting.  Return status is %s\n",
		 	typeStatusText[(int)returnStatus]);
		exit(1);
	     }
	     else {
#ifdef DEBUG
		 printf( "type UID is %d and successful returnStatus is %s\n",
			typeUID, typeStatusText[(int)returnStatus]);
#endif

	     };




     /* output type specific procedures */

	make_fileaccess_procs (	fileTyptr, typeUID);
	     


	};     /* end of if ExtractTypeDesc.... */




       };


/**********************************************************/
/* walks typtr, and at each node drops the short form, fileDescription
   character into the typeDesc array.
   In the process, it also checks to see that all elements of the description
   are legal components of a FILETYPE.

   If called here, IsFileType is true, and enumeration, procedure and
   error types are disallowed.  If called from courier.y upon
   recognizing a " : TYPE = " etc construction, IsFileType will
   have been set to false, and anything is allowed.
*/

int
ExtractTypeDesc (fileTyptr, ptrToIndexIntoTypeDesc, IsFileType)
	struct type *fileTyptr;
	int *ptrToIndexIntoTypeDesc;
	Boolean IsFileType;

	{ list p,q;
	  int i, typeDescErrs = 0, charno;
	  char ascSize[20], *s;


  	  switch ( fileTyptr -> type_constr ) {
	    case C_NUMERIC:
	       if (fileTyptr->courBaseType == TRUE) {
		   s = fileTyptr->type_name;	/* more convenient ptr */
		   if (streq (s,"LongCardinal")) 
		       typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'D';
		   else if (streq (s,"Cardinal")) 
		       typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'C';
		   else if (streq (s,"Integer")) 
		       typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'I';
		   else if (streq (s,"LongInteger")) 
		       typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'L';
		   else if (streq (s,"Unspecified")) 
		       typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'U';
		   else if (streq (s,"LongUnspecified")) 
		       typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'P';
		   else {
		       typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'X';
		           error (ERROR,
				"\ninvalid numeric type in %s",
		                typename(fileTyptr));
		   
	 		   registerOption = FALSE;
			   typeDescErrs++;
		   }
	       }
	       else {
		   typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'X';
	        	error (ERROR,
				"\ninvalid numeric type in %s",
		    		typename(fileTyptr));
			registerOption = FALSE;
			typeDescErrs++;
	       };
	       break;

	    case C_BOOLEAN: typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'B'; break;
	    case C_STRING: typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'S';
		break;

	    case C_RECORD: typeDesc[(*ptrToIndexIntoTypeDesc)++] = '{';
	        for (q = fileTyptr->type_list; q != NIL; q = cdr(q)) {
	
		    typeDescErrs +=
		    	ExtractTypeDesc (cdar(q), ptrToIndexIntoTypeDesc,
				IsFileType);
		};
		typeDesc[(*ptrToIndexIntoTypeDesc)++] = '}';
		break;

	    case C_ARRAY: typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'A';

		itoReverseda (fileTyptr->type_size, ascSize, &charno); 

		while (--charno >= 0) {
		    typeDesc[(*ptrToIndexIntoTypeDesc)++] = ascSize[charno];

		};

		typeDescErrs += ExtractTypeDesc (
		       fileTyptr->type_basetype, ptrToIndexIntoTypeDesc,
		       		IsFileType);

		break;

	    case C_SEQUENCE: typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'Q';

	        itoReverseda (fileTyptr->type_size, ascSize, &charno); 
		
		while (--charno >= 0) {
		    typeDesc[(*ptrToIndexIntoTypeDesc)++] = ascSize[charno];
		};

		typeDescErrs += ExtractTypeDesc (
		       fileTyptr->type_basetype, ptrToIndexIntoTypeDesc,
		       		IsFileType);

		break;

	    case C_CHOICE:   typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'V';
		typeDesc[(*ptrToIndexIntoTypeDesc)++] = '[';

		if (fileTyptr->type_designator == TNIL) {
		    error (ERROR, "\nInternal error: Null candidates for choice type in %s",
		    		typename(fileTyptr));
		    registerOption = FALSE;
		    typeDescErrs++;
		    break;
		};
 
/*		for (q = fileTyptr->type_candidates;
		     p != NIL && q != NIL;
		     p = cdr(p), q = cdr(q)) {

		     struct cons **cchar;
		     char *pchar;
		     *cchar = (cdar(p)->c_cdr);

		for (q = (fileTyptr->type_designator)->type_list,
			q != NIL; q = cdr(q)) {
			    struct cons **cchar;
			    char *pchar;
			    *cchar = cdar(q);
*/

		for (p = fileTyptr->type_candidates; p != NIL; p = cdr(p))
		     for (q = caar(p); q != NIL; q = cdr(q)) {
			itoReverseda (enumvalue_of(caar(q)), ascSize, &charno);
			while (--charno >= 0)
			   typeDesc[(*ptrToIndexIntoTypeDesc)++] =
			   		ascSize[charno];

			       /* for every enum value, go get the base type
			          for that variant, which is defined in terms
				  of p, not q */
		     	 typeDescErrs += ExtractTypeDesc (
		        	cdar(p), ptrToIndexIntoTypeDesc, IsFileType);
			
		     	 typeDesc[(*ptrToIndexIntoTypeDesc)++] = ':';
		     };

 /* end of for... , both on q and p */

		/* when we fall out, back out the last colon */
		(*ptrToIndexIntoTypeDesc)--;

		typeDesc[(*ptrToIndexIntoTypeDesc)++] = ']';
		break;

	    default:
	        if (IsFileType == TRUE) {
		    typeDesc[(*ptrToIndexIntoTypeDesc)++] = '\0';

	            error (ERROR,"\ninvalid type for file construction in %s",
		      typename(fileTyptr));
		    registerOption = FALSE;
		    typeDescErrs++;
		    break;

	        } else {
		    enum constr tmp;
		    
		    /* this part is to put DataString into header for
		       the name server's convenience. called in courier.y.
		    */
		    if ((tmp = fileTyptr-> type_constr) == C_ENUMERATION) {
			typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'E';
			break;
		    } else if (tmp == C_PROCEDURE) {
			typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'Z';
			break;
		    } else if (tmp == C_ERROR) {
			typeDesc[(*ptrToIndexIntoTypeDesc)++] = 'X';
				/* I'm saving R for Real, some day ! */
			break;
		    }; 
	            error (ERROR,"\nInternal error: invalid type in %s",
		      typename(fileTyptr));
		    typeDescErrs++;
		    break;
	       };  /* end else */

	};		/* end switch */



	if (*ptrToIndexIntoTypeDesc >= MAXTYPEDESC) {
	    error (ERROR, "type too complicated.  space for typedesc in fileaccess.c has been exceeded");
	    typeDescErrs++;
	    (*ptrToIndexIntoTypeDesc)--;
	    registerOption = FALSE;
	};



	typeDesc[*ptrToIndexIntoTypeDesc] = '\0';
	return (typeDescErrs);

	};	/* end ExtractTypeDesc */





/*******************************************************************/
/* integer to ASCII, without the usual reversal to make it come out right */

void itoReverseda (n, s, charno)
	char s[];
	int n, *charno;
      { 
        *charno=0;
	do {
	    s[(*charno)++] = n % 10 + '0';
	} while (( n /= 10) > 0);
      };

#endif !BOOTVERS
