/* File:  Lproccode.c  Date:  May 13, 1987 Kimi Gosney  */

/*
 * INTERFACE:	Lclient_proc(), Lserver_proc()
 *
 * FUNCTION:	assigned to the variables (*client_proc)() and (*server_proc)()
 *              called by proc_functions() in procedures.c.  Actually generate
 *              Lisp code for procedures.
 *
 * IMPORTS:	definitions of type, binding
 *
 * EXPORTS:	--
 *
 * DESIGN:     each language has its own procedures for emitting code.  These
 *             are the ones for Lisp.  It takes the names that need to be 
 *             emitted plus a pointer into the symbol table that makes 
 *             additional info available.
 *
 * ACKNOWLEDGMENT :  Analogous to the routines for C, written 
 *             by Jan Sanislo from the Cornell stub generator.
 *
 */

/* $Log:	 $
*/

#define argname(p)	((char *) car(caar(p)))
#define argtype(p)	((struct type *) cdar(p))

#include "compiler.h"
#include <HRPC/cCourierTypes.h>
extern int fileDefined;			/* from fileaccess.c */


/***********************************************************/

/* called by proc_functions() in procedures.c */

char tabs[] = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
# define LENTABS (sizeof(tabs))

#define argname(p)	((char *) car(caar(p)))
#define argtype(p)	((struct type *) cdar(p))

Lserver_proc (procName, procNumber, typtr, fFile)
	char *procName, *procNumber;
	struct type *typtr;
	FILE *fFile;
{
    /* set up vectori for carrying longjmp info back to caller */
      fprintf (fFile,
	"(setq %s_detect_jmp (new-vectori-long 2))\n\n", procName);

    
    ExtractLispPatterns (procName, procNumber, typtr, fFile);

};



Lclient_proc (procName, procNumber, typtr, fFile)
	char *procName, *procNumber;
	struct type *typtr;
	FILE *fFile;
{
    list p;

    /* set up vectori for carrying longjmp info back to caller */
      fprintf (fFile,
	"(setq %s_detect_jmp (new-vectori-long 2))\n\n", procName);

    ExtractLispPatterns (procName, procNumber, typtr, fFile);

    
   fprintf (client, "(defun %s (fBinding ", procName);

    for ( p = typtr->type_args; p != NIL; p = cdr(p)) {
	fprintf (client, "%s ", argname(p));
    };
    fprintf (client, ")\n\
\t(clientTalkLisp fBinding\n\
\t\t%s_detect_jmp\n\t\t%s_arg_pattern\n\
\t\t%s_return_pattern\n\t\t%s_ProgN\n\
\t\t%s\n\t\t%d\n\t\t(list",
		procName, procName,
		procName, CurrentProgram,
		procNumber, CurrentVersion);



    for ( p = typtr->type_args; p != NIL; p = cdr(p)) {
	fprintf (client, " %s", argname(p));
    };
    fprintf (client, "\t\t))\n)\n\n\n");

/*  had tried fexpr

    fprintf (client, "(defun %s fexpr (largs) \n", procName);

    fprintf (client, 
"\t(clientTalkLisp (eval (car largs))\t; this is the fBinding\n\

    fprintf (client, "\t\t(cdr largs))\n)\n\n\n");
*/


};


RecursiveLispPatterns ( t, defFile, tabptr)
	struct type *t;
	FILE *defFile;
	char *tabptr;
{
    struct type *bt;
       if (t->type_pfname != (char *)NULL) {
	   fprintf (defFile, "%s( UserProc %s %s )\n",
	            tabptr, t->type_pfname, typename(t));
       }
       else
       if (t->courBaseType) {
	   fprintf (defFile, "%s%s\n", tabptr, typename(t));
       }
       else
       switch (t->type_constr) {
	   case C_ENUMERATION :
	      fprintf (defFile, "%s(Enumeration %s)\n", tabptr, typename(t));
	      break;
	   case C_ARRAY :
	      bt = t->type_basetype;
	      fprintf (defFile, "%s(Array %d \n", tabptr, t->type_size);
	      RecursiveLispPatterns (bt, defFile, tabptr -1);
	      fprintf (defFile, "%s\t)\n", tabptr);
	      break;
	   case C_SEQUENCE :
	      bt = t->type_basetype;
	      fprintf (defFile, "%s(Sequence %d \n", tabptr, t->type_size);
	      RecursiveLispPatterns (bt, defFile, tabptr -1);
	      fprintf (defFile, "%s\t)\n", tabptr);
	      break;
	   case C_RECORD :
	      fprintf (defFile, "%s(\t; record type %s\n",
	      		tabptr, typename(t));
	      LispPatterns (t->type_list, defFile, tabptr -1);
	      fprintf (defFile, "%s )\n", tabptr);
	      break;
	   case C_CHOICE :
	      fprintf (defFile, "%s(Choice %s (\n", tabptr, typename(t));
	      ChoicePatterns (t->type_candidates, defFile, tabptr -1);
	      fprintf (defFile, "%s ))\n", tabptr);
	      break;
	   case C_NUMERIC :
	      if (streq (typename(t), "__FileUID")) {
	      	   fprintf (defFile, "%s (Literal %d)\n", tabptr,
		      (LongCardinal) car(t->type_list));
		   break;     
	      };
	      /* only break if is FileUID, else fall through to default */
	   default :
	      fprintf (stderr,"LispPattern botch : type_constr %d\n",
	           (int)t->type_constr);
	      fprintf (stderr, "%s\n", typename(t));
	      error (FATAL, "");
       };  /* end switch */
};    
    
    

ExtractLispPatterns ( procName, procNumber, typtr, fFile)
	char *procName, *procNumber;
	struct type *typtr;
	FILE *fFile;
{
    char *tabp;

    tabp = tabs + LENTABS - 2;    /* one tab, going in */
    fprintf (fFile, "(setq %s_arg_pattern \n\t'(\n", procName);
    LispPatterns (typtr->type_args, fFile, tabp);
    fprintf (fFile, "\t))\n\n(setq %s_return_pattern \n\t'(\n", procName);
    LispPatterns (typtr->type_results, fFile, tabp);
    fprintf (fFile, "\t))\n\n\n");


};





extern int yylineno;

LispPatterns (fList, defFile, tabptr)
   list fList;
   FILE *defFile;
   char *tabptr;
   
{  list p;
   struct type *t, *bt;

   for (p = fList; p != NIL; p = cdr(p)) {
       t = argtype(p);
       RecursiveLispPatterns (t, defFile, tabptr);
   };  /* end for.. */
};


ChoicePatterns (fList, defFile, tabptr)
   list fList;
   FILE *defFile;
   char *tabptr;
   
{  list p,q;
   struct type *t;

   for (p = fList; p != NIL; p = cdr(p)) {
     for (q = caar(p); q != NIL; q = cdr(q)) {
       fprintf (defFile, "%s ( %d ", tabptr, enumvalue_of(caar(q)));
       t = argtype(p);
       RecursiveLispPatterns (t, defFile, tabptr);
       fprintf (defFile, "%s )\n", tabptr);
     }; /* end for q */
   };  /* end for p.. */
 };
