/* File: GetTypeUID.c   Date: 8/16/86  Kimi Gosney   */

/*
 * INTERFACE: GetTypeUID( typeName, typeDescription, fullCourierTextFile,
 *		registerOption, returnStatus, typeUID)
 *	INPUT:	typeName : STRING
 *		fullCourierText : STRING (filename, read into sBuf, sent
 *			to GetTypeID.  text is functionally a comment.)
 *		typeDescription : STRING (short form, actually used)
 *		registerOption : BOOLEAN
 *	OUTPUT:	typeUID : LONG CARDINAL
 *		returnStatus : enumerated (see TypeRegistry.h)
 *		newlyRegistered : BOOLEAN
 *
 * FUNCTION:	make HRPC call to type server to return typeUID
 *
 * IMPORTS:	GetTypeID() from TypeRegistry_client.c
 *		StatusCode (enumerated type) from TypeRegistry.h
 *		errs from main.c
 *
 * EXPORTS:	GetTypeUID()
 *
 * DESIGN:	If registerOption is set to FALSE, do not register a
 *			new type.  if new type, returnStatus returns 0.
 *		If registerOption is not FALSE, the text supplied in
 *			fullCourierTextFile will overlay previous copy.
 *		Type identity is by name and by structure.  The type server
 *			supports more than one type of a given name,
 *			and will identify by typeUID.
 *			Same name, same structure => same typeUID
 *			Same name, different structure => different typeUID
 *			Different name, same structure => different typeUID
 *		  (field names are not considered to be part of structure.)
 *		  (field names, and case of type name are not significant.)
 *
 */

# include "compiler.h"

extern int errs;		/* from main.c */

#ifdef BOOTVERS
void GetTypeUID()
{
    fprintf(stderr,"Cannot access WCS with bootstrap stubgenerator\n");
    errs = 1;
    goodbye();
}

#else BOOTVERS

# include "TypeRegistry.h"
void
GetTypeUID (typeName, typeDesc, fullCourierTextFile, registerOption,
	ptrToReturnStatus, ptrToTypeUID)
	String typeName;
	String typeDesc;
	String fullCourierTextFile;
	Boolean registerOption;
	TypeRegistry_StatusCode *ptrToReturnStatus;
	LongCardinal *ptrToTypeUID;

    {  HRPCBinding *bptr;
       char sBuf[16384];
       int uCnt = 0;
       FILE *pF;


       /*  initialize  */
       *ptrToTypeUID =  0;
       *ptrToReturnStatus = TR_other;

       if (errs) registerOption = FALSE;	/* we don't want to clutter up
       		the typeRegistry if syntax errors have been detected by the
		stub compiler */

       if (registerOption == TRUE) {
       

    /* get stuff from text file into sBuf.  Mostly copied from TR_gettypeid */
       if ((pF = fopen ( fullCourierTextFile, "r")) == NULL) {
	   fprintf (stderr, "Cannot open %s. Bye bye. \n",
	   	fullCourierTextFile);
	   exit(1);
       };


    uCnt = fread( sBuf, sizeof(char), 16384, pF );
    if( uCnt >= 16384 )
    {
	fprintf(stderr,"Error: descrip file too big for this prototype\n");
	exit(1);
    }
    sBuf[ uCnt ] = '\0';
    fclose( pF );

       } else sBuf [ 0 ] = '\0';	   /* if registerOption is FALSE */
       

       

       /*  initiate RPC  call */
       /*  if desired server is not found, this thing just dies when it
           tries to abort(). */
       TypeRegistry_Import ("larry", &bptr);  
       


       /*  make the inquiry */
       if (bptr != (HRPCBinding *) NULL) {
	   TypeRegistry_GetTypeID (bptr, typeName, typeDesc, sBuf,
             registerOption, ptrToReturnStatus, ptrToTypeUID);

	   CloseHRPCBinding (bptr);
       }
       else { fprintf (stderr, "Couldn't import TypeServer -- no binding\n");
       	      exit(2);
       };

    };
#endif not BOOTVERS
