/* File:  Cproccode.c  Date:  May 13, 1987 Kimi Gosney  */

/*
 * INTERFACE:	Cclient_proc(), Cserver_proc()
 *
 * FUNCTION:	assigned to the variables (*client_proc)() and (*server_proc)()
 *              called by proc_functions() in procedures.c.  Actually generate
 *              C code for procedures.
 *
 * IMPORTS:	definitions of type, binding
 *
 * EXPORTS:	--
 *
 * DESIGN:     each language has its own procedures for emitting code.  These
 *             are the ones for C.  It takes the names that need to be emitted
 *             plus a pointer into the symbol table that makes additional info
 *             available.
 *
 * ACKNOWLEDGMENT :
 *             by Jan Sanislo from the Cornell stub generator and subdivided
 *             by Kimi Gosney.
 *
 */

/* $Log:	 $
*/



#include "compiler.h"
#include <HRPC/cCourierTypes.h>
extern int fileDefined;			/* from fileaccess.c */
extern int chkProgNum;			/* from main.c */

#define argname(p)	((char *) car(caar(p)))
#define argtype(p)	((struct type *) cdar(p))


#define INCLIENT 1
#define INSERVER 0
#define INARG  1
#define OUTARG 0

/*************************************************************/




/* C specific routines for (*client_proc)() and (*server_proc)()  */



Cclient_proc (procName, procNumber, typtr, fFile)
	char *procName, *procNumber;

	struct type *typtr;
	FILE *fFile;

{	list p;
	struct type *t;
	char *refPrefix;

	fprintf(fFile,
"\n\
%s\n\
%s(fBinding",
	       /*rtname*/ "HRPCErrRec *", procName);
	for (p = typtr->type_args; p != NIL; p = cdr(p))
		     /* before printing an argname, see if it is a filetype */
		     /* if so, name is a dummy and is not emitted. */
 		if (strcmp(typename(argtype(p)), "__FileUID" )) {
		    fprintf(fFile, ", %s", argname(p));
		};
	for (p = typtr->type_results; p != NIL; p = cdr(p))
		fprintf(fFile, ", %s", argname(p));
	fprintf(fFile, ")\n\tHRPCBinding *fBinding;\n");
	GenArgList( typtr, INCLIENT, fFile );
	fprintf(fFile, "{\n");

	fprintf(fFile,
"\tregister OtwControl *otwctl = &(fBinding->otwDescr);\n\
\tregister RpcControl *rpcctl = &(fBinding->rpcDescr);\n\
\tjmp_buf %s_Unwind;\n",
		procName);
	fprintf(fFile,"\tHRPCErrRec *errRes;\n");
	if (fileDefined)
		fprintf(fFile, "\tLongCardinal fileUIDvalue;\n");

	/*
	 * Make sure we were passed the right interface.
	 */
	if ( chkProgNum ) {
	    fprintf(fFile,
"\n\tif ( (fBinding->bndProgNum != %s_ProgN[(int)fBinding->speaking]) \n",
		CurrentProgram);
	    fprintf(fFile,"\t\t || (fBinding->ifdPtr->versNum > %d)) {\n",
	        CurrentVersion);
	    fprintf(fFile,
		"\t\treturn(NewHRPCErrRec(HRPC_WRNGSTUB,0));\n\t}\n");
	}
	/*
	 * Get set to "recover errors".
	 */
	fprintf(fFile,
"\tif ( errRes = (HRPCErrRec *) setjmp(%s_Unwind) ) {\n\
\t\treturn( errRes );\n\t}\n",
	procName);
	/*
	 * Initialize outgoing.
	 */
	fprintf(fFile,"\tfBinding->unwindTo = (memory) %s_Unwind;\n",
			procName);
	fprintf(fFile,"\t(*rpcctl->InitOutgoing)(fBinding, %s, %d);\n",
		procNumber, CurrentVersion);
	/*
	 * Generate code to externalize the arguments.
	 */
	OtwArgs( typtr->type_args, INCLIENT, INARG, fFile );

	fprintf(fFile,"\t(*rpcctl->FinishOutgoing)(fBinding);\n");

	fprintf(fFile,"\t(*rpcctl->InitAnswer)(fBinding);\n");

	/*
	 * Generate code to receive the results and interpret them
	 * as errors
         *
	 *************** Watch out for NOTREACHED below if this code
			 put back in
	fprintf(fFile,
"\tif (_errorflag) {\n\
\t\t_bp += %s(&_errtype, _bp);\n\
\t\tswitch (ERROR_OFFSET+_errtype) {\n",
		xfn(INTERNALIZE, Cardinal_type)
			);
	for (p = typtr->type_errors; p != NIL; p = cdr(p)) {
		struct constant *errconst;
		struct type *errtype;
		errconst = (check_def((char *)car(p),CurrentProgram))->o_constant;
		errtype = (struct type *) cdr(errconst->cn_list);
		if (errtype == TNIL)
			fprintf(fFile,
"\t\tcase %s:\n\
\t\t\traise(ERROR_OFFSET+_errtype, 0);\n\
\t\t\t/ *NOTREACHED* /\n",
				errconst->cn_name);
		else
			fprintf(fFile,
"\t\tcase %s: {\n\
\t\t\tstatic %s _result;\n\
\t\t\t_bp += %s(%s_result, _bp);\n\
\t\t\traise(ERROR_OFFSET+_errtype, (char *) &_result);\n\
\t\t\t/ *NOTREACHED* /\n\
\t\t\t}\n",
				errconst->cn_name,
				typename(errtype),
				xfn(INTERNALIZE, errtype), refstr(errtype)
				);
	}
	fprintf(fFile,
"\t\tdefault:\n\
\t\t\t/ * don't know how to unpack this * /\n\
\t\t\traise(ERROR_OFFSET+_errtype, 0);\n\
\t\t\t/ *NOTREACHED* /\n\
\t\t}\n"
		);
        ***************
	*/

	/*
	 * Code to unpack results and return
	 */
	OtwArgs( typtr->type_results, INCLIENT, OUTARG, fFile );
	fprintf(fFile,"\t(*rpcctl->FinishAnswer)(fBinding);\n");
	fprintf(fFile,"\treturn(NOHRPCERR);\n}\n");
};


Cserver_proc (procName, procNumber, typtr, fFile)
	char *procName, *procNumber;
	struct type *typtr;
	FILE *fFile;
{
	list p, p2;
	struct type *t;
	char *refPrefix;
	int nresults;

	fprintf(fFile, "\nextern void %s();\n", procName);
	fprintf(fFile,
"HRPCErrRec *server_%s(fBinding)\n\
\tHRPCBinding *fBinding;\n\
{\n\
\tregister OtwControl *otwctl = &(fBinding->otwDescr);\n\
\tregister RpcControl *rpcctl = &(fBinding->rpcDescr);\n\
\tjmp_buf server_%s_Unwind;\n\
\tHRPCErrRec *errRes;\n\n",
		procName,procName);
	GenArgList( typtr, INSERVER, fFile );
	fprintf(fFile, "\n");

	fprintf(fFile,
"\tif ( errRes = (HRPCErrRec *) setjmp(server_%s_Unwind) ) {\n\
\t\treturn( errRes );\n\t}\n",
	procName);
	fprintf(fFile,"\tfBinding->unwindTo = (memory) server_%s_Unwind;\n",
		procName);

	/*
	 * Generate code to internalize the arguments.
	 */
	OtwArgs( typtr->type_args, INSERVER, INARG, fFile );
	fprintf(fFile,"\t(*rpcctl->FinishIncoming)(fBinding);\n");
	/*
	 * Generate code to call the procedure.
	 */
	fprintf(fFile, "\t%s(fBinding", procName);
	for (p = typtr->type_args; p != NIL; p = cdr(p)) {
	    t = argtype(p);
	    refPrefix = ( (t->type_constr == C_RECORD) ||
			  (t->type_constr == C_SEQUENCE) ||
			  (t->type_constr == C_CHOICE) ) ? "&" : "";
	    fprintf(fFile, ", %s%s", refPrefix, argname(p));
	}
	for (p = typtr->type_results; p != NIL; p = cdr(p)) {
	    t = argtype(p);
	    refPrefix = ( (t->type_constr != C_ARRAY) 
			  /* && (t->type_constr != C_STRING) */ ) ? "&" : "";
	    fprintf(fFile, ", %s%s", refPrefix, argname(p));
	}
	fprintf(fFile, ");\n");
	/*
	 * Generate code to externalize the result.
	 */
	fprintf(fFile,"\t(*rpcctl->InitReply)(fBinding);\n");
	OtwArgs( typtr->type_results, INSERVER, OUTARG, fFile );
	fprintf(fFile,"\t(*rpcctl->FinishReply)(fBinding);\n");

        if ( freeResults && (typtr->type_results != NIL) ) {
            nresults = 1;
            for ( p = typtr->type_results; p != NIL; p = cdr(p) ) {
                t = argtype(p);
                if ( t->type_xsize < 0 ) {
		    if ( nresults ) {
		        fprintf(fFile,"\tfBinding->otwOp = OTW_FREE;\n");
			nresults = 0;
		    }
		    p2 = cdr(p);
		    cdr(p) = NIL;
		    OtwArgs(p, INSERVER, OUTARG, server);
                    cdr(p) = p2;
		}
	    }
	}
	fprintf(fFile,"\treturn(NOHRPCERR);\n}\n");
};  /* end of Cserver_proc */
