/* File: /u1/oystr/HRPC/HRpcRTS/rpcSunHdrs.c  Date:  4-Mar-1986  */

/*
 * $Header$
 * INTERFACE:	Pack/unpack SUN RPC standard headers.
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log$
 *  4-Mar-1986:	Initial implementation, Jan Sanislo
 */

/*
 * SUN specific stuff.
 */
#include <sys/types.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <rpc/auth.h>
#include <rpc/rpc_msg.h>
#include <sys/time.h>
#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>

/*
 * Format a call header into/out of the current
 * buffer.
 */

SunCallHdr( fBptr, fCallHdr )
    HRPCBinding *fBptr;
    struct rpc_msg *fCallHdr;
{
    OtwControl *otwptr = &(fBptr->otwDescr);
    
    (*otwptr->LongCardinal)(fBptr,&(fCallHdr->rm_xid));
    (*otwptr->LongCardinal)(fBptr,&(fCallHdr->rm_direction));
    (*otwptr->LongCardinal)(fBptr,&(fCallHdr->rm_call.cb_rpcvers));
    (*otwptr->LongCardinal)(fBptr,&(fCallHdr->rm_call.cb_prog));
    (*otwptr->LongCardinal)(fBptr,&(fCallHdr->rm_call.cb_vers));
    (*otwptr->LongCardinal)(fBptr,&(fCallHdr->rm_call.cb_proc));
    SunAuthInfo( fBptr, &(fCallHdr->rm_call.cb_cred) );
    SunAuthInfo( fBptr, &(fCallHdr->rm_call.cb_verf) );
}

HRPCErrRec *SunReplyHdr( fBptr, fReplyHdr )
    HRPCBinding *fBptr;
    struct rpc_msg *fReplyHdr;
{
    OtwControl *otwptr = &(fBptr->otwDescr);
    struct rejected_reply *rjptr;
    struct accepted_reply *acptr;
    int hrpcCode;

    (*otwptr->LongCardinal)(fBptr, &(fReplyHdr->rm_xid));
    (*otwptr->LongCardinal)(fBptr, &(fReplyHdr->rm_direction));

    /* Quick check to keep out of trouble */
    if ( fReplyHdr->rm_direction != REPLY ) {
	return;
    }
    
    /*
     * See what the status is.
     */
    (*otwptr->LongCardinal)(fBptr, &(fReplyHdr->rm_reply.rp_stat));
    if ( fReplyHdr->rm_reply.rp_stat == MSG_ACCEPTED ) {
	acptr = &(fReplyHdr->acpted_rply);
	SunAuthInfo( fBptr, &(acptr->ar_verf));
	(*otwptr->LongCardinal)(fBptr, &(acptr->ar_stat));
	if ( acptr->ar_stat == SUCCESS ) {
	    /*
	     * This is a crock.  If the message
	     * is successful, there IS no proc/where.
	     * this information being filled in on the CLIENT end.
	     * Good grief.
	     */
	    return ( NOHRPCERR );
	}
	else {
	    switch ( acptr->ar_stat ) {
		PROG_UNAVAIL:  hrpcCode = HRPC_BADPROGN; break;

		PROG_MISMATCH: hrpcCode = HRPC_BADVERSN; break;

		PROC_UNAVAIL:  hrpcCode = HRPC_BADPROCN; break;

		GARBAGE_ARGS:  hrpcCode = HRPC_BADPARAM; break;

		SYSTEM_ERR:    hrpcCode = HRPC_SYSERR; break;

		default:
	    	    fatalerr("SunReplyHdr: call did not succeed: %d.\n",
			acptr->ar_stat);
	    }
	}
    }
    else
    if ( fReplyHdr->rm_reply.rp_stat == MSG_DENIED ) {
	rjptr = &(fReplyHdr->rjcted_rply);
	(*otwptr->LongCardinal)(fBptr, &(rjptr->rj_stat));
	switch ( rjptr->rj_stat ) {
	    RPC_MISMATCH:  hrpcCode = HRPC_RPCVERSN; break;

	    AUTH_ERROR:    hrpcCode = HRPC_BADAUTHN; break;

	    default:
		fatalerr("SunReplyHdr: call rejected: %d.\n",
			acptr->ar_stat);
	}
    }
    else {
	fatalerr("SunReplyHdr: bogus rp_stat: %d.\n",
		 fReplyHdr->rm_reply.rp_stat);
    }
    return( NewHRPCErrRec( hrpcCode, 0 ) );
}

/*
 *		>>>> WARNING <<<<
 * Authentication record is defined as
 *	flavor
 *	base
 *	length
 * but OTW representation is actually
 *	flavor
 *	length
 *	base
 * due to the way xdr_bytes is called in 'xdr_opaque_auth'.
 * Also note that if length is 0, no base is sent/received.
 */

SunAuthInfo( fBptr, fAuthRec )
    HRPCBinding *fBptr;
    struct opaque_auth *fAuthRec;
{
    OtwControl *otwptr = &(fBptr->otwDescr);
    char junk[MAX_AUTH_BYTES];
    
    /*
     * Do flavor
     */
    (*otwptr->LongCardinal)(fBptr,&(fAuthRec->oa_flavor));
    /*
     * Get length, see warning above..
     */
    (*otwptr->LongCardinal)(fBptr,&(fAuthRec->oa_length));
    if ( ! fAuthRec->oa_length ) {
	/* Honest!! */
        return;
    }
    
    /*
     * We are really stuck now, a nasty hack follows -
     * should be indirect through otwptr.
     */
    OtwByteCopy( fBptr, fAuthRec->oa_length, junk, 4 );
}
