/*
 * This file implements client functions lifted from the XNS courier library
 */

/*
 * $Log:	rpcclient.c,v $
 * Revision 1.5  86/06/13  13:16:20 oystr
 * General clean up during merge.
 *
 * Revision 1.4  86/04/09  13:00:31  dtc
 * correction of reject message printing.  Still need to print out the
 * details, if it's a noSuchVersionNumber rejection.
 * 
 * Revision 1.3  86/03/31  20:37:35  dtc
 * working "lawnmower" version, client side only
 * 
 * Revision 1.1  86/03/27  13:17:37  dtc
 * Initial revision
 * 
 * Revision 1.3  85/03/11  16:36:46  jqj
 * Public alpha-test version, released 11 March 1985
 * 
 * Revision 1.2  85/01/27  07:37:10  jqj
 * finished but undebugged version
 * 
 * Revision 1.1  84/12/30  10:14:30  jqj
 * Initial revision -- Mogul's tcp-based version
 */

#ifndef lint
static char rcsid[] = "$Header: rpcclient.c,v 1.4 86/04/09 13:00:31 dtc Exp $";
#endif

#include <stdio.h>
#include <sys/types.h>		/* for xn.h, and socket.h */
#include <sys/socket.h>
#include <netns/ns.h>		/* for XNS addresses and courierconnection.h */
#include <netns/sp.h>		/* for XNS addresses and courierconnection.h */

#include <HRPC/basicRpc.h>
#include <HRPC/CCS.h>

/* 
 *returns a pointer to a block of data to be freed after unpacking
 * procResults or [errorValue, errorArgs]
 */

void
ReceiveReturnMessage(fBptr, abortedFlag)
    HRPCBinding *fBptr;
    Boolean *abortedFlag;		/* set to TRUE iff abort received */
{
    Cardinal msgtype, tid;
    rejectionDetails *rdetails;
    CourCallState *callState;
    register OtwControl *otwptr = &(fBptr->otwDescr);
    int mainSize;
    extern char *malloc();

    callState = (CourCallState *) fBptr->rpcDescr.callState;
    callState->state = calldone;

    /*
     * Obtain the message type and transaction ID.
     */
    (*otwptr->Cardinal)(fBptr, &msgtype);
    (*otwptr->Unspecified)(fBptr, &tid);

    switch (msgtype) {
	case RETURN:
	    *abortedFlag = FALSE;
	    break;

	case REJECT:
	    rdetails = (rejectionDetails*)malloc(sizeof(rejectionDetails));
	    (*otwptr->Enumeration)(fBptr, &(rdetails->designator));
	    if (rdetails->designator == noSuchVersionNumber) {
		(*otwptr->Cardinal)(fBptr,
			    &(rdetails->noSuchVersionNumber_case.lowest));
		(*otwptr->Cardinal)(fBptr,
			    &(rdetails->noSuchVersionNumber_case.highest));
	    }
/*
	    Deallocate(fBptr->currentBuffer);
 */
	    fatalerr("REJECT_ERROR:  type %d.\n",
		     (char*) rdetails->designator);
	    /*NOTREACHED*/

	case ABORT:
	    *abortedFlag = TRUE;
	    break;
    }
    return;
}

/*
 * Used to be called from RPC client stub but
 * is now probably obsolete.
 */
MaybeCallBDTHandler(fBptr, BDTproc)
    HRPCBinding *fBptr;	/* socket descriptor */
    int (*BDTproc)();
{
    CourCallState *callState;

    callState = (CourCallState *) fBptr->rpcDescr.callState;

    /*
     * can't look ahead here, since server may be expecting us to send
     * lots of data before he does anything
     */
    callState->abortseen = FALSE;

    /* ### setup interrupt handler for URGENT messages */
    if (BDTproc != NULL) {
	(*BDTproc)(fBptr);
    }
    /* ### clear interrupt handler */
    callState->bdtstate = wantdata;
}

