/* File: /u1/oystr/HRPC/RpcProtos/rpcCour.h  Date:  3-Sep-1986  */

/*
 * $Header$
 * INTERFACE:	Courier RPC Protocol Interface
 *
 * FUNCTION:	Type declarations for Courier RPC headers plus
 *		some other stuff.
 *
 * IMPORTS:	basicRpc.h
 *
 * EXPORTS:	Type definitions:
 *		   CourCallHdr, CourReplyHdr, CourAbortHdr, CourRejectHdr
 *		Various constants.
 *
 * DESIGN:	Of course.
 *
 * $Log$
 *  3-Sep-1986:	Initial implementation, Jan Sanislo
 */

#ifndef rpcCour
#define rpcCour

#ifdef basicRpc
#include <HRPC/basicRpc.h>
#endif

/* Version of Courier protocol we support/understand */
#define COURIERVERSION 3

#define COUR_CALLMSG   0
#define COUR_REJECTMSG 1
#define COUR_REPLYMSG  2
#define COUR_ABORTMSG  3

typedef struct {
    Cardinal courMsgType;
    Unspecified courTransID;
    LongCardinal courProgN;
    Cardinal courVersN;
    Cardinal courProcN;
} CourCallHdr;

#define COUR_BADPROGN 0
#define COUR_BADVERS  1
#define COUR_BADPROCN 2
#define COUR_INVALARG 3
#define COUR_UNSPECERR 0xffff

typedef struct {
    Cardinal courMsgType;
    Unspecified courTransID;
    Cardinal rejectCode;
    /* following iff rejectCode == COUR_BADVERS */
    Cardinal loVers;
    Cardinal hiVers;
} CourRejectHdr;

typedef struct {
    Cardinal courMsgType;
    Unspecified courTransID;
} CourReplyHdr;

typedef struct {
    Cardinal courMsgType;
    Unspecified courTransID;
    Cardinal errorValue;
} CourAbortHdr;

/*
 * Need union since we don't know what is coming back.
 */

typedef struct {
    union {
	CourCallHdr  courRuCall;
	CourReplyHdr courRuReply;
	CourAbortHdr courRuAbort;
	CourRejectHdr courRuReject;
    } courRu;
} CourGenericHeader;

#define courCall   courRu.courRuCall
#define courReply  courRu.courRuReply
#define courAbort  courRu.courRuAbort
#define courReject courRu.courRuReject

/*
 * Defining the state of the call.
 */
#define COUR_CLOSED   1
#define COUR_WANTVERS 2
#define COUR_INPROG   3
#define COUR_CALLDONE 4
#define COUR_SENDVERS 5

#define BDT_WANTDATA 1
#define BDT_ESTAB    2
#define BDT_EOMSEEN  3

typedef struct {
    int courState;
    int bdtState;
    int abortseen;
    CourGenericHeader genericHdr;
} CourCallInfo;

#endif rpcCour
