/* File: /u1/oystr/HRPC/OtwReps/otwCommon.c  Date: 11-Apr-1986  */

/*
 * $Header$
 * INTERFACE:	General purpose OTW routines
 *
 * FUNCTION:	Copy a stream of bytes while obeying
 *		alignment rules.  Provide a tmp buffer
 *		for decoding if we run out of bytes in
 *		the current buffer.
 *
 * IMPORTS:	basicRpc.h
 *
 * EXPORTS:	OtwByteCopy, OtwNeedBytes
 *
 * DESIGN:	Certainly.
 *
 * $Log$
 * 11-Apr-1986:	Initial implementation, Jan Sanislo
 */

#include <HRPC/basicRpc.h>

/*
 * General purpose byte copy routine.
 * Takes into account alignment considerations.
 */

#define MAXALIGN 8

OtwByteCopy( fBptr, fBytes, fSize, fAlign )
    register HRPCBinding *fBptr;
    memory	 fBytes;
    int		 fSize;
    int		 fAlign;
{
    int rndup;
    static char junk[MAXALIGN];
    register memory src;
    register memory dest;
    register int run;
    
    rndup = fSize % fAlign;
    if ( rndup > 0 )
	rndup = fAlign - rndup;

    if ( fBptr->otwOp == OTW_DECODE ) {
	src = fBptr->curBufMark;
	dest = fBytes;
    }
    else
    if ( fBptr->otwOp == OTW_ENCODE ) {
	src = fBytes;
	dest = fBptr->curBufMark;
    }
    else return;

stuff_em:
    while ( fSize > 0 ) {
	if ( fBptr->curBufSize <= 0 ) {
	    if ( fBptr->otwOp == OTW_ENCODE ) {
		(*fBptr->rpcDescr.PutPacket)( fBptr );
		dest = fBptr->curBufMark;
	    }
	    else {
		(*fBptr->rpcDescr.GetPacket)( fBptr );
		src = fBptr->curBufMark;
	    }
	}

	run = (fSize <= fBptr->curBufSize) ? fSize : fBptr->curBufSize;
	bcopy(src,dest,run);
	src += run;
	dest += run;
	fSize -= run;
	fBptr->curBufSize -= run;
	fBptr->curBufMark += run;
    }

    /* 
     * Following is nasty trick - if we have to stuff/eat
     * pad bytes (rndup > 0) switch src/dest to junk
     * as appropriate and go back to the top of the loop.
     * Ugly but efficient (in terms of code).
     * "Ugly but efficient" - you'll see that comment a lot.
     */
    if ( rndup  ) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    src = junk;
	}
	else {
	    dest = junk;
	}
	fSize = rndup;
	rndup = 0;
	goto stuff_em;
    }
    return;
}

/*
 * General purpose routine to handle fragmentation of
 * data items across packet boundaries.
 */
OtwNeedBytes( fBptr, fWant, fBuf )
    register HRPCBinding *fBptr;
    register int fWant; /* number of bytes needed */
    memory	 fBuf;
{
    register memory	 dptr = fBuf;
    
    while ( fBptr->curBufSize > 0 ) {
	*dptr++ = *fBptr->curBufMark++;
	fBptr->curBufSize--;
    }
    (*fBptr->rpcDescr.GetPacket)( fBptr );
    if ( fBptr->curBufSize < fWant ) {
	fatalerr("OtwNeedBytes: short read.\n");
    }
    while ( fWant > 0 ) {
	*dptr++ = *fBptr->curBufMark++;
	fBptr->curBufSize--;
	fWant--;
    }
}
