/*LINTLIBRARY*/
/* File:  helpserver.c  Date: 2/5/87 Kimi Gosney   */

/*
 * INTERFACE:	serverInitIncoming(), HRPCExportAux()
 *
 * FUNCTION:	This routine is the Lisp server's interface to the
 *		C-coded HRPC runtime.  Note that it does the
 *		InitIncoming, and it is the Lisp server's responsibility
 *		to read the data and do FinishIncoming (as well as reply...).
 *
 * IMPORTS:	programnumbers, a vectori in Lisp space, from the server.
 *		HRPCDispatcher() from <HRPC/HrpcRTS/dispatch.c>.
 *		HRPCExport() from <HRPC/Binding/export.c>.
 *
 * EXPORTS:	
 *
 * DESIGN:	mostly, just return something in a form that Lisp can
 *		understand.  Note the FranzLisp dependencies noted in
 *              some of the comments.
 *
 */

/* $Log:	helpserver.new.c,v $
 * Revision 1.3  87/06/29  19:10:22  kimi
 * *** empty log message ***
 * 
 * Revision 1.2  87/05/31  21:27:29  kimi
 * works with RUser and RLisp. about to add autoactivation to Lisp
 * 
 * Revision 1.1  87/05/27  22:22:27  kimi
 * Initial revision
 * 
 * Revision 1.4  87/04/21  11:47:06  kimi
 * worked wrt new-runtime, but without support for setjmp
 * helpserver.o works to ltest6 and lower
 * 
 * Revision 1.3  87/03/18  23:03:24  kimi
 * about to try new run-time
 * 
 * Revision 1.2  87/02/15  20:58:26  kimi
 * working version w/ltest3 (strings/ints)
 * 
 * Revision 1.1  87/02/09  20:55:38  kimi
 * Initial revision
 * 
*/

# include <stdio.h>
# include <setjmp.h>
# include <sys/time.h>
# include "HRPC/basicRpc.h"
# include "HRPC/cCourierTypes.h"
# include "HRPC/hrpcErrCodes.h"

extern int debug;		/* defined in transp.c */


long
HRPCExportAux (fServiceName, fInstName, fProgNums, fVersNum, fKind, fPrefs,
	fNPrefs, fSpare2, fSpare3)
    String fServiceName;	/* Type (interface) name */
    String fInstName;	/* String name of interface, for now = machine */
    LongCardinal fProgNums[];	/* program numbers */
    int fKind;		/* contact name server?(no==0), if yes, autoact? (==32)
			   preact == 64.  also requires storing actPrefs in
			   actPrefs and fakeNS */
    SpeakDefs_Speak fPrefs[];	/* what would I like to speak */
    int fNPrefs;                /* value == # prefs/result == # bindings */
    LongUnspecified fSpare2, fSpare3;


{    HRPCBinding **fBindings;	/* returned bindings */
     int autoact, nPrefs;

     
  /* the whole point of this is to change fNPrefs from an int to an *int.
     I can either make HRPCExportAux an integer function or a C-function
     when importing it into Lisp, but the fact that in HRPCExport fKind
     and fNPrefs are different types is inconvenient.
     Also, I have to do this to return fBindings (pointer to an array
     of bindings) as a valid Lisp object.
     
     5/27/87 well, that changed in this release of the run-time, but
     I didn't change this structure.  Note that both autoact and nPrefs are
     value-result parameters whose info is being thrown away.  This will be
     bad news someday.  Returning a valid lisp object is hard.
     */

     autoact = fKind;
     nPrefs = fNPrefs;

    HRPCExport (fServiceName, fInstName, fProgNums, fVersNum, &autoact, fPrefs,
		&fBindings, &nPrefs, fSpare2, fSpare3);

    printf ("returned exp flags: %d.\n", autoact);
    printf ("number of bindings: %d.\n", fNPrefs);

    if (autoact & EXPF_AUTOACT ) {
	struct timeval tmo;

	tmo.tv_sec = 300;
	tmo.tv_usec = 0;
	HRPCSetRequestTMO ( &tmo, 0);

	printf ("timeout set at %d sec\n", tmo.tv_sec);
    };

    return ((long)fBindings);
};

/***************************************************************/

/* readyAndProcNum is allocated by FranzLisp, and is a vectori-long.
   vectori have the property that they can be used as in-out arguments,
   for passing more than one piece of data back to Lisp.  In FranzLisp,
   things returned from C foreign functions have to be valid Lisp
   objects, and unless they are integers (I haven't tried floats, because
   so far HRPC doesn't support them), they wind up being objects of
   type 'other'.  see source for franz, /usr/src/ucb/franz/alloc.c (or so),
   for more insight into this.  For some other type of lisp, without
   vectori, we would have to figure out how to return a list.  But
   presumably we would have different constraints on how we get
   information back from the run-time, so it's pointless to try to
   generalize here. */


long *
serverInitIncoming (fNB, fBptr, readyAndProcNum, progNumbers)
   int fNB;
   HRPCBinding *fBptr[];
   long readyAndProcNum[2];
   LongCardinal progNumbers[];

 { long procnum, programnum, versionnum;
   int status;
   HRPCBinding *readyBptr;
   
#ifdef DEBUGLISP
   if (debug)
   	fprintf (stderr, "before assignment to readyBptr, readyAndProcNum is at %ld\n",
       &(readyAndProcNum[0]));
#endif

   readyBptr = (HRPCBinding *)readyAndProcNum;


#ifdef DEBUGLISP
   if (debug)
       fprintf (stderr, "after assignment to readyBptr, readyAndProcNum is at %ld\n",
       &(readyAndProcNum[0]));
#endif

   do {
#ifdef DEBUGLISP
       if (debug) fprintf (stderr,
         "called with fNB of %d and fBptr of %ld\nand progNum of \
          %ld %ld %ld\n", fNB, fBptr, progNumbers[0], progNumbers[1],
	  progNumbers[2]);
#endif
       HRPCDispatcher (fNB, fBptr, &readyBptr);
#ifdef DEBUGLISP
       if (debug ) fprintf(stderr, "came back from dispatcher with readyBptr of %ld...\n",
       		readyBptr);
#endif
       (*readyBptr->rpcDescr.InitIncoming)(readyBptr,
           &programnum, &versionnum, &procnum, &status, 0);
#ifdef DEBUGLISP
       if (debug) fprintf (stderr, "InitIncoming with programnum, version, procnum\
           and status of %ld %ld %ld %d\n", programnum, versionnum, procnum,
	   status);
#endif

       /* here's where I should check prognum and version, but what do I
          really want to do with it? */

       readyAndProcNum[0] = (long)readyBptr;

       readyAndProcNum[1] = procnum;

#ifdef DEBUGLISP
       if (debug) fprintf (stderr, "readyAndProcNum cells are %ld %ld\n",
       		readyAndProcNum[0], readyAndProcNum[1]);
#endif

   } while (status);

   return (readyAndProcNum);
 };




/* access to routines in <HRPC/RpcProtos>, as needed by server. */


/* return something from all of these, because they are intended
   to be called from lisp */


/*******************************************************/

long
FinishIncoming (fBinding)
   HRPCBinding *fBinding;

{ HRPCErrRec *errRes;
  jmp_buf Unwind;

#ifdef DEBUGLISP
     if (debug) {
	 printf ("C call to FinishIncoming\n");
	 fflush(stdout);
     };
#endif

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 return (errRes->hrpcErr);
       }

     fBinding->unwindTo = (memory) Unwind;
     (*(fBinding->rpcDescr).FinishIncoming) (fBinding);
     return (HRPC_NORMAL);
   };

/*****************************************************/
   
long
InitReply (fBinding)
  HRPCBinding *fBinding;

  { HRPCErrRec *errRes;
    jmp_buf Unwind;

#ifdef DEBUGLISP
      if (debug) {
	  printf ("C call to InitReply\n");
	  fflush (stdout);
      };
#endif

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 return (errRes->hrpcErr);
       }


    fBinding->unwindTo = (memory) Unwind;
   (*(fBinding->rpcDescr).InitReply) (fBinding);
   return (HRPC_NORMAL);
  };

/***************************************************/

long
FinishReply (fBinding)
    HRPCBinding *fBinding;

{ HRPCErrRec *errRes;
  jmp_buf Unwind;

#ifdef DEBUGLISP
  if (debug) {
      printf ("C call to FinishReply\n");
      fflush (stdout);
  };
#endif

  if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
    return (errRes->hrpcErr);
  }


  fBinding->unwindTo = (memory) Unwind;
  (*(fBinding->rpcDescr).FinishReply) (fBinding);

   return (HRPC_NORMAL);
  };

