/*LINTLIBRARY*/

/* File: helpclient.c  Date: March 22, 1987 Kimi Gosney */

/* $Log:	helpclient.new.c,v $
 * Revision 1.1  87/06/29  19:10:01  kimi
 * Initial revision
 * 
 * Revision 1.3  87/04/21  11:44:39  kimi
 * worked wrt newruntime, without support for setjmp.
 * helpclient.o works for ltest6, and lower.
 * 
 * Revision 1.2  87/04/19  20:07:10  kimi
 * before adding handling code for setjmp/longhj
 * 
 * Revision 1.1  87/03/21  23:21:31  kimi
 * Initial revision
 * 
 * 
*/


/* return something from all of these, because they are intended
   to be called from lisp */


# include <setjmp.h>
# include <stdio.h>
# include "HRPC/basicRpc.h"
# include "HRPC/hrpcErrCodes.h"
extern int debug;                   /* in transp.c */

/*********************************************************/

extern HRPCErrRec *InitHRPCBinding();
extern HRPCErrRec *XXInitHRPCBinding();
                    /*source in /usr/src/local/HRPC/Binding/import.c */
                    /* actually picked up out of libHRPC.a */

struct listcell
    { struct listcell *cdr;
      int *car;
    };

long tmpBinding;

/***************************************************************/
long
LispInitHRPCBinding (fInstanceName, programNumber, versionNumber,
	programName)
       String fInstanceName;
   int programNumber, versionNumber;
   String programName;

{  HRPCErrRec *hError;


   hError = InitHRPCBinding (programNumber, versionNumber, fInstanceName,
			     programName, (char *)0, (char *)0, &tmpBinding);

   if (hError->hrpcErr == HRPC_NORMAL) {
     return ((long)tmpBinding);
   } else {
       if (debug) {
	   fprintf (stderr,"import error code: %d\n", hError->hrpcErr);
	   fflush (stderr);
       };
       return ( -1 * (long)(hError->hrpcErr) );
         /* we have to play throw and catch with this one, on the lisp side */
   };
 };


   
/*****************************************************************/

long
XXLispInitHRPCBinding (fInstanceName, programNumber, versionNumber,
	programName)
       String fInstanceName;
   int programNumber, versionNumber;
   String programName;

{  HRPCErrRec *hError;


   hError = XXInitHRPCBinding (programNumber, versionNumber, fInstanceName,
			     programName, (char *)0, (char *)0, &tmpBinding);

   if (hError->hrpcErr == HRPC_NORMAL) {
     return ((long)tmpBinding);
   } else {
       if (debug) { fprintf(stderr,
         "init error code : %d\n", hError->hrpcErr);
	 fflush(stderr);
       };
     return ( -1 * (long)(hError->hrpcErr) );	
          /* we have to play throw and catch with this one, on the lisp side */
   };
 };


   
/*****************************************************************/
 /* straight call from the library.  avoid separate cfasl.
    The source for the original is /usr/src/local/HRPC/HRpcRTS/closeBnd.c */

long
CloseHRPCBindingAux ( fBptr )
    HRPCBinding *fBptr;

{   CloseHRPCBinding (fBptr);
};

/*****************************************************************/

/* progN is defined in stub, and is a FranzLisp vectori-long */

long
InitOutgoing (fBinding, progN, procedureNumber, versionNumber)
     HRPCBinding *fBinding;
     long progN[];
   int procedureNumber, versionNumber;
   { HRPCErrRec *errRes;
     jmp_buf Unwind;

     if ( (fBinding->bndProgNum != progN[(long)fBinding->speaking]) 
		 || (fBinding->ifdPtr->versNum > 1)) {
			return (HRPC_WRNGSTUB);
	} 

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 return (errRes->hrpcErr);
       }

#ifdef DEBUGLISP
     if (debug) {
        printf ("InitOutgoing was called with procedureNumber %d, versionNumber %d\n",
		procedureNumber, versionNumber);
	printf ("and binding rpcType %d and bndProgNum %d\n",
		fBinding->rpcType, fBinding->bndProgNum);
     };
#endif

     fBinding->unwindTo = (memory) Unwind;
     (*((fBinding->rpcDescr).InitOutgoing)) (fBinding, procedureNumber, versionNumber);

     return(HRPC_NORMAL);
   };


/*****************************************************************/   

long
FinishOutgoing (fBinding)
   HRPCBinding *fBinding;

   { HRPCErrRec *errRes;
     jmp_buf Unwind;

#ifdef DEBUGLISP
     if (debug) printf ("in FinishOutgoing\n");
#endif


     if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
       return (errRes->hrpcErr);
     }


     fBinding->unwindTo = (memory) Unwind;
     (*((fBinding->rpcDescr).FinishOutgoing)) (fBinding);
     return ( HRPC_NORMAL);
   };

   
long
InitAnswer (fBinding)
  HRPCBinding *fBinding;

  { HRPCErrRec *errRes;
    jmp_buf Unwind;

#ifdef DEBUGLISP
    if (debug) printf ("InitAnswer\n");
#endif

    if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
      return (errRes->hrpcErr);
    }

    fBinding->unwindTo = (memory) Unwind;
    (*((fBinding->rpcDescr).InitAnswer)) (fBinding);
    return (HRPC_NORMAL);
  };

long
FinishAnswer (fBinding)
    HRPCBinding *fBinding;

  { HRPCErrRec *errRes;
    jmp_buf Unwind;
    
#ifdef DEBUGLISP
    if (debug) printf ("in FinishAnswer\n");
#endif
    
    if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 return (errRes->hrpcErr);
       }
    
    fBinding->unwindTo = (memory) Unwind;
    (*((fBinding->rpcDescr).FinishAnswer)) (fBinding);
    return (HRPC_NORMAL);
  };
