(comment 
/* File:  LispError.l  Date:  April 18 1987 Kimi Gosney  */

/*
 * INTERFACE:	HRPC-error-print error-code addnl-data
 *
 * FUNCTION:	inform-user.  Is usually called by err
 *
 * IMPORTS:	LispErrorCodes.l
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 */

;/* $Log:	LispError.l,v $
 * Revision 1.1  87/06/29  19:08:02  kimi
 * Initial revision
 * 
 * Revision 1.2  87/04/19  18:52:30  kimi
 * changed from fexpr to lexpr
 * 
*/

)

(defun HRPC-error-print n


  (caseq (arg 1)
	 (0                 ;TYPEMISMATCH
	  (print
	   `(HRPC-Send expected a ,(arg 2) and got a ,(arg 3))))
		  


	 (1                 ;NULL-OUTGOING
	  (print '(Unexpected nil value in outgoing argument)))

	 (2                 ;UNKNOWNTYPE
	  (print `(Unknown type encountered by ,(arg 2))))

	 (3                 ;RUNTIME-ERROR
	  (print `(Run-time HRPC error -- code
	      ,(caseq (diff (arg 2) 65536)      ;can't use caseq on large num
		 (1 'HRPC_REPLYTMO)
		 (2 'HRPC_PEERDIED)
		 (3 'HRPC_BADPROGN)
		 (4 'HRPC_BADPROCN)
		 (5 'HRPC_BADPARAM)
		 (6 'HRPC_BADVERSN)
		 (7 'HRPC_BADAUTHN)
		 (8 'HRPC_WRNGSTUB)
		 (9 'HRPC_RPCVERSN)
		 (10 'HRPC_SYSERR)
		 (11 'HRPC_UNKNERR)
		 (12 'HRPC_NOSERVER)
		 (258 'HLISP_UNKOTWTYPE)         ; see transp.c 0x10102
		 (259 'HLISP_OUTOFRANGE)              ; see transp.c 0x10103
		 (t     (list 'unknown 'code (diff (arg 2) 65536)))
		 ))))

	 (4                 ;SERVER-FN-ERROR
	  (print
	   `(Server function ,(arg 2) encountered an error during execution)))
	 (5                 ;CLIENT-FN-ERROR
	  (print
	   `(Client function ,(arg 2) encountered an error during execution)))
	 (t
	  (print `(Unknown run-time error -- LispError code ,(arg 1))))
	 )
  (setq ER%-HRPC-ERROR (arg 1))
  'ER%-HRPC-ERROR             ; the atom itself is the return value
  )
