( comment /* File:  HRPCsendreceive.l   Date:  April 18 1987 Kimi Gosney  */

/*
 * INTERFACE:	(HRPC-Send fBinding type-pattern outgoing)
                It returns either t --  if outgoing sent correctly --
		or the special symbol ER%-HRPC-ERROR -- whose value is
		that of the error code.
 *
 * FUNCTION:	marshall the marshalling routines
 *
 * IMPORTS:     fBinding is obtained at run-time using Import routine
 *              type-pattern is output by the stub compiler
 *
 * EXPORTS:	serverTalkLisp; clientTalkLisp.

                HRPC-Recv; HRPC-Recv-aux; HRPC-Send;
                HRPC-Send-aux are visible but not intended for export
 *
 * DESIGN:	use the type-pattern obtained from the stub compiler to
                know how to interpret the elements of outgoing.  As opposed
		to applying LispSend (in sendreceive.l) this removes
		restrictions on how one builds up the outgoing since
		additional eval'ing gets done if that is what is wanted.

		Note: errset for these err s is located in the stub!
		      The justification for that is to allow the user to
		      turn off the error-prints --  if desired.
 *
 */

;/* $Log:	HRPCsendreceive.l,v $
 * Revision 1.5  87/06/29  19:06:37  kimi
 * working copy as of 6/29/87
 * 
 * Revision 1.4  87/06/14  00:00:32  kimi
 * works with catch/throw.  has server mssgs.
 * wanting to add Choice types
 * 
 * Revision 1.3  87/05/30  20:29:01  kimi
 * works with errset.  wanting to add server mssgs
 * 
 * Revision 1.2  87/05/07  18:31:02  kimi
 * works with hand-built stubs
 * 
 * Revision 1.1  87/04/19  19:16:33  kimi
 * Initial revision
 * 
*/

)



(load 'LispErrCodes.l)    

(setq	INVALID_SPEAK   0
	SUN_XDR_TCP   1
	SUN_XDR_UDP   2
	COURIER_COURIER_SPP   3
	DEC_SRC_UDP   4
)				; defines, for use by server

(putprop 'LispSend 'sendreceive.l 'autoload)
(putprop 'LispReceive 'sendreceive.l 'autoload)
(putprop 'ArraySend 'constructed.l 'autoload)
(putprop 'ArrayRecv 'constructed.l 'autoload)
(putprop 'SequenceSend 'constructed.l 'autoload)
(putprop 'SequenceRecv 'constructed.l 'autoload)
(putprop 'ChoiceSend 'constructed.l 'autoload)
(putprop 'ChoiceRecv 'constructed.l 'autoload)

;*************************************************************;
(cond ((member 'LOCAL (command-line-args))
       (load 'dummyTransp.l))
      (t
       (load 'runTimeDefs.l)))

;****************************************************************;


(defun rLispCatchHandler (rLispErrorDescription)
  (print `(catch handler with args ,rLispErrorDescription))
  (terpri)
;           (setq ER%all 'rLispCatchHandler)
  (throw (rLispTranslate rLispErrorDescription) 'rLispCatch))


;(defun rLispTranslate (rLispErrorDescription)    ; supply a default
;  rLispErrorDescription)


;****************************************************************;

(defun serverTalkLisp (fBinding detect_jmp fn_name arg_pattern return_pattern)
              ; if Recv encounters any errors, it throws an err
  (setq _HRPCLisp_input (HRPC-Recv fBinding detect_jmp arg_pattern))
              ; the C run-time pieces return 0 if okay, or errCode if C error
  (or (zerop (setq _HRPCLisp_tmp (FinishIncoming fBinding)))
      (err (HRPC-error-print RUNTIME-ERROR _HRPCLisp_tmp)))

  (setq ER%all 'rLispCatchHandler)
  (setq _HRPCLisp_output
	(catch
	    (apply fn_name _HRPCLisp_input)
	  'rLispCatch))
  (setq ER%all nil)

  (or (zerop (setq _HRPCLisp_tmp (InitReply fBinding)))
      (err (HRPC-error-print RUNTIME-ERROR _HRPCLisp_tmp)))
  (HRPC-Send fBinding detect_jmp return_pattern _HRPCLisp_output)
  (or (zerop (setq _HRPCLisp_tmp (FinishReply fBinding)))
      (err (HRPC-error-print RUNTIME-ERROR _HRPCLisp_tmp)))
)


(defun clientTalkLisp (fBinding detect_jmp arg_pattern return_pattern
		       progN procNum verNum output)
  
  (or (zerop (setq _HRPCLisp_tmp (InitOutgoing fBinding progN procNum verNum)))
      (err (HRPC-error-print RUNTIME-ERROR _HRPCLisp_tmp)))

            ; if Send encounters any errors, it throws an err
  (HRPC-Send fBinding detect_jmp arg_pattern output)
              ; the C run-time pieces return 0 if okay, or errCode if C error
  (or (zerop (setq _HRPCLisp_tmp (FinishOutgoing fBinding)))
      (err (HRPC-error-print RUNTIME-ERROR _HRPCLisp_tmp)))

  (or (zerop (setq _HRPCLisp_tmp (InitAnswer fBinding)))
      (err (HRPC-error-print RUNTIME-ERROR _HRPCLisp_tmp)))
  (setq output
	(HRPC-Recv fBinding detect_jmp return_pattern))
  (or (zerop (setq _HRPCLisp_tmp (FinishAnswer fBinding)))
      (err (HRPC-error-print RUNTIME-ERROR _HRPCLisp_tmp)))
  output        ; return the value received over-the-wire
)


;**********************************************************************;


(defun HRPC-Send (fBinding detect-jmp type-pattern outgoing)

   (cond ((null type-pattern)
	  (cond ((null outgoing) t)     ; if both are null, okay, so return
		( t (err (HRPC-error-print TYPEMISMATCH
					   'null-argument
					   (type outgoing))))))
	                                ; else call err

	 ((equal type-pattern '(Lispval))
		 (LispSend fBinding detect-jmp outgoing))

           ; if outgoing is null for any of the following, that's wrong
	 ((null outgoing)
	  (err (HRPC-error-print NULL-OUTGOING)))
	 ((atom type-pattern)
	  (cond
	        ((atom outgoing)
		 (HRPC-Send-aux fBinding detect-jmp type-pattern outgoing))
		(t
		 (err (HRPC-error-print TYPEMISMATCH
					type-pattern
					(type outgoing))))))

	 (t                       ; has to be a list, now
	  (caseq (car type-pattern)
		 (Sequence
		  (or (listp outgoing)
		      (err (HRPC-error-print TYPEMISMATCH
					     'list
					     (type outgoing))))
		  ; making use of short-circuit eval
		  (SequenceSend fBinding
				     detect-jmp
				     (cadr type-pattern)
				     (caddr type-pattern)
				     outgoing))
		 (Array
		  (or (arrayp outgoing)
		      (err (HRPC-error-print TYPEMISMATCH
					     'array
					     (type outgoing)
					     )))
		  (ArraySend fBinding
				  detect-jmp
				  (cadr type-pattern)
				  (caddr type-pattern)
				  outgoing))
		 (Choice
		  (ChoiceSend fBinding
				   detect-jmp
				   (cadr type-pattern)
				   (caddr type-pattern)
				   outgoing))

		 ; so this is a composed type and is non-null
		 ; this would be better if changed to iterative form
		 ; both type-pattern and outgoing are non-null, and
		 ; type-pattern is known to be a list, but
		 ; we don't yet know that outgoing is also a list

		 (t (or (listp outgoing)
			(err (HRPC-error-print TYPEMISMATCH
					       'list
					       (type outgoing))))
		    (HRPC-Send fBinding
			       detect-jmp
			       (car type-pattern)
			       (car outgoing))
		    (HRPC-Send fBinding
			       detect-jmp
			       (cdr type-pattern)
			       (cdr outgoing))))
	  )
 ))



;***********************************************************************;




( defun HRPC-Send-aux (fBinding detect-jmp typekey outgoing)

	                       ; Messy because we have to deal with
	                       ; setjmp in the C run-time
  (caseq typekey
	 (Integer (or (and (fixp outgoing)
			    (not (bigp outgoing))
			    (lessp outgoing 65535)
			    (greaterp outgoing -65535))
		       (err (HRPC-error-print TYPEMISMATCH
					      'Integer
					      (type outgoing))))
		   (IntegerTransport fBinding
				     detect-jmp
				     outgoing))
	 (LongInteger (or (and (fixp outgoing)
			    (not (bigp outgoing)))
		       (err (HRPC-error-print TYPEMISMATCH
					      'LongInteger
					      (type outgoing))))
		   (LongIntegerTransport fBinding
				     detect-jmp
				     outgoing))
	 (Cardinal (or (and (fixp outgoing)
			    (not (bigp outgoing))
			    (greaterp outgoing -1)
			    (lessp outgoing 65536))
		       (err (HRPC-error-print TYPEMISMATCH
					      'Cardinal
					      (type outgoing))))
		   (CardinalTransport fBinding
				     detect-jmp
				     outgoing))
	 (LongCardinal (or (and (fixp outgoing)
			    (not (bigp outgoing))
			    (greaterp outgoing -1))
		       (err (HRPC-error-print TYPEMISMATCH
					      'LongCardinal
					      (type outgoing))))
		   (LongCardinalTransport fBinding
				     detect-jmp
				     outgoing))
	 (String (or (stringp outgoing)
		      (err (HRPC-error-print TYPEMISMATCH
					     'String
					     (type outgoing))))
		  (StringTransport fBinding
				   detect-jmp
				   outgoing))

	 (Unspecified (UnspecTransport fBinding detect-jmp outgoing))
	 (LongUnspecified (LongUnspecTransport fBinding
					       detect-jmp
					       outgoing))

           ; note that anything non-nil goes as t
	 (Boolean (cond ((null outgoing)
			 (BooleanTransport fBinding
					       detect-jmp
					       '0))
			(t (BooleanTransport fBinding
						 detect-jmp
						 '1))))

	 (t (err (HRPC-error-print UNKNOWNTYPE 'HRPC-Send-aux)))
	 )

  (or (equal (vrefi-long detect-jmp 0) 0)
      (err (HRPC-error-print RUNTIME-ERROR (vrefi-long detect-jmp 0))))
)


;***********************************************************************;




(defun HRPC-Recv (fBinding detect-jmp type-pattern)
   (prog (tmplist dummyArg)
	 (setq tmplist nil
	       dummyArg 0)

	 (cond ((null type-pattern)(return nil))   ; okay, all done
	       
	       ((atom type-pattern)
		(return
		 (HRPC-Recv-aux fBinding
				detect-jmp
				type-pattern
				dummyArg)))
	       
	       ((equal type-pattern '(Lispval))
		 (return 
		  (LispReceive fBinding detect-jmp dummyArg)))


	       (t                       ; has to be a list, now
		(caseq (car type-pattern)
		       (Sequence
			(return 
			 (SequenceRecv fBinding detect-jmp
					    (cadr type-pattern)
					    (caddr type-pattern)
					    dummyArg)))
		       (Array
			(return 
			 (ArrayRecv fBinding detect-jmp
					 (cadr type-pattern)
					 (caddr type-pattern)
					 dummyArg)))
		       (Choice
			(return
			 (ChoiceRecv fBinding detect-jmp
					  (cadr type-pattern)
					  (caddr type-pattern)
					  dummyArg)))

		 ; so this is a composed type and is non-null
		 ; type-pattern is known to be a list.

		       (t
			(return (cons

				 (HRPC-Recv fBinding
					  detect-jmp
					  (car type-pattern))

				 (HRPC-Recv fBinding
					    detect-jmp
					    (cdr type-pattern)))))
		       )
		)
	       ))
)



;***********************************************************************;



( defun HRPC-Recv-aux (fBinding detect-jmp typekey dummyArg)
  (prog (retval)               ; prog is solely to scope the name
	                       ; Messy because we have to deal with
	                       ; setjmp in the C run-time
  (caseq typekey
	 (Integer (setq retval (IntegerTransport fBinding
						  detect-jmp
						  dummyArg)))
	 (LongInteger (setq retval (LongIntegerTransport fBinding
						  detect-jmp
						  dummyArg)))
	 (Cardinal (setq retval (CardinalTransport fBinding
						  detect-jmp
						  dummyArg)))
	 (LongCardinal (setq retval (LongCardinalTransport fBinding
						  detect-jmp
						  dummyArg)))
	 (String (setq retval (StringTransport fBinding
						detect-jmp
						dummyArg)))

	 (Unspecified (setq retval
			    (UnspecTransport fBinding detect-jmp dummyArg)))
	 (LongUnspecified (setq retval
				(LongUnspecTransport fBinding
					       detect-jmp
					       dummyArg)))

            ; remembering that Booleans are coded 0,1 according to HCS spec.
	 (Boolean (setq retval
			(cond ((zerop (BooleanTransport fBinding
					       detect-jmp
					       dummyArg)) nil)
			      ( t t))))


	 (t (err (HRPC-error-print UNKNOWNTYPE 'HRPC-Recv-aux)))
	 )

  (or (equal (vrefi-long detect-jmp 0) 0)
      (err (HRPC-error-print RUNTIME-ERROR (vrefi-long detect-jmp 0))))
  (return retval)
))

;*************************************************************;

(defun unListifyNonError (x)
  (cond 
	((equal 1 (length x)) (car x))
	(t x))
)


;*************************************************************;

; for conditional inclusion of this file

(sstatus feature _HRPCSR)
