/* File:  Finder.c  Date: May 25, 1987   */

/*
 * INTERFACE:	UserList, by machine
 *
 * FUNCTION:	provides list of Users, and hosts if they are logged in
 *		from elsewhere.  This is an auxiliary server for the real
 *		server, which sorts through this stuff, looking for someone.
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	This is a slight modification of Dennis Ching's RemoteUsers.
 *		Very little has been done to it, other than make it an HRPC
 *		server, and add a few more fields.  Kimi Gosney, 5/87.
 *
 */

/* $Log:	 $
*/

#include <stdio.h>
#include <sys/time.h>

#define HRPC_SERVER
#include "Finder.h"

/*
 * HRPC who server for Suns/Vaxen
 */
#include <utmp.h>
#include <pwd.h>
#include <ctype.h>

#define NMAX sizeof(utmp.ut_name)
#define LMAX sizeof(utmp.ut_line)
#define	HMAX sizeof(utmp.ut_host)

struct	utmp utmp;
struct	passwd *pw;
struct	passwd *getpwuid();
struct  passwd *getpwnam();

int numUsers = 0;
#define MAX_USERS 80
#define FINDSTRMAX 20000

Finder_User curUsers[MAX_USERS];

char stringTable[FINDSTRMAX];
char *stindex;

char	hostname[32];

char	*ttyname(), *rindex(), *ctime(), *strcpy();

#define RUSERS 8000
#define RUVERS 1
#define LISTU  1

/* "forward" */
int FormatUsers();



FILE *fi = NULL;

FormatUsers()
{
	register char *tp, *s;
	int i;

	stindex = stringTable;
	numUsers = 0;
	
	s = "/etc/utmp";

        if ( fi == NULL ) {
	    if ((fi = fopen(s, "r")) == NULL) {
		puts("Finder: cannot open utmp");
		exit(1);
	    }
	}
	else 
	if ( fseek( fi, (long) 0, 0 ) < 0 ) {
	    perror("fseek");
	    return;
	}

	while (fread((char *)&utmp, sizeof(utmp), 1, fi) == 1) {
		if (utmp.ut_name[0] == '\0')
			continue;
		FormatLine();
		++numUsers;
		if (numUsers >= MAX_USERS) {
		    printf (stderr, "Finder: too many users for Finder\n");
		    exit();
		}
	}
#ifdef DEBUG
	for( i = 0; i <numUsers; i++ ) {
	    printf("'%s' '%s'\n",curUsers[i].UsersFullName,curUsers[i].OtherInfo);
	}
#endif
}

FormatLine()
{
	register char *cbuf;
	char utnam[20];
	char utline[20];
	char hname[20];
	char hshortname[20];
	char fullname[80];
	char fulldate[80];
	char junkline[200];
	char samename[30];
	
	sprintf(utnam,"%-*.*s ",NMAX,NMAX,utmp.ut_name);
	sprintf(utline,"%-*.*s ",LMAX,LMAX,utmp.ut_line);

	curUsers[numUsers].UserName = stindex;
	strcpy(stindex,utnam);		/* for use by Finder */
	stindex += (strlen(utnam)+2);
#ifdef DEBUGNEW
	printf("utnam is %s, len is %d, stindex is %d\n", utnam,
		(strlen(utnam)), (long)stindex);
#endif

	strncpy(fullname,utmp.ut_name,NMAX);
        fullname[NMAX] = '\0';
	strcpy(samename,fullname);
	if ( (samename[0] >= 'a') && (samename[0] <= 'z') ) {
	    samename[0] -= 0x20;
	}
	pw = getpwnam(fullname);
	if ( pw != (struct passwd *) 0 ) {
	    cbuf = fullname;
	    while ( (*pw->pw_gecos != ',') && (*pw->pw_gecos != '\0') ) {
		if ( *pw->pw_gecos == '&' ) {
		    strcat(cbuf,samename);
		    cbuf += (strlen(samename)+2);
		    pw->pw_gecos++;
		    cbuf++;
		    continue;
		}
		*cbuf++ = *pw->pw_gecos++;
	    }
	    *cbuf++ = ' ';
	    *cbuf = '\0';
	}
	else strcpy(fullname,"??? ");
	cbuf = ctime(&utmp.ut_time);
	sprintf(fulldate,"%.12s ", cbuf+4);
	if (utmp.ut_host[0]) {
		sprintf(hname,"host:%.*s", HMAX, utmp.ut_host);
		sscanf(hname,"host:%[^.]", hshortname);
	}
	else {
	    strcpy(hname, " ");
	    strcpy (hshortname, " ");
	};

	curUsers[numUsers].Host = stindex;
	strcpy(stindex,hshortname);         /* for use by Finder */
	stindex += (strlen(hname)+2);
#ifdef DEBUGNEW
	printf("hname is %s, len is %d, stindex is %d\n", hname,
		(strlen(hname)), (long)stindex);
#endif
	
	strcpy(junkline,utnam);
	strcat(junkline,utline);
	strcat(junkline,fulldate);
	strcat(junkline,hname);
	curUsers[numUsers].UsersFullName = stindex;
	strcpy(stindex,fullname);
	stindex += (strlen(fullname)+2);
	curUsers[numUsers].OtherInfo = stindex;
	strcpy(stindex,junkline);
	stindex += (strlen(junkline)+2);

		/* used by Finder */
	curUsers[numUsers].TimeOn = utmp.ut_time;
}

void
Finder_Where (fBinding, ulist)
     HRPCBinding *fBinding;
     Finder_UserList *ulist;

{  FormatUsers();
   ulist->length = numUsers;
   ulist->sequence = curUsers;
};



main(argc,argv)
int argc;
char* argv[];
{
  static HRPCBinding 	**avBinds;
  static SpeakDefs_Speak	avPrefs[] = {
	SUN_XDR_TCP,
    /*	COURIER_COURIER_SPP,	*/
	INVALID_SPEAK	};
  int fNPrefs = 1;
  int autoact = 0;

    fprintf(stderr,"Starting Remote Users Server as process %d\n", getpid() );
    Finder_Export( "Finder",	/* string name of server */
		 &autoact,		/* autoactivate? 0=no,
	 			   EXPF_AUTOACT = yes, EXPF_PREACT=no */
		 avPrefs,	/* what I speak */
		 &fNPrefs,      /* how many speak types input,
		 		   how many bindings upon output. */
		 &avBinds );	/* returned binding info */

    printf ("returned exp flags: %d.\n", autoact);
    printf ("number of bindings: %d.\n", fNPrefs);

    if (autoact & EXPF_AUTOACT ) {
	struct timeval tmo;

	tmo.tv_sec = 30;
	tmo.tv_usec = 0;
	HRPCSetRequestTMO ( &tmo, 0);

	printf ("timeout set at %d sec\n", tmo.tv_sec);
    };

    Finder_Server( fNPrefs, avBinds );	
};   
