
(comment
/* File:  Finder.l  Date:   May 25 1987 Kimi Gosney */

/*
 * INTERFACE:	user offers name; Finder looks to see if name is logged in
 *		on any machine with a FinderServer on it.  If multiple; 
 *		looks to see where started from.
 *
 * FUNCTION:	
 *
 * IMPORTS:	Finder_client.l
 *
 * EXPORTS:	--
 *
 * DESIGN:	calls FinderServer on a list of machines.  If user is
 *		 returned- checks host field.  If non-empty- follows
 *		 looking for primary log-in.
 *
 */


; /* $Log:	Finder.l,v $
 * Revision 1.2  87/08/03  21:25:18  kimi
 * *** empty log message ***
 * 
 * Revision 1.1  87/06/27  20:58:36  kimi
 * Initial revision
 * 
  */
)

(load 'Finder_client.l)

     ; these are the machines that have servers available on them.
(setq possibleSet '("june" "wally" "roskilde"))

(defun Finder (Finder_Input_UserName)
    (setq test possibleSet
	  tested nil
	  primaryList nil
	  secondaryList nil)
    
    (Finder-aux Finder_Input_UserName test)

    (list primaryList secondaryList))


(defun Finder-aux (user testlist)
    (cond ((null testlist) nil)
	  (t (CheckMachine (car testlist) user)

	     (Finder-aux user  (cdr testlist)))))


; HRPC code here
(defun CheckMachine (machine user)
  (cond ((member machine possibleSet)
	 (print `(Checking for ,user on ,machine))
	 (terpri)
	 (setq bptr (Finder_Import machine)
	       tested (cons machine tested))

	 
	 (cond ((lessp bptr 1) (err (HRPC-error-print (* -1 bptr))))
	       (t (CheckRtn (car (Finder_Where bptr)) user machine)
		  (CloseHRPC bptr))
	       ))
	(t
	 (print `(assuming ,user is coming from ,machine))
	 (terpri)
	 (setq primaryList (cons machine primaryList))))
)
    
(defun CheckRtn (userList userName currentMachine)
    (cond ((null userList) nil)
	  (t
	   (cond ((CompareUser userName (caar userList))
		  (cond ((equal " " (setq hostMachine (cadar userList)))
			 (print `(,user logged into ,currentMachine ))
			 (terpri)
			 (setq primaryList (cons currentMachine primaryList)))
			
			(t 
			 (setq secondaryList (cons currentMachine secondaryList))
			 (print `(,user secondary on ,currentMachine))
			 (terpri)
			 (CheckMachine hostMachine userName))))
		 (t t))
	   (CheckRtn (cdr userList) userName currentMachine)) ; collect all instances
	  )
)

; userName is an atom and thisName is a string that is blank-padded
(defun CompareUser (userName thisName)
  (cond ((equal (exploden (get_pname userName))
		(ExtractUserName (exploden thisName)))
	 t)
	(t nil)))

(defun ExtractUserName (theseLetters)
  (cond ((equal (car theseLetters) 32) nil)
	(t (cons (car theseLetters) (ExtractUserName (cdr theseLetters))))))
