/* File: /u1/oystr/HRPC/LWP/timer.c  Date:  18-Aug-1987  */

#define _TIMER_IMPL_
#include "LWPdefs.h"

typedef unsigned char bool;

#define expiration TotalTime

#define new_elem()	((struct timerElem *) malloc(sizeof(struct timerElem)))

#define MILLION	1000000

/* t1 = t2 - t3 */

static subtract(t1, t2, t3)
    register struct timeval *t1, *t2, *t3;
{
    register int sec, usec;

    sec = t2 -> tv_sec;
    usec = t2 -> tv_usec;
    if (t3->tv_usec > usec) {
	usec += MILLION;
	sec--;
    }
    t1 -> tv_usec = usec - t3 -> tv_usec;
    t1 -> tv_sec = sec - t3 -> tv_sec;
}

/* t1 += t2; */

static add(t1, t2)
    register struct timeval *t1, *t2;
{
    t1 -> tv_usec += t2 -> tv_usec;
    t1 -> tv_sec += t2 -> tv_sec;
    if (t1->tv_usec >= MILLION) {
	t1 -> tv_sec += t1 -> tv_usec / MILLION;
	t1 -> tv_usec %= MILLION;
    }
}

/* t1 == t2 */

bool timereql(t1, t2)
    register struct timeval *t1, *t2;
{
    return (t1->tv_usec == t2->tv_usec) && (t1->tv_sec == t2->tv_sec);
}

/* t1 >= t2 */

static bool geq(t1, t2)
    register struct timeval *t1, *t2;
{
    return (t1->tv_sec > t2->tv_sec) ||
	   (t1->tv_sec == t2->tv_sec && t1->tv_usec >= t2->tv_usec);
}

static bool blocking(t)
    register struct timerElem *t;
{
    return (t->TotalTime.tv_sec < 0 || t->TotalTime.tv_usec < 0);
}


/*
    Initializes a list -- returns -1 if failure, else 0.
*/

int timerInit(list)
    register struct timerElem **list;
{
    *list = new_elem();
    if (*list == NIL)
	return -1;
    else {
	(*list) -> Next = *list;
	(*list) -> Prev = *list;
	(*list) -> TotalTime.tv_sec = 0;
	(*list) -> TotalTime.tv_usec = 0;
	(*list) -> TimeLeft.tv_sec = 0;
	(*list) -> TimeLeft.tv_usec = 0;
	(*list) -> BackPointer = NIL;

	fasttimeInit(1);
	return 0;
    }
}

int timerFinal(list)
    register struct timerElem **list;
{
    if (list == NIL || *list == NIL)
	return -1;
    else {
	free(*list);
	*list = NIL;
	return 0;
    }
}

/*
    Inserts elem into the timer list pointed to by *tlistPtr.
*/

void timerInsert(tlistPtr, elem)
    struct timerElem *tlistPtr;	/* pointer to head pointer of timer list */
    struct timerElem *elem;	/* element to be inserted */
{
    extern insque();
    register struct timerElem *next;

    /* TimeLeft must be set for function lwpSelectManager with infinite timeouts */
    elem -> TimeLeft = elem -> TotalTime;

    /* Special case -- infinite timeout */
    if (blocking(elem)) {
	insque(elem, tlistPtr->Prev);
	return;
    }

    /* Finite timeout, set expiration time */
    timerGetTimeOfDay(&elem->expiration, 0);
    add(&elem->expiration, &elem->TimeLeft);
    next = NIL;
    FOR_ALL_ELTS(p, tlistPtr, {
	if (blocking(p) || !geq(&elem->TimeLeft, &p->TimeLeft)) {
	    next = p;	/* Save ptr to element that will be after this one */
	    break;
	}
     })

    if (next == NIL) next = tlistPtr;
    insque(elem, next->Prev);
}

static struct timeval zero = { 0, 0 };

/*
    Walks through the specified list and updates the TimeLeft fields in it.
    Returns number of expired elements in the list.
*/

int timerRescan(tlist)
    struct timerElem *tlist;	/* head pointer of timer list */
{
    struct timeval time;
    register int expired;

    timerGetTimeOfDay(&time, 0);
    expired = 0;
    FOR_ALL_ELTS(e, tlist, {
	if (!blocking(e)) {
	    subtract(&e->TimeLeft, &e->expiration, &time);
	    if (geq(&zero, &e->TimeLeft)) expired++;
	}
    })
    return expired;
}
    
/*
    RETURNS POINTER TO earliest expired entry from tlist.
    Returns 0 if no expired entries are present.
*/

struct timerElem *timerGetExpired(tlist)
    struct timerElem *tlist;	/* head pointer of timer list */
{
    FOR_ALL_ELTS(e, tlist, {
	if (!blocking(e) && geq(&zero, &e->TimeLeft)) return e;
    })
    return NIL;
}
    
/*
    Returns a pointer to the earliest unexpired element in tlist.
    Its TimeLeft field will specify how much time is left.
    Returns 0 if tlist is empty or if there are no unexpired elements.
*/

struct timerElem *timerGetEarliest(tlist)
    struct timerElem *tlist;
{
    register struct timerElem *e;

    e = tlist -> Next;
    return (e == tlist ? NIL : e);
}
