/* File: /u1/oystr/HRPC/LWP/releaseSigs.c  Date:  20-Aug-1987  */

/*
 * $Header$
 * This file was taken from the set of Eden Kernel .c files.  Various lines
 * (not needed in the current application) have been removed.
 * 
 * $Log$
 *
 *  20-Aug-1987: Initial implementation, Mark Squillante
 */

#include <stdio.h>
#include <sys/types.h>
#include "cmuipc.h"

#undef integer		/* Silly stdtypes */
#include "stdTypes.h"
#include "kEvents.h"

extern	HRPC_SignalHandler();
/*
 * ReleaseSigs1
 *
 * Releases signals held by HoldSigs.  If a signal came in while the
 * signals were being held, the handler will be called at this point.
 * ReleaseSigs1 is called by the ReleaseSigs macro only when some signal
 * is pending.
 */

ReleaseSigs1()
{
	int i, p, junk = SIGIO;
	
	if (!SigsHeld) {
		HoldSigs();
	}
	
	do {
            Pending = 0; /* A signal arriving here has either caused
                            SigEvent_NTimes > 0  or Pending=1.
                            so either it is processed by the if stmt
                            or it causes the outer loop to repeat. */

	    if ( SigEvent_Ntimes > 0 ) {
		SigEvent_Ntimes = 0;
		HRPC_SignalHandler(junk);
	    }
	} while ( SigsHeld = Pending);  /* Assignment MUST be performed
                                        atomically: Check generated code! */
}
