/* File: /u1/oystr/HRPC/LWP/lwpSelectManager.c  Date:  18-Aug-1987  */

/*
 * $Header$
 * FUNCTION: Routines that implement the lwpSelectManager thread needed by
 *		the LWP subsystem.
 * 
 * $Log$
 *
 *  18-Aug-1987: Initial implementation, Mark Squillante
 */

#include "kEvents.h"
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "../Transports/connDefs.h"

#define Purge(list) FOR_ALL_ELTS(req, list, { free(req->BackPointer); })

/* The lwpSelectManager process */
static struct itimerval coretimer;
static long SelectManager_lastcall = 0;
int lwpSelectManager_CheckMaxTime = 0;
int lwpSelectManager_MaxTime = 0;

typedef unsigned char bool;

static HRPC_LWPbomb ()
{int i,j; i = 1; j = 0; return i/j;}

static HRPC_LWPSelectManager(dummy)
    char *dummy;
{
    while( TRUE ) {
	static struct timeval	Poll = { 0, 0 };
	int 			fds, readfds, writefds, exceptfds, timetemp;
	struct timerElem	*earliest;
	struct timeval		timeout;
	bool			woke_someone;
	HRPCBinding		*fBptr;

	/* Wake up anyone who has expired between executions.
	   Keep going until we run out. */
	signal(SIGALRM, HRPC_LWPbomb);
	do {
	    woke_someone = FALSE;
		/* update TimeLeft fields in lwpRequests list */
	    timerRescan(lwpRequests);
	    while( TRUE ) {
		register struct lwpIoRequest *req;
		struct timerElem *expired;
		expired = timerGetExpired(lwpRequests);
		if (expired == NIL) break;
		woke_someone = TRUE;
		req = (struct lwpIoRequest *) expired -> BackPointer;
		/*** note that timeout occurred
		    => fBptr->transDescr.packetArrived was initialized to 0
		***/
		    /* remove corresponding request block */
		timerRemove(lwpRequests, &req->timeout);
		fBptr = (HRPCBinding *) req->HRPC_WaitCondition;
		    /* awaken LWP */
		(*HRPC_lwpDescr.Signal)(fBptr);
	    }
	    if ( HRPC_SIGNALdelivered ) woke_someone = TRUE;
	    if ( woke_someone ) {
		HRPC_LWPawakenSTMs();
		/* HRPC_SIGNALdelivered is reset by HRPC_LWPawakenSTMs */
		(*HRPC_lwpDescr.Scheduler)();
	    }
	} while (woke_someone);


	/* Prepare to perform select */
	readfds = HRPC_READFDS;
	writefds = 0;
	exceptfds = 0;
	earliest = timerGetEarliest(lwpRequests);
	if (earliest != NIL) {
	    timeout = earliest -> TimeLeft;

	    /* Do select */
	    lwpSelectManager_timeout = timeout;
	    if (timeout.tv_sec == -1 && timeout.tv_usec == -1) {
		/* infinite, sort of */
		lwpSelectManager_timeout.tv_sec = 100000000;
		lwpSelectManager_timeout.tv_usec = 0;
	    }
	    /* Check one last time for a signal delivery.  If one comes after
	       this, the signal handler will set lwpSelectManager_timeout to
	       zero, causing the select to return immediately.  The timer 
	       routines won't return a zero timeval because all of those guys
	       were handled above.  We're assuming that the kernel masks
	       signals while it's picking up the parameters to select. */
	    if ( HRPC_SIGNALdelivered )
		continue;	/* go to the top and handle them. */
	    if (lwpSelectManager_CheckMaxTime) {
		timetemp = time(0);
		if (SelectManager_lastcall > 0) {
		    if (timetemp - SelectManager_lastcall > lwpSelectManager_MaxTime)
			lwpSelectManager_MaxTime = timetemp - SelectManager_lastcall;
		}
		coretimer.it_value.tv_sec = 0;
		coretimer.it_value.tv_usec = 0;
		setitimer(0, &coretimer, 0);
	    }
	    fds = select(MAX_FDS, &readfds, &writefds, &exceptfds, &lwpSelectManager_timeout);

	    if (lwpSelectManager_CheckMaxTime) {
		SelectManager_lastcall = time(0);
		coretimer.it_value.tv_sec = 20;
		coretimer.it_value.tv_usec = 0;
		coretimer.it_interval.tv_sec = 0;
		coretimer.it_interval.tv_usec = 0;
		setitimer(0, &coretimer, 0);
	    }

	    /* See what happened */
	    if (fds == 0 && (lwpSelectManager_timeout.tv_sec != 0 || lwpSelectManager_timeout.tv_usec != 0)) {
		/* Real timeout only if signal handler hasn't set
		   lwpSelectManager_timeout to zero. */
		HRPC_LWPSignalTimeout(fds, &timeout);
	    }
	    /* else if (fds > 0)
		No need to awaken effected processes since the HRPC signal
			handler has already awakened them */

	}
	HRPC_LWPawakenSTMs();
	/* HRPC_SIGNALdelivered is reset by HRPC_LWPawakenSTMs */
	(*HRPC_lwpDescr.Scheduler)();
    }
}

static HRPC_LWPSignalTimeout(fds, timeout)
    int fds;
    register struct timeval *timeout;
{
    /* Find everyone who has specified timeout */
    FOR_ALL_ELTS(r, lwpRequests, {
	register struct lwpIoRequest *req;
	req = (struct lwpIoRequest *) r -> BackPointer;
	if (timereql(&r->TimeLeft, timeout)) {
	    /*** note that timeout occurred
		=> fBptr->transDescr.packetArrived was initialized to 0
	    ***/
	    timerRemove(lwpRequests, &req->timeout);
	    (*HRPC_lwpDescr.Signal)(req->HRPC_WaitCondition);
	} else
	    return;
    })
}

/* Stack size for lwpSelectManager process */
#define lwpSelectManagerSTACK_SIZE 16384

/* Keep lwpSelectManager process id */
static lwpPROCESS lwpSelectManager_Id = NIL;

int	HRPC_LWPinitSelectManager()
{
    extern int timerInit();
    int retval;

    /* If already initialized, just return */
    if ( lwpSelectManager_Id != NIL ) return(HRPC_LWP_EINIT);

    /* Initialize request lists */
    if ( timerInit(&lwpRequests) < 0 ) return(-1);

    retval = (*HRPC_lwpDescr.CreateThread)(HRPC_LWPSelectManager,
			lwpSelectManagerSTACK_SIZE, 0, 0,
			"SELECT MANAGER", &lwpSelectManager_Id);
    return(retval);
}

int	HRPC_LWPterminateSelectManager()
{
    int retval;

    Purge(lwpRequests)
    timerFinal(&lwpRequests);
    retval = (*HRPC_lwpDescr.DeleteThread)(lwpSelectManager_Id);
    lwpSelectManager_Id = NIL;
    return(retval);
}
