/* File: /u1/oystr/HRPC/LWP/lwpInit.c  Date:  18-Aug-1987  */

/*
 * $Header$
 * FUNCTION: Routines to initialize & terminate LWP support using the
 *		specified LWP package.
 * 
 * $Log$
 *
 *  18-Aug-1987: Initial implementation, Mark Squillante
 */

#define LWPinit
#include "kEvents.h"
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "../Transports/connDefs.h"

extern void MT_SelectAndReadPacket();
extern void MT_Select();

LWPtypes_Defs	HRPC_lwpType = SingleThread;
LwpControl	HRPC_lwpDescr = SingleThreadControlFilling;

int
SetupLwpSupport(createThread, deleteThread, wait, mwait, signal, scheduler)
    int (*createThread)(), (*deleteThread)(), (*wait)();
    int (*mwait)(), (*signal)(), (*scheduler)();
{
	extern int	HRPC_LWPinitSelectManager();
	extern int	HRPC_SetUpSignalHandler();
	int		retval = HRPC_LWP_SUCCESS;

	HRPC_lwpType = MultiThreaded;
	HRPC_lwpDescr.CreateThread = createThread;
	HRPC_lwpDescr.DeleteThread = deleteThread;
	HRPC_lwpDescr.Wait = wait;
	HRPC_lwpDescr.Mwait = mwait;
	HRPC_lwpDescr.Signal = signal;
	HRPC_lwpDescr.Scheduler = scheduler;
	HRPC_lwpDescr.SelectAndReadPacket = MT_SelectAndReadPacket;
	HRPC_lwpDescr.Select = MT_Select;

	retval = HRPC_SetUpSignalHandler();
	if ( retval == HRPC_LWP_SUCCESS ) {
	    retval = HRPC_LWPinitSelectManager();
	}

	return(retval);
}

int
TerminateLwpSupport()
{
	extern int	HRPC_CancelSignalHandler();
	extern int	HRPC_LWPterminateSelectManager();

	if ( HRPC_lwpType != SingleThread ) {
	    HRPC_CancelSignalHandler();
	    HRPC_LWPterminateSelectManager();
	}

	HRPC_lwpType = SingleThread;
	/* following line is a struct assignment */
	HRPC_lwpDescr = SingleThreadControl;
}
