/* File: /u1/oystr/HRPC/LWP/fasttime.c  Date:  18-Aug-1987  */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/mman.h>
#include <nlist.h>

extern char *valloc ();

static struct nlist nl[] = {
    { "_time" },
#define X_TIME		0
    { "" },
};

#define TRUE	1
#define FALSE	0

static enum InitState { notTried, tried, done } initState = notTried;
static int memFd;	/* our fd on /dev/mem */
static char *mem;	/* pointer to our valloced memory */
static struct timeval *timeP;	/* pointer to time in our address space */

/* Set up mapping of the kernel's time of day variable.  Return -1 if anything
   goes wrong.  In this case, timerGetTimeOfDay will call gettimeofday
   instead. */
fasttimeInit (printErrors)
    int printErrors;
{
#ifdef sun
    struct timeval  tv1, tv2;
    int pageSize, pageMask;
    int timeOff, timeEnd;
    int start, end;
    int nPages;

    initState = tried;
    nlist ("/vmunix", nl);
    if (nl[0].n_type == 0) {	/* no namelist */
	if (printErrors)
	    fprintf(stderr, "fasttimeInit: cannot find name list.\n");
	return (-1);
    }
    if ((memFd = open ("/dev/mem", O_RDONLY)) < 0) {
	if (printErrors)
	    fprintf(stderr, "fasttimeInit: cannot open /dev/mem.\n");
	return (-1);
    }
    lseek (memFd, nl[X_TIME].n_value, 0);
    read (memFd, &tv1, sizeof (tv1));
    gettimeofday (&tv2, 0);
    if (tv2.tv_sec - tv1.tv_sec < 0 || tv2.tv_sec - tv1.tv_sec > 5) {
	/* we've got the wrong kernel. */
	close (memFd);
	if (printErrors)
	    fprintf(stderr, "fasttimeInit: looks like bogus kernel.\n");
	return (-1);
    }
    /* figure out where the variables are so we can map them. */
    pageSize = getpagesize ();
    pageMask = pageSize - 1;
    timeOff = nl[X_TIME].n_value;
    timeEnd = timeOff + sizeof(struct timeval);
    start = timeOff & ~pageMask;
    nPages = (timeEnd - start + pageSize - 1) / pageSize;
    /* Get some memory to put them in... */
    if ((mem = valloc(nPages * pageSize)) == NULL) {
	close(memFd);
	if (printErrors)
	    fprintf(stderr, "fasttimeInit: cannot valloc memory.\n");
	return (-1);
    }
    /* map it */
    if (mmap(mem, nPages * pageSize, PROT_READ, MAP_SHARED, memFd, start) < 0) {
	close(memFd);
	if (printErrors)
	    fprintf(stderr, "fasttimeInit: cannot mmap kernel.\n");
	return (-1);
    }
    /* And compute the new addresses. */
    timeP = (struct timeval *) (mem + (timeOff - start));
    initState = done;
    return 0;
#else
return (0);
#endif
}

timerGetTimeOfDay (tv, tz)
    struct timeval *tv;
    struct timezone *tz;
{
#ifdef sun
    if (initState != done)
	if (initState == tried || fasttimeInit (FALSE) < 0) {
	    return gettimeofday (tv, tz);
	}
    if (tz != NULL)
	return gettimeofday (tv, tz);
    if (tv != NULL) {
	/* A structure assignment would not be indivisible, so assign the
	   parts separately and loop until we see the same value for
	   seconds twice.  This guarantees that we see monotonically
	   increasing time values. */
	do {
	    tv->tv_sec = timeP->tv_sec;
	    tv->tv_usec = timeP->tv_usec;
	} while (tv->tv_sec != timeP->tv_sec);
    }
    return 0;
#else
    return(gettimeofday(tv, tz));
#endif
}
