#ifndef LWPdefs
#define LWPdefs

#define NIL	0

#define MAX_FDS		    32
#define STM_lwp_priority    HRPC_LWP_NORMAL_PRIORITY
#define NOT_IN_DISPATCHER   (PFI) 0

#define HRPC_LWP_SUCCESS	0
#define HRPC_LWP_EBADPID	-1
#define HRPC_LWP_EBLOCKED	-2
#define HRPC_LWP_EINIT		-3
#define HRPC_LWP_EMAXPROC	-4
#define HRPC_LWP_ENOBLOCK	-5
#define HRPC_LWP_ENOMEM		-6
#define HRPC_LWP_ENOPROCESS	-7
#define HRPC_LWP_ENOWAIT	-8
#define HRPC_LWP_EBADCOUNT	-9
#define HRPC_LWP_EBADEVENT	-10
#define HRPC_LWP_EBADPRI	-11
#define HRPC_LWP_NO_STACK	-12
/* Maximum priority permissible (minimum is always 0) */
#define HRPC_LWP_MAX_PRIORITY	4
/* Usual priority used by user LWPs */
#define HRPC_LWP_NORMAL_PRIORITY (HRPC_LWP_MAX_PRIORITY-1)

#include <sys/time.h>
#include "timer.h"
#include <HRPC/basicRpc.h>

typedef int (*PFI)();

int	HRPC_READFDS;	/* mask composed of "active" fds.  Used by Signal
			 * Handler & in select calls */

int	HRPC_SIGNALdelivered;	/* signal flag: =1 if HRPC signal occurred */

u_long	HRPC_STMsToAwakenMask;	/* mask of STMs that should be awakened */

struct timerElem	*lwpRequests;		/* List of requests */
struct timeval	lwpSelectManager_timeout;	/* global so SH can zap it */

typedef u_long lwpPROCESS;
struct lwpIoRequest {

	struct timerElem	timeout;

	HRPCBinding	*HRPC_WaitCondition; /* condition on which blocked
					      * thread is waiting */
};
static struct lwpIoRequest *lwpNewRequest()
{
	register struct lwpIoRequest *request;

	request = (struct lwpIoRequest *) malloc(sizeof(struct lwpIoRequest));
	if (request == NIL) {
	    fatalerr("ERROR: Out of storage in lwpNewRequest\n");
	}
	return request;
}

/*
 * Lightweight process support.  This control structure
 * provides support in HRPC to link with an existing
 * LWP package.
 */
typedef struct {
	int (*CreateThread)(), (*DeleteThread)();
	int (*Wait)(), (*Mwait)(), (*Signal)();
	int (*Scheduler)();
	    /* the 2 following procs are not functions provided by a LWP pkg.
	     * they are maintained here because we currently have multi
	     * thread and single thread versions. */
	void (*SelectAndReadPacket)(), (*Select)();
} LwpControl;

#endif LWPdefs
