-- Courier interface for doing HRPC binding.  By Mike Schwartz, 11-11-86.

Binding : PROGRAM 1234 VERSION 1 =

BEGIN
	DEPENDS UPON SpeakDefs(750) VERSION 1;


	-- Type definitions

	SUN_XDR_UDP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	SUN_XDR_TCP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	COURIER_COURIER_SPP_BINDING_DESCR	: TYPE = RECORD
		[
		xnsAddr		: ARRAY 5 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	RAW_TCP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	RAW_UDP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	REAL_BINDING_DESCR	: TYPE = CHOICE SpeakDefs.Speak OF
		{
		INVALID_SPEAK		=> UNSPECIFIED,
		SUN_XDR_TCP		=> SUN_XDR_TCP_BINDING_DESCR,
		SUN_XDR_UDP		=> SUN_XDR_UDP_BINDING_DESCR,
		COURIER_COURIER_SPP	=> COURIER_COURIER_SPP_BINDING_DESCR,
		DEC_SRC_UDP		=> UNSPECIFIED,
		RAW_TCP			=> RAW_TCP_BINDING_DESCR,
		RAW_UDP			=> RAW_UDP_BINDING_DESCR
		};


	BINDING_DESCR	: TYPE = RECORD
		[
		useBA		: BOOLEAN,
		data		: REAL_BINDING_DESCR
		];

	BINDING_DESCR_LIST : TYPE = SEQUENCE 1000 OF BINDING_DESCR;

	-- Info. needed to make a binding descriptor (contains host name
	-- instead of network address; used by the HNS, HNSUIA, and binding
	-- NSMs)
	BINDING_DESCR_DESCR : TYPE = RECORD [
		NSvcName : STRING,	-- Name service that knows about the
					-- following host name
		hostName : STRING,
		speakType : SpeakDefs.Speak,
		portNum : LONG CARDINAL,
		progNum : LONG CARDINAL,
		useBA : BOOLEAN
	];

	BINDING_DESCR_DESCR_LIST : TYPE = SEQUENCE 1000 OF BINDING_DESCR_DESCR;


	-- HRPC Error returns

	HRPC_ERRCODE	: TYPE = LONG CARDINAL;

	IMPORT_NORMAL     : HRPC_ERRCODE =       0; -- success
	IMPORT_NSFAILED   : HRPC_ERRCODE = 020001X; -- No NS
	IMPORT_BAFAILED   : HRPC_ERRCODE = 020002X; -- No BA
	IMPORT_BADNAME    : HRPC_ERRCODE = 020003X; -- Name not found
	IMPORT_BADSPEAK   : HRPC_ERRCODE = 020004X; -- Bad speak type
	IMPORT_BADSYNTAX  : HRPC_ERRCODE = 020005X; -- Bad name syntax
	IMPORT_NOTREGIS   : HRPC_ERRCODE = 020006X; -- BA says "no such service"
	IMPORT_BADHOST    : HRPC_ERRCODE = 020007X; -- XX
	IMPORT_MISSINGNSM : HRPC_ERRCODE = 020001X; -- No NSM

	EXPORT_NORMAL     : HRPC_ERRCODE =	      0; -- success
	EXPORT_NSFAILED   : HRPC_ERRCODE = 030001X; -- can't register with NS
	EXPORT_BAFAILED   : HRPC_ERRCODE = 030002X; -- can't register with BA
	EXPORT_INUSE      : HRPC_ERRCODE = 030003X; -- can't "re-export"
	EXPORT_BADSPEAK   : HRPC_ERRCODE = 030004X;
	EXPORT_BADSYNTAX  : HRPC_ERRCODE = 030005X;

        STATUS_REC	: TYPE = RECORD
		 [
		 errCode: HRPC_ERRCODE,
		 notUsed: LONG UNSPECIFIED
		 ];


	-- Remote Entry Points

	EvalQueryInputs	: TYPE = RECORD
		[
		Type		: STRING,	-- e.g., "FileService"
		Instance	: STRING,	-- e.g., "mizar:CS:UWash"
		-- ProgNums is indexed by SpeakType
		ProgNums	: SEQUENCE 100 OF LONG CARDINAL,
		-- NSvcBDList is the BDescr list for the name service to call
		NSvcBDList : BINDING_DESCR_LIST
		];

	EvalQuery : PROCEDURE [serverQuery : EvalQueryInputs]
			RETURNS [serverList : BINDING_DESCR_LIST,
				 status : STATUS_REC ] = 1;

	RegisterServer : PROCEDURE [serverName : EvalQueryInputs,
				    descrList : BINDING_DESCR_LIST]
			RETURNS [status : STATUS_REC] = 2;

	-- I don't see any reason to leave this in here: No one wants to
	-- call it as a remote interface, and having it in here causes the
	-- procedure to be mulitply defined for remote NSMs: in the client
	-- binding stub, and in baInterface.c
	--ResolveBinding : PROCEDURE [speakType : SpeakDefs.Speak,
	--			    bindDescr : BINDING_DESCR]
	--		RETURNS [answer : BINDING_DESCR,
	--			 status : STATUS_REC] = 3;
END.
