/* File: /u1/oystr/HRPC/HRpcRTS/import.c  Date: 25-Feb-1986  */

/*
 * $Header$
 * INTERFACE:	HRPC runtime binding interface.
 *
 * FUNCTION:	Implement communication with HCS nameserver
 *		and HCS binding agent necessary for the various
 *		stages of binding.
 *
 * IMPORTS:	Standard HRPC include files.
 *
 * EXPORTS:	InitHRPCBinding
 *
 * DESIGN:	Continuing.  Currently hardwired to use
 *		only SUN RPC portmap protocol.
 *
 * $Log$
 * 25-Feb-1986:	Initial implementation, Jan Sanislo
 *	Throw-away hack job for SUN RPC only.  This is
 *	pretty disgusting stuff but is a valuable learning
 *	experience.
 */

#include <HRPC/cCourierTypes.h>
#include <HRPC/basicRpc.h>
#include <rpc/types.h>
#include <rpc/pmap_prot.h>
#include <netinet/in.h>
#include <netdb.h>

/****************************************************************
 * 			InitHRPCBinding				*
 ****************************************************************/

/*
 * INTERFACE:	InitHRPCBinding( fProg, fVers, fInstance
 *				 fSpare1, fSpare2, fSpare3,
 *				 fBinding )
 *
 * INPUT:	fProg, fVers: Program number & version number
 *		fInstance:    String name of instance (must be node
 *				name in current impl.
 *		fSpare*:      Spare params.
 *
 * OUTPUT:	fBinding:     Pointer to HRPCBinding structure
 *
 * EFFECT:	Contact "nameserver" and/or "binding agent"
 *		to get necessary information and fill in
 *		interface descriptor and preliminary binding info.
 *
 * DEFECTS:	Too numerous to mention.
 */

/*ARGSUSED*/
int InitHRPCBinding( fProg, fVers, fInstance,
		     fSpare1, fSpare2, fSpare3,
		     fBinding )
    LongCardinal fProg, fVers;
    String fInstance;
    LongUnspecified fSpare1, fSpare2, fSpare3;
    HRPCBinding **fBinding;
{
    InterfaceDescr *ifdptr;
    HRPCBinding    *lbptr;
    struct sockaddr_in server_in;
    struct hostent *hp;
    u_short pmstat;
    int useproto;

    ifdptr = (InterfaceDescr *) calloc(1, sizeof( InterfaceDescr ));
    ifdptr->progNum = fProg;
    ifdptr->versNum = fVers;

    lbptr = (HRPCBinding *) calloc( 1, sizeof( HRPCBinding ) );
    lbptr->ifdPtr = ifdptr;
    
    hp = gethostbyname( fInstance );
    if ( hp == (struct hostent *) 0 )
	fatalerr("InitHRPCBinding: can't get host '%s'.\n",fInstance);
    bcopy(hp->h_addr, &server_in.sin_addr, hp->h_length);
    server_in.sin_family = AF_INET;
    server_in.sin_port = 0;

    /* Call portmap on remote node, until we find one */
    pmstat = pmap_getport( &server_in, fProg, fVers, IPPROTO_UDP );
    if ( pmstat )
	useproto = IPPROTO_UDP;
    else {
	pmstat = pmap_getport( &server_in, fProg, fVers, IPPROTO_TCP );
	if ( !pmstat ) {
	    clnt_pcreateerror("InitHRPCBinding");
	    fatalerr("Fatal error.\n");
	}
	useproto = IPPROTO_TCP;
    }
    server_in.sin_port = htons(pmstat);

    /* Configure control blocks */
    ConfigRPC( lbptr, SUNRPC );
    ConfigOTW( lbptr, SUNOTW );
    ConfigTRANSP( lbptr, (useproto == IPPROTO_TCP) ? TCPTRANSP : UDPTRANSP,
		     &server_in );
    *fBinding = lbptr;
}
