/* File: /u1/oystr/HRPC/Dispatcher/dispatch.c  Date: 18-Jul-1986  */

/*
 * $Header$
 * INTERFACE:	General dispatcher for HRPC service requests.
 *
 * FUNCTION:	Detect arrival of *requests* on a set of
 *		ports.  Select one binding from those available
 *		and return it to a higher level routine.
 *
 * IMPORTS:	basicRpc.h
 *		various UNIX files.
 *
 * EXPORTS:	HRPCDispatcher
 *
 * DESIGN:	Continuing.
 *
 * DEFECTS:	This could be implemented in the XXX_Server
 *		stub routine to saves ourselves one procedure
 *		call.  OTOH, it would probably mean dragging
 *		presence/absence of LWPs up to stub level.  Linear
 *		search is inelegant, but for now there are very
 *		few bindings.  Potential for starvation since
 *		read mask is scanned low to high on each call.
 *		Hence high order fds coming ready may never been seen.
 *		Actually, this whole thing is crock.
 * $Log$
 *
 * Revision 1.1  87/01/??  ??:??:?? mss
 * Changes for lightweight process support.
 *
 * 18-Jul-1986:	Initial implementation, Jan Sanislo
 */

#include <sys/time.h>
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "../Transports/connDefs.h"
#include <errno.h>
extern int errno;

static int tmoset = 0;
static struct timeval defaulttmo;
static int (*ExitProc)();

int HRPCDispatcher( fNumBnd, fBndArr, fReady )
    int fNumBnd;
    HRPCBinding *fBndArr[];
    HRPCBinding **fReady;
{
    register int n;
    register int fdix;
    register int fullmask;
    int readfds, i, selectStatus;
    char *ME = "HRPCDispatcher";
    struct BindingQIdTableEntry idTable[BindingQIdTableMax];
    struct PacketQelement	*packetInfo;
    extern int	AddToBindingQ();
    extern struct BindingQelement *CleanUpBindingQ();
    
    /*
     * Create read mask.  This looks very tacky.  However,
     * it is necessary since we may be operating in a separate
     * LWP.  Cannot use a "global" mask since processes may be
     * allocated on a per connection basis.
     */
    fullmask = 0;
    for( n = 0; (n < fNumBnd) && (fBndArr[n] != (HRPCBinding *)NULL); n++ ) {
	fdix = fBndArr[n]->transDescr.sockfd;
	fdix = connStates[fdix].masterfd;
	fullmask |= connStates[fdix].selmask;
	if ( HRPC_lwpType != SingleThread ) {
	    /* construct BindingQelement & add to connStates[fd].BindingQ */
		/* first, set IdTable */
	    /* nothing needs to be set because we simply want the dispatcher
	     * awakened if a packet arrives on any of the
	     * fBndArr[n]->transDescr.sockfds */
	    AddToBindingQ(fBndArr[n],idTable,0,1);
	}
    }
    if ( !fullmask ) {
	/* nothing to read from */
	if ( HRPC_lwpType != SingleThread ) {
	    /* remove all fBptrs added to their respective BindingQs above */
	    for(n=0; (n < fNumBnd) && (fBndArr[n] != (HRPCBinding *)NULL); n++)
		CleanUpBindingQ(fBndArr[n],1);
	}
	return( 0 );
    }
    
again:
    /*
     * Do the select.
     */
    readfds = fullmask;
    (*HRPC_lwpDescr.Select)(fBndArr,
				(tmoset) ? &defaulttmo : (struct timeval *) 0,
				&readfds, &selectStatus);

    if ( HRPC_lwpType != SingleThread ) {
	/* remove all fBptrs added to their respective BindingQs above */
	for( n = 0; (n < fNumBnd) && (fBndArr[n] != (HRPCBinding *)NULL); n++ )
	    CleanUpBindingQ(fBndArr[n],1);
    }

    if ( selectStatus < 0 ) {
	if ( errno == EINTR ) goto again;
	fatalperr("%s: select",ME);
	/*NOTREACHED*/
    }
    if ( ! selectStatus ) {
	/* timed out */
	if ( ExitProc ) {
	    if ( !(*ExitProc)() ) {
		goto again;
	    }
	    else return( 0 );
	}
	else {
	    exit(0);
	}
    }
    

    /*
     * Figure out which one went off.
     */
    n = ffs(readfds);
    if ( n == 0 ) {
	fatalperr("%s: select returned no readables",ME);
	/*NOTREACHED*/
    }

    /*
     * Match it up with a binding.
     */
    readfds = n - 1;
    n = ( 1 << readfds);
    *fReady = (HRPCBinding *) NULL;
    for(fdix = 0; fdix < fNumBnd; fdix++ ) {
	i = fBndArr[fdix]->transDescr.sockfd;
	i = connStates[i].masterfd;
	if ( n & connStates[i].selmask ) {
	    int recv_fd, readCnt;
	    fBndArr[fdix]->transDescr.sockfd = readfds;
	    fBndArr[fdix]->transDescr.tmp_sockfd = -1;
	    *fReady = fBndArr[fdix];
	    if ( HRPC_lwpType != SingleThread ) {
		/* check to see if the packet we received (causing us to be
		 * awakened) was a control packet arriving on a master
		 * connection. */
	        packetInfo = fBndArr[fdix]->transDescr.arrivedPacketQ;
	        recv_fd = packetInfo->fd;
	        readCnt = packetInfo->BufSize;
	        if ( fBndArr[fdix]->transType == TCPTRANSP  &&
		        fBndArr[fdix]->connState != CONN_WREPLY  &&
		        connStates[recv_fd].masterfd == connStates[recv_fd].connfd
		        &&  readCnt <= CONN_CNTLPACK ) {
			/* grab necessary info from arrivedPacketQ */
		    fBndArr[fdix]->transDescr.replyTo = packetInfo->From;
		    fBndArr[fdix]->transDescr.tmp_sockfd =
				- (readCnt - CONN_CNTLPACK);
			/* remove first element on our arrivedPacketQ */
		    fBndArr[fdix]->transDescr.packetArrived--;
		    GetFromArrivedPacketQ(fBndArr[fdix],1);
	        }
	    }
	    break;
	}
    }
    if ( *fReady == (HRPCBinding *) NULL ) {
	if ( HRPC_lwpType != SingleThread ) {
		/* check to see if close connection.  if so, just skip it */
	    for(fdix = 0; fdix < fNumBnd; fdix++ ) {
		packetInfo = fBndArr[fdix]->transDescr.arrivedPacketQ;
		if ( packetInfo == (struct PacketQelement *) NULL ) continue;
		if ( packetInfo->BufSize <= 0 ) {
		        /* connection already closed */
		    fullmask &= ~(1<<packetInfo->fd);
		    fBndArr[fdix]->transDescr.packetArrived--;
		    GetFromArrivedPacketQ(fBndArr[fdix],1);
		    goto again;
		}
	    }
	}
	fatalerr("%s: fd %d matches no binding",ME,n);
	/*NOTREACHED*/
    }

    /*
     * Call transport specific initialization
     * routine.
     *
    XXX bad problem here -- how to account for mysterious
    appearance of new fds on connection-oriented sockets.
     * But for now we have "finessed" it -- what a crock!!
     */
    return( readfds );
}

HRPCSetRequestTMO( ftmval, fExitProc )
    struct timeval *ftmval;
    int (*fExitProc)();
{
    if ( ftmval ) {
	tmoset = 1;
	defaulttmo = *ftmval;
	ExitProc = fExitProc;
    }
    else tmoset = 0;
}
