/*
 * Definitions for TCPBIND VERSION 1 NUMBER 20191.
 */
#ifndef __TCPBIND
#define __TCPBIND
#include <HRPC/cCourierTypes.h>
#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>


/*
 * Definitions from DEPENDS UPON BIND_MsgStructs inclusion
 * (must be linked with BIND_MsgStructs_otw.c also)
 */

#include <HRPC/CIncludes/BIND_MsgStructs.h>

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_LookupNameInMsg Msg;
} TCPBIND_LookupNameInMsg;
extern int TCPBIND_LookupNameInMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_LookupNameOutMsg Msg;
} TCPBIND_LookupNameOutMsg;
extern int TCPBIND_LookupNameOutMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_AddRRInMsg Msg;
} TCPBIND_AddRRInMsg;
extern int TCPBIND_AddRRInMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_AddRROutMsg Msg;
} TCPBIND_AddRROutMsg;
extern int TCPBIND_AddRROutMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_DeleteRRInMsg Msg;
} TCPBIND_DeleteRRInMsg;
extern int TCPBIND_DeleteRRInMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_DeleteRROutMsg Msg;
} TCPBIND_DeleteRROutMsg;
extern int TCPBIND_DeleteRROutMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_ModifyInMsg Msg;
} TCPBIND_ModifyInMsg;
extern int TCPBIND_ModifyInMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_ModifyOutMsg Msg;
} TCPBIND_ModifyOutMsg;
extern int TCPBIND_ModifyOutMsgOtw();

typedef struct {
	Integer MsgByteCount;
	BIND_MsgStructs_LookupNameInMsg Msg;
} TCPBIND_ZoneXferInMsg;
extern int TCPBIND_ZoneXferInMsgOtw();

typedef struct {
	Integer ResponseCode;
} TCPBIND_ZoneXferOutMsg;
extern int TCPBIND_ZoneXferOutMsgOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * TCPBIND_LookupName();
#else
extern void TCPBIND_LookupName();
#endif
#define TCPBIND_LOOKUPNAME 1

#ifndef HRPC_SERVER
extern HRPCErrRec * TCPBIND_AddRR();
#else
extern void TCPBIND_AddRR();
#endif
#define TCPBIND_ADDRR 1

#ifndef HRPC_SERVER
extern HRPCErrRec * TCPBIND_DeleteRR();
#else
extern void TCPBIND_DeleteRR();
#endif
#define TCPBIND_DELETERR 1

#ifndef HRPC_SERVER
extern HRPCErrRec * TCPBIND_Modify();
#else
extern void TCPBIND_Modify();
#endif
#define TCPBIND_MODIFY 1

#ifndef HRPC_SERVER
extern HRPCErrRec * TCPBIND_ZoneXfer();
#else
extern void TCPBIND_ZoneXfer();
#endif
#define TCPBIND_ZONEXFER 1

#endif __TCPBIND


extern HRPCErrRec *TCPBIND_Export();
extern HRPCErrRec *TCPBIND_Import();
