/*
 * Definitions for HMS VERSION 1 NUMBER 3570.
 */
#ifndef __HMS
#define __HMS
#include <HRPC/cCourierTypes.h>
#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>


/*
 * Definitions from DEPENDS UPON Binding inclusion
 * (must be linked with Binding_otw.c also)
 */

#include <HRPC/CIncludes/Binding.h>

/*
 * Definitions from DEPENDS UPON HNS inclusion
 * (must be linked with HNS_otw.c also)
 */

#include <HRPC/CIncludes/HNS.h>
typedef String HMS_HMSUserName;
typedef String HMS_HMSUserPasswd;
typedef String HMS_HMSSteeringList;

static LongInteger HMS_HMS_numMailSystemTypes = {2};

typedef enum {
	UNIX_MS = 0,
	XEROX_MS = 1
} HMS_HMS_MailSystemTypes;

static LongInteger HMS_HMS_numNameServiceTypes = {2};

typedef enum {
	BIND_NS = 0,
	CH_NS = 1
} HMS_HMS_NameServiceTypes;

typedef struct {
	String hostName;
	Binding_BINDING_DESCR BindingDescr;
} HMS_HMS_MSMInfo;
extern int HMS_HMS_MSMInfoOtw();

typedef struct {
	Cardinal length;
	HMS_HMS_MSMInfo *sequence;
} HMS_HMS_MSMInfo_List;
extern int HMS_HMS_MSMInfo_ListOtw();

static LongInteger HMS_HMS_maxMailMessages = {250};

typedef struct {
	String subject;
	String from;
	String toList;
	String returnList;
	String ccList;
	String date;
	String otherList;
	String body;
} HMS_MailMessage;
extern int HMS_MailMessageOtw();

typedef enum {
	success = 0,
	badUserName = 1,
	badPassword = 2,
	badRange = 3,
	cantOpenMailFile = 4,
	cantOpenTempFile = 5,
	cantAccessMailFile = 6,
	cantAccessTempFile = 7,
	insufficientServerMemory = 8,
	notImplemented = 9,
	serverBug = 10,
	badRecipient = 11,
	cantFileMessage = 12,
	noRecipients = 13
} HMS_HMSStatus;
typedef LongInteger HMS_HRPCStatus;

#endif __HMS


extern HRPCErrRec *HMS_Export();
extern HRPCErrRec *HMS_Import();
