/* File: /u2/dtc/HRPC/binding/fill.c  Date:  7-Apr-1986  */

/*
 * $Header: fill.c,v 1.2 86/04/10 10:53:25 dtc Exp $
 * INTERFACE:	
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log:	fill.c,v $
 * Revision 1.3  86/06/16  11:00:53  oystr
 * General clean up as part of merge
 *
 * Revision 1.2  86/04/10  10:53:25  dtc
 * error conditions RETURN'ed rather than REPORT'ed
 * 
 * Revision 1.1  86/04/09  13:08:13  dtc
 * Initial revision
 * 
 *  7-Apr-1986:	Initial implementation, Dennis Ching
 */

#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>

extern void ResolveBinding();	/* the remote procedure call to the HCS BA,
				   made by clients only */

extern FillRawRPC();
extern FillRawOTW();
extern FillRawTCP();
extern FillRawUDP();

extern FillSunRPC();
extern FillSunOTW();
extern FillSunTCP();
extern FillSunUDP();

#ifdef sun
#define FillCourRPC abort
#define FillCourOTW abort
#define FillSPP_XPT abort
#else
extern FillCourRPC();
extern FillCourOTW();
extern FillSPP_XPT();
#endif

extern int abort();

static (* FillRPC[])() = {
    abort, FillSunRPC, FillCourRPC, FillRawRPC
};

static (* FillOTW[])() = {
    abort, FillSunOTW, FillCourOTW, FillRawOTW
};

static (* FillXPT[])() = {
    abort, FillSunTCP, FillSunUDP, FillSPP_XPT, FillRawTCP, FillRawUDP
};

extern HRPCErrRec *LocateBA();

HRPCErrRec *FillCntlBlks(fBptr, descr)
    HRPCBinding *       fBptr;
    BINDING_DESCR *        descr;
{
    HRPCBinding	tempBinding;
    BINDING_DESCR	descrOut;
    HRPCErrRec	*status;
    BINDING_DESCR  *finaldptr;
    Binding_STATUS_REC resStat;
    
    finaldptr = descr;
    if (descr->useBA) {
	if ( status = LocateBA(&tempBinding) ) { /* obtained by local magic */
	    return( status );
	}
        ResolveBinding(&tempBinding, descr, fBptr->ifdPtr,
			&descrOut, &resStat);
	if ( resStat.errCode != IMPORT_NORMAL ) {
	    status = NewHRPCErrRec( resStat.errCode, 0 );
	    return( status );
	}
	finaldptr = &descrOut;
    }

    fBptr->speaking = descr->data.designator;
    switch (descr->data.designator) {
	case SUN_XDR_UDP:
	    fBptr->bndProgNum =
		descr->data.SUN_XDR_UDP_case.progNum;
	    (*FillRPC[SUNRPC])(fBptr, &finaldptr->data.u);
	    (*FillOTW[SUNOTW])(fBptr, &finaldptr->data.u);
	    (*FillXPT[UDPTRANSP])(fBptr, &finaldptr->data.u);
	    break;

	case SUN_XDR_TCP:
	    fBptr->bndProgNum =
		descr->data.SUN_XDR_TCP_case.progNum;
	    (*FillRPC[SUNRPC])(fBptr, &finaldptr->data.u);
	    (*FillOTW[SUNOTW])(fBptr, &finaldptr->data.u);
	    (*FillXPT[TCPTRANSP])(fBptr, &finaldptr->data.u);
	    break;

	case COURIER_COURIER_SPP:
	    fBptr->bndProgNum =
		descr->data.COURIER_COURIER_SPP_case.progNum;
	    (*FillRPC[COURRPC])(fBptr, &finaldptr->data.u);
	    (*FillOTW[COUROTW])(fBptr, &finaldptr->data.u);
	    (*FillXPT[XNSTRANSP])(fBptr, &finaldptr->data.u);
	    break;

	case RAW_TCP:
	    fBptr->bndProgNum =
		descr->data.RAW_TCP_case.progNum;
	    (*FillRPC[RAWRPC])(fBptr, &finaldptr->data.u);
	    (*FillOTW[RAWOTW])(fBptr, &finaldptr->data.u);
	    (*FillXPT[RAWTCPTRANSP])(fBptr, &finaldptr->data.u);
	    break;

	case RAW_UDP:
	    fBptr->bndProgNum =
		descr->data.RAW_UDP_case.progNum;
	    (*FillRPC[RAWRPC])(fBptr, &finaldptr->data.u);
	    (*FillOTW[RAWOTW])(fBptr, &finaldptr->data.u);
	    (*FillXPT[RAWUDPTRANSP])(fBptr, &finaldptr->data.u);
	    break;

	default:
            fatalerr("Undefined SPEAK type:  %d.\n", descr->data.designator);
            break;
    }
    return( NOHRPCERR );
}
