/* File: /u1/oystr/HRPC/Binding/exportSun.c  Date: 26-Jun-1986  */

/*
 * $Header$
 * INTERFACE:	ExportSunServ
 *
 * FUNCTION:	Export a SUN RPC server to the (local) portmap
 *		server.
 *
 * IMPORTS:	basicRpc.h
 *
 * EXPORTS:	ExportSunServ
 *
 * DESIGN:	Why not?
 *
 * DEFECTS:	We only export to the local portmapper, but
 *		we have to drag in all the host database stuff.
 *		There should be some easier way to get the IP
 *		address of the local machine.  Note that gethostid(2)
 *		is NOT, in general, what you want.
 *
 *			>>>>> WARNING <<<<<
 *		Attempting to bind to a specific IP address
 *		fails miserably due to a bug(?) in the Unix
 *		kernel.  You must use INADDR_ANY.  If this
 *		ever changes, make some mods in the file
 *		callback.c[ConvBindingToBD].
 *
 *		The ExportProcs array should be stuffed into
 *		its own little module.
 * $Log$
 *
 * Revision 1.1  87/01/??  ??:??:?? mss
 * Changes for lightweight process support.
 *
 * 26-Jun-1986:	Initial implementation, Jan Sanislo
 */
#include <HRPC/CIncludes/Binding_defs.h>

#ifndef basicRpc
#include <HRPC/basicRpc.h>
#endif

#include <HRPC/hrpcErrCodes.h>

#include <netinet/in.h>
#include <netdb.h>
#include "../Transports/connDefs.h"
#include "../RpcProtos/courDbg.h"

/*
 * A couple of defines to ease the typing.
 */
#define BDescr Binding_SUN_XDR_UDP_BINDING_DESCR

/* Static IFD for *any* portmap server */
static InterfaceDescr pmapIfd = {
    100000, 2, (TBD) 0
};

/*
 * Static Binding template to *any* portmap server.
 */
static HRPCBinding templateBinding;
static HRPCBinding *templatebptr = &templateBinding;

/*
 * Static network address of *any* pmap.
 * Have to fill in the IP address part.
 */
static struct sockaddr_in pmapAddr;
    
/* Init flag */
static int initDone = 0;

extern HRPCErrRec * ExportSunServ();

/* Nasty hack... */
extern HRPCErrRec *abort();
#ifdef vax
extern HRPCErrRec *ExportCourierServ();
#endif

HRPCErrRec * (*ExportProcs[])() = {
    abort,
    ExportSunServ,
    ExportSunServ,
#ifdef sun
    abort
#endif
#ifdef vax
    ExportCourierServ
#endif vax
};

/*
 * Next two externs come from Binding/pmapIf.c.
 *
 * I will probably be very, very sorry for using UnsetPort, but
 * I can't think of a better way right now.  The problem
 * is that you cannot have multiple servers for the same
 * running on the interface running a single node. OTOH,
 * servers can die without informing the local portmapper,
 * making it difficult to boot a new one.  Therefore, the
 * SOP is to remove yourself before you declare yourself.
 * There are other ways to go about this such as: find out
 * if you are *supposed* to be here, then find out if you
 * are *actually* here by trying to bind to the port you
 * are reputedly at.  Unfortunately, so other joker could
 * have snarfed the port, so there would have to be higher
 * level, RPC-based protocol for identifying yourself.  Sigh...
 */
extern HRPCErrRec *SunPMap_SetPort();
extern HRPCErrRec *SunPMap_UnsetPort();

/*
 * This routine meets the generic export interface spec.
 */
static struct in_addr localAddr;

HRPCErrRec *
ExportSunServ( fIfdPtr, fSpkType, fName, fExpFlags,
	       fNExp, fSpare2, fBptr )
    InterfaceDescr *fIfdPtr;
    SpeakDefs_Speak fSpkType;
    String 	    fName;
    int		    *fExpFlags; /* IN/OUT */
    int		    *fNExp;
    LongUnspecified fSpare2;
    HRPCBinding     **fBptr;
{
    int proto;
    char thishost[50];
    char *ME = "ExportSunServ:";
    BDescr bdesc;
    int sockfd;  /* where we will be listening */
    struct sockaddr_in myAddr;
    struct hostent *hptr;
    Boolean mapResult;
    int addrSize;
    register HRPCBinding *newBptr;
    HRPCErrRec *pmErr;
    HRPCBinding pmapBinding;
    HRPCBinding *pmbptr = &pmapBinding;
    extern int          HRPC_LWPinitSocket();
    
    /*
     * Sigh..., get local host address.
     */
    if ( !localAddr.s_addr ) {
        if ( gethostname(thishost,sizeof(thishost)) ) {
	    fatalperr("%s can't get local hostname.\n",ME);
	}
	hptr = gethostbyname(thishost);
	if ( hptr == (struct hostent *) NULL ) {
	    fatalerr("%s can't get hostentry for %s.\n",ME,thishost);
	}
        bcopy(hptr->h_addr, &localAddr, sizeof(struct in_addr));
    }

    if ( fSpkType == SUN_XDR_UDP ) {
	proto = IPPROTO_UDP;
    }
    else
    if ( fSpkType == SUN_XDR_TCP ) {
	proto = IPPROTO_TCP;
    }
    else {
	fatalerr("%s unknown SpeakType - %d.\n", ME, (int) fSpkType);
    }

    mCourDbgMsg((courLogF,"%s expflags are %d.\n",ME,*fExpFlags));
    /* Check for auto-mode */
    if ( (*fExpFlags & EXPF_AUTOACT) ) {
	sockfd = FindExportSocket( AF_INET, proto, &myAddr,
			sizeof(struct sockaddr_in) );
	if ( sockfd > 0 ) {
	    *fExpFlags = EXPF_AUTOACT;
	    myAddr.sin_addr.s_addr = localAddr.s_addr;
mCourDbgMsg((courLogF,"%s found socket %d.\n",ME,sockfd));
	    goto Fill_In;
	}
	*fExpFlags &= ~EXPF_AUTOACT;
	*fNExp = 0;
mCourDbgMsg((courLogF,"%s can't find auto socket.\n"));
	return( NOHRPCERR );
    }
    
    /*
     * Initialize our fakey binding to a portmapper.
     */
    if ( !initDone ) {
	bdesc.portNum = (LongCardinal) htons(111);
	bcopy( &localAddr, bdesc.ipAddr, sizeof(struct in_addr) );
	bdesc.progNum = pmapIfd.progNum;
	templatebptr->ifdPtr = &pmapIfd;
	FillSunRPC( templatebptr, &bdesc );
	FillSunOTW( templatebptr, &bdesc );
	FillSunUDP( templatebptr, &bdesc );
	templatebptr->bndProgNum = pmapIfd.progNum;
	templatebptr->speaking = SUN_XDR_UDP;
	initDone = 1;
    }
	/* NOTE: FOLLOWING IS STRUCT ASSIGNMENT */
    *pmbptr = *templatebptr;

    if ( proto == IPPROTO_UDP ) {
	sockfd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    }
    else {
	sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    }

    if ( sockfd < 0 ) {
	fatalperr("%s can't create socket.\n",ME);
    }

    /*
     * Unset previous value... I will be beaten soundly about
     * the head and shoulders for doing this.
     */
    if ( (*fExpFlags & EXPF_UNBIND) ) {
	pmErr = SunPMap_UnsetPort( pmbptr, fIfdPtr->progNum,
		       (LongCardinal) fIfdPtr->versNum, addrSize, addrSize,
			&mapResult);
	if ( pmErr ) {
	    pmErr->errDetails = (char *) pmErr->hrpcErr;
	    pmErr->hrpcErr = IMPORT_BAFAILED;
	    goto tidy;
	}
    } 

    /*
     * Perform bind to get port number for export.
     * See WARNING statement under DEFECTS in file header.
     */
    myAddr.sin_addr.s_addr = INADDR_ANY;
    
    myAddr.sin_port = 0;
    if ( bind( sockfd, &myAddr, sizeof(struct sockaddr_in) ) < 0 ) {
	fatalperr("%s can't bind socket for protocol %d.\n",ME,proto);
    }
    /*
     * Have to call getsockname to retrieve port number
     */
    addrSize = sizeof(myAddr);
    if ( getsockname( sockfd, &myAddr, &addrSize ) < 0 ) {
	fatalperr("%s can't retrieve port number.\n",ME);
    }
    
    /*
     * Register ourselves if not doing callback.
     */
    if ( ! (*fExpFlags & EXPF_CALLBACK) ) {
	addrSize = (int) ntohs(myAddr.sin_port);
	pmErr = SunPMap_SetPort(pmbptr, fIfdPtr->progNum,
			(LongCardinal) fIfdPtr->versNum, proto,
		    	(LongCardinal) addrSize, &mapResult );
	if ( pmErr ) {
	    pmErr->errDetails = (char *) pmErr->hrpcErr;
	    pmErr->hrpcErr = IMPORT_BAFAILED;
	    goto tidy;
	}
        else
	if ( !mapResult ) {
	    errmsg("%s: call to portmapper failed.\n",ME);
	    pmErr = NewHRPCErrRec( EXPORT_BAFAILED, 0 );
	}
    }

tidy:
    (*pmbptr->rpcDescr.CloseRpc)(pmbptr);
    (*pmbptr->otwDescr.CloseOtw)(pmbptr);
    (*pmbptr->transDescr.CloseLink)(pmbptr);
    if ( pmErr ) {
	return( pmErr );
    }

    *fExpFlags = EXPF_PREACT;
    
    /*
     * if we get here, the assumption is that we are registered,
     * so fill up the result binding.
     */
Fill_In:
    bdesc.progNum = fIfdPtr->progNum;
    bdesc.portNum = (LongCardinal) myAddr.sin_port;
    bcopy( &myAddr.sin_addr, bdesc.ipAddr, sizeof(struct in_addr) );
    newBptr = (HRPCBinding *) calloc(1,sizeof(HRPCBinding));
    if ( newBptr == (HRPCBinding *) NULL ) {
	fatalerr("%s can't allocate new binding.\n",ME);
	/*NOTREACHED*/
    }
    newBptr->ifdPtr   = fIfdPtr;
    newBptr->speaking = fSpkType;
    newBptr->bndProgNum = fIfdPtr->progNum;

    FillSunRPC( newBptr, &bdesc );
    FillSunOTW( newBptr, &bdesc );
    if ( proto == IPPROTO_UDP ) {
	FillSunUDP( newBptr, &bdesc );
    }
    else {
	FillSunTCP( newBptr, &bdesc );
	/* set backlog */
	if ( (*fExpFlags & EXPF_PREACT)
	    /* listen done in FindExportSocket during auto */
	     && listen(sockfd, 5) < 0 ) {
	    fatalperr("%s: can't set TCP backlog of fd %d",sockfd,ME);
	    /*NOTREACHED*/
	}
    }

    /*
     * Arm it.
     */
    newBptr->transDescr.sockfd = sockfd;
    HRPC_LWPinitSocket(newBptr, sockfd, 1);
    *fBptr = newBptr;
    *fNExp  = 1;
    return( NOHRPCERR );
}
