/* File: /u2/dtc/HRPC/binding/eval.c  Date:  3-Apr-1986  */

/*
 * $Header: eval.c,v 1.3 86/04/10 10:53:19 dtc Exp $
 * INTERFACE:	fake HCS NS, a.k.a. GFNS
 *
 * FUNCTION:	given a fully qualified query specifying a server, return a
 *		binding descriptor(s) for each SPEAK protocol supported by it
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	yuck
 *
 * $Log:	eval.c,v $
 * Revision 1.5  87/10/16  16:40:52  oystr
 * Don't re-open fakeNS file every time.  Another little
 * timebomb from DTC.  I guess I should have spotted it
 * earlier, though.
 *
 * Revision 1.4  86/06/16  10:56:35  oystr
 * General clean up as part of merge.
 *
 * Revision 1.3  86/04/10  10:53:19  dtc
 * error conditions RETURN'ed rather than REPORT'ed
 * 
 * Revision 1.2  86/04/09  15:01:44  dtc
 * changes for handling the ARPANET entries with gethostbyname()
 * 
 *  3-Apr-1986:	Initial implementation, Dennis Ching
 */

#include <stdio.h>
#include <ctype.h>		/* for isupper() and tolower() macros */
#include <HRPC/basicRpc.h>
#define HRPC_SERVER
#include <HRPC/CIncludes/Binding_defs.h>
#include <netdb.h>
#if !(sun || ultrix)
#include <netns/ns.h>
#endif
#define MAXSTRLEN 80

typedef struct ll {
    struct ll *	next;
    BINDING_DESCR *data;
} LINKED_LIST;

static FILE *fp = NULL;

void EvalQuery(fBptr, query, list, status)
    HRPCBinding     *fBptr;
    EvalQueryInputs *query;
    BINDING_DESCR_LIST *list;
    Binding_STATUS_REC *status;
{
    char		typeName[MAXSTRLEN];
    char		dumpStr[MAXSTRLEN];
    char		instanceName[MAXSTRLEN];
    char *		lc();	/* returns a lower-case version of any
				   character string */
    SpeakDefs_Speak	speakType;
    char		nodeAddress[MAXSTRLEN];
    int			portNum;
    int			progNum;
    char		useBA[MAXSTRLEN];
    BINDING_DESCR *	descr;
    LINKED_LIST *	linkedList;
    BINDING_DESCR *	makeDescr();
    
    linkedList = (LINKED_LIST *) NULL;
    
    if ( fp != NULL ) {
	rewind(fp);
    }
    else
    if ((fp = fopen("/usr/new/lib/HRPC/fakeNS", "r")) == NULL) {
        status->errCode = IMPORT_NSFAILED;
	return;
    }
    while (TRUE) {
	if (fscanf(fp, "%s", typeName) == EOF) break;
	if (strcmp(typeName, query->Type) != 0) {
	    fgets(dumpStr, MAXSTRLEN, fp);
	    continue;
	}

	if (fscanf(fp, "%s", instanceName) == EOF) goto BadNS;
	if (strcmp(instanceName, lc(query->Instance)) != 0) {
	    fgets(dumpStr, MAXSTRLEN, fp);
	    continue;
	}
	
    	if (fscanf(fp, "%d", &speakType) == EOF) goto BadNS;
	switch (speakType) {
	    case SUN_XDR_TCP:
	    case SUN_XDR_UDP:
	        if (fscanf(fp, "%d%d", &portNum, &progNum) == EOF) goto BadNS;
		{
		SUN_XDR_UDP_BINDING_DESCR *	sxu;
		struct hostent *hp;
		
		hp = gethostbyname(query->Instance);
		if (hp == (struct hostent *) 0) {
		    status->errCode = IMPORT_BADHOST;
		    return;
		}
		descr = makeDescr(speakType);
		sxu = &descr->data.SUN_XDR_UDP_case;
		bcopy(hp->h_addr, sxu->ipAddr, hp->h_length);
		sxu->portNum = portNum;
		sxu->progNum = progNum;
	        }
	        addLink(&linkedList, descr);
		break;

#if !(sun || ultrix)		
	    case COURIER_COURIER_SPP:
		if (fscanf(fp, "%s%d%d",
			   nodeAddress, &portNum, &progNum) == EOF) goto BadNS;
		descr = makeDescr(speakType);
		{
		COURIER_COURIER_SPP_BINDING_DESCR *ccs;
		struct ns_addr *		ptr;
		extern struct ns_addr *		getXNSaddr();

		ccs = &descr->data.COURIER_COURIER_SPP_case;
		ptr = getXNSaddr(nodeAddress);
		bcopy(ptr, ccs->xnsAddr, sizeof(struct ns_addr));
		ccs->portNum = portNum;
		ccs->progNum = progNum;
		}
		addLink(&linkedList, descr);
		break;
#endif
	    case RAW_TCP:
	    case RAW_UDP:
	        if (fscanf(fp, "%d%d", &portNum, &progNum) == EOF) goto BadNS;
		{
		RAW_UDP_BINDING_DESCR *	sxu;
		struct hostent *hp;
		
		hp = gethostbyname(query->Instance);
		if (hp == (struct hostent *) 0) {
		    status->errCode = IMPORT_BADHOST;
		    return;
		}
		descr = makeDescr(speakType);
		sxu = &descr->data.RAW_UDP_case;
		bcopy(hp->h_addr, sxu->ipAddr, hp->h_length);
		sxu->portNum = portNum;
		sxu->progNum = progNum;
	        }
	        addLink(&linkedList, descr);
		break;
		
	    default:
	        fatalerr("evalQuery:  undefined SPEAK type.\n");
		break;
	} /* switch( speakType ) */

	if (fscanf(fp, "%s", useBA) == EOF) goto BadNS;
	if (strcmp(useBA, "false") == 0)
	    descr->useBA = FALSE;
	else if (strcmp(useBA, "true") == 0)
	    descr->useBA = TRUE;
	else
	    goto BadNS;
    }
    if (linkedList != (LINKED_LIST *) NULL)
	linearize(linkedList, list);
    else {
	list->length = 0;
	list->sequence = (BINDING_DESCR *) NULL;
	status->errCode = IMPORT_NOTREGIS;
	return;
    }
    status->errCode = IMPORT_NORMAL;
    return;
    
BadNS:
    fatalerr("invalid syntax in fake NS file.\n");
}    

BINDING_DESCR *
makeDescr(speakType)
    SpeakDefs_Speak	speakType;
{
    BINDING_DESCR *descr;
    
    descr = (BINDING_DESCR *) malloc(sizeof(BINDING_DESCR));
    descr->data.designator = speakType;
    return( descr );
}

addLink(head, descr)
    LINKED_LIST **	head;
    BINDING_DESCR *	descr;
{
    LINKED_LIST *	ptr;
    
    if (*head == NULL) {
	*head = (LINKED_LIST *) malloc(sizeof(LINKED_LIST));
	(*head)->next = (LINKED_LIST *) NULL;
	(*head)->data = descr;
    }
    else {
	ptr = *head;
	while ( ptr->next != NULL )
	    ptr = ptr->next;
	ptr = ptr->next = (LINKED_LIST *) malloc(sizeof(LINKED_LIST));
	ptr->next = NULL;
	ptr->data = descr;
    }
}

char *
lc(nam)
    register char *	nam;
{
    static char		lowname[128];
    register char *	lp = lowname;
	
    while (*nam)
	if (isupper(*nam))
	    *lp++ = tolower(*nam++);
	else
	    *lp++ = *nam++;
    *lp = '\0';
    return lowname;
}

#ifdef DEBRIS
SplitUp(a, b, c)
    char *	a;
    char *	b;
    char *	c;
{
    while (*a != '\0' && *a != '.') {
	*b++ = *a++;
    }
    *b = '\0';
    if (*a++ == '\0') return;	/* badly formed entry in fake NS */
    strcpy(c, a);
}
#endif

linearize(ll, l)
    register LINKED_LIST *	ll;
    BINDING_DESCR_LIST *	l;
{
    int			count;
    LINKED_LIST *	head;
    BINDING_DESCR *	descr;
    register LINKED_LIST *oll;
    
    head = ll;
    count = 1;
    while (ll->next != (LINKED_LIST *) NULL) {
	count++;
	ll = ll->next;
    }

    l->length = count;
    descr = l->sequence = (BINDING_DESCR *) calloc ( count, sizeof(BINDING_DESCR) );
    
    ll = head;
    while (count-- > 0) {
	bcopy(ll->data, descr, sizeof(BINDING_DESCR));
	/* belt & suspenders regarding free */
	oll = ll;
	ll = ll->next;
	free( oll );
	descr++;
    }
}
