/* File: /u2/dtc/HRPC/binding/choose.c  Date:  5-Apr-1986  */

/*
 * $Header: choose.c,v 1.3 86/04/10 10:53:03 dtc Exp $
 * INTERFACE:	
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log:	choose.c,v $
 * Revision 1.5  87/03/09  14:23:22  schwartz
 * Added RChooseServer, to help distribute load among multiple servers.
 *
 * Revision 1.4  86/06/16  10:37:25  oystr
 * General clean up as part of merge.
 *
 * Revision 1.3  86/04/10  10:53:03  dtc
 * error conditions RETURN'ed rather than REPORT'ed
 * 
 * Revision 1.2  86/04/09  15:13:13  dtc
 * movement of configuration commands to fill.c
 * 
 *  5-Apr-1986:	Initial implementation, Dennis Ching
 */

#include <stdio.h>
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>
#include <sys/time.h>

HRPCErrRec *ChooseServer( fBptr, list )
    HRPCBinding *	fBptr;
    BINDING_DESCR_LIST *	list;
{
    BINDING_DESCR *	descr;
    int			count;
    HRPCErrRec		*status;
    HRPCErrRec		*FillCntlBlks();

    for (descr = list->sequence, count = list->length;
         count-- > 0;
	 descr++) {
#ifdef DEBUG
	errmsg("ChooseServer:  trying a binding descriptor...\n");
#endif
	if ((status = FillCntlBlks(fBptr, descr)) == NOHRPCERR) {
	    break;
	}
	else if (status->hrpcErr != IMPORT_NOTREGIS) {
	    break;		/* the only reason we accept for continuing
	    			   is that the server was not registered with
				   the (remote) BA */
	}
        else {
#ifdef DEBUG
	    errmsg("Got a \"not-registered-with-BA\" response...\n");
#endif
	    free(status);
	}
    }
    return( status );
}

/*
 * RChooseServer is just like ChooseServer, except it starts from a
 * pseudo-randomly choosen initial BINDING_DESCR in the list, and circles
 * around.  This is intended to help distribute load among multiple servers.
 */
HRPCErrRec *RChooseServer( fBptr, list )
    HRPCBinding *	fBptr;
    BINDING_DESCR_LIST *	list;
{
    BINDING_DESCR *	descr;
    int			i, count, RandomStart, ListLength;
    HRPCErrRec		*status;
    HRPCErrRec		*FillCntlBlks();
    struct		timezone tz;
    struct		timeval TheTime;

    ListLength = list->length;
    gettimeofday(&TheTime, &tz);
    RandomStart = TheTime.tv_sec % ListLength;	/* pseudo-random number between
						   0 and ListLength - 1 */
    for (i = RandomStart, count = ListLength; count > 0; i++, count--) {
	descr = &list->sequence[i % ListLength];
#ifdef DEBUG
	errmsg("RChooseServer:  trying a binding descriptor...\n");
#endif
	if ((status = FillCntlBlks(fBptr, descr)) == NOHRPCERR) {
	    break;
	}
	else if (status->hrpcErr != IMPORT_NOTREGIS) {
	    break;		/* the only reason we accept for continuing
	    			   is that the server was not registered with
				   the (remote) BA */
	}
        else {
#ifdef DEBUG
	    errmsg("Got a \"not-registered-with-BA\" response...\n");
#endif
	    free(status);
	}
    }
    return( status );
}

#include <netinet/in.h>

/* Defect: only knows about TCP/UDP sockets */
PrintBptrAddr(fBptr)
HRPCBinding *fBptr;
{
	TransControl *tcptr = &fBptr->transDescr;
	struct sockaddr_in *sockAddr = (struct sockaddr_in *) &tcptr->netAddr;

	printf("fBptr address: %s, port %d\n", inet_ntoa(sockAddr->sin_addr),
		ntohs(sockAddr->sin_port));
	fflush(stdout);
}
