/* File: /u1/oystr/HRPC/Binding/callback.c  Date:  8-Jul-1986  */

/*
 * $Header$
 * INTERFACE:	
 *
 * FUNCTION:	Implements the primitives initially motivated by callback
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * DEFECTS:	We have to supply our local IP address, since get
 *		getsockname always returns 0.  The reasons for this
 *		are obscure, but apparently has to do with the fact
 *		that a machine can have multiple IP addresses and
 *		we don't know which one will be used until some
 *		party actually tries to talk to us.  Trying to
 *		explicitly bind to a single IP address fails
 *		miserably -- see exportSun.c for details.
 *
 * $Log$
 *  8-Jul-1986:	Initial implementation, Dennis T. Ching
 *
 *  1-Aug-1986: oystr
 *      Put into ONF and added ConvBindingToBD.
 */

#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>
#include <net/if.h>
#include <netinet/in.h>
#include "../HRpcRTS/sysSpecific.h"

#ifdef HAS_XNS43
#include <netns/ns.h>
#else
#define sockaddr_ns sockaddr_in
#define sns_family sin_family
#define sns_addr sin_addr
#define sns_port sin_port
#endif

#include <sys/ioctl.h>

ConvBDtoBinding( fBindDescr, fBptr )
    BINDING_DESCR  *fBindDescr;
    HRPCBinding **fBptr;
{
    register HRPCBinding *bptr;
    HRPCErrRec	*FillCntlBlks();
    char *ME = "ConvBDtoBinding";
    LongCardinal lc;
    
    bptr = (HRPCBinding *) calloc(1, sizeof(HRPCBinding) );
    if ( bptr == (HRPCBinding *) NULL ) {
	fatalerr("%s: can't alloc binding.\n",ME);
    }
    
    bptr->ifdPtr = (InterfaceDescr *) calloc(1, sizeof( InterfaceDescr ));
    if ( bptr->ifdPtr == (InterfaceDescr *) NULL ) {
	fatalerr("%s: can't alloc interface.\n",ME);
    }

    /*
     * put port # back the way it should be.
     */
    switch ( fBindDescr->data.designator ) {
	case SUN_XDR_UDP:
	case SUN_XDR_TCP:
	    lc = fBindDescr->data.SUN_XDR_UDP_case.portNum;
	    lc = (LongCardinal) htons( (u_short) lc );
	    fBindDescr->data.SUN_XDR_UDP_case.portNum = lc;
	    break;

	case COURIER_COURIER_SPP:
	    lc = fBindDescr->data.COURIER_COURIER_SPP_case.portNum;
	    lc = (LongCardinal) htons( (u_short) lc );
	    fBindDescr->data.COURIER_COURIER_SPP_case.portNum = lc;
	    break;
    }

    if ( FillCntlBlks(bptr, fBindDescr) )
	*fBptr = (HRPCBinding *) NULL;
    else
	*fBptr = bptr;
}

static struct sockaddr_in localIP;
static struct sockaddr_ns localNS;

ConvBindingToBD( fBptr, fBDesc )
    HRPCBinding *fBptr;
    BINDING_DESCR  *fBDesc;
{
    register SUN_XDR_UDP_BINDING_DESCR *sptr;
    register COURIER_COURIER_SPP_BINDING_DESCR *cptr;
    struct sockaddr_in *inptr;
    struct sockaddr_ns *nsptr;
    struct sockaddr sock;
    int j = sizeof(struct sockaddr);
    char *ME = "ConvBindingToBD";

    fBDesc->useBA = FALSE;
    fBDesc->data.designator = fBptr->speaking;
    if ( getsockname(fBptr->transDescr.sockfd, &sock, &j) ) {
	fatalperr("%s: getsockname on fd %d.\n",ME,
		  fBptr->transDescr.sockfd);
        /*NOTREACHED*/
    }

    if ( localIP.sin_family == 0 ) {
	GetIFInfo(fBptr->transDescr.sockfd);
    }

    switch ( fBptr->speaking ) {

	case SUN_XDR_UDP:
	case SUN_XDR_TCP:
	    /* Handle both of these together */
	    sptr = &(fBDesc->data.SUN_XDR_UDP_case);
	    inptr = (struct sockaddr_in *) &sock;
	    if ( inptr->sin_family != AF_INET ) {
		fatalerr("%s: socket/speak mismatch (AF_INET).\n",ME);
		/*NOTREACHED*/
	    }
	    sptr->progNum = fBptr->bndProgNum;
	    /* Must be network order */
	    sptr->portNum = (LongCardinal) ntohs(inptr->sin_port);
	    bcopy(&localIP.sin_addr.s_addr, sptr->ipAddr, 4);
	    break;

	case COURIER_COURIER_SPP:
	    cptr = &(fBDesc->data.COURIER_COURIER_SPP_case);
	    nsptr = (struct sockaddr_ns *) &sock;
	    if ( nsptr->sns_family != AF_NS ) {
		fatalerr("%s: socket/speak mismatch (AF_NS).\n",ME);
		/*NOTREACHED*/
	    }
	    cptr->progNum = fBptr->bndProgNum;
	    cptr->portNum = (LongCardinal) ntohs(nsptr->sns_port);
	    bcopy(&localNS.sns_addr, cptr->xnsAddr, 10);
	    break;

	default:
	    fatalerr("%s: can't handle speak type %d.\n",
		     ME, (int) fBptr->speaking);
	    /*NOTREACHED*/
    } /* switch */
}

GetIFInfo( fSock )
    int fSock;
{
    char buf[1024];
    struct ifconf ifc;
    struct ifreq  *ifrptr;
    int n;
    
    ifc.ifc_len = 1024;
    ifc.ifc_buf = buf;

    if ( ioctl( fSock, SIOCGIFCONF, (char *)&ifc ) < 0 ) {
	fatalperr("GetIFInfo ioctl.\n");
    }
    ifrptr = ifc.ifc_req;
    for( n = ifc.ifc_len / sizeof(struct ifreq); n > 0; n--, ifrptr++) {
	if ( (localIP.sin_family == 0) &&
	    (ifrptr->ifr_addr.sa_family == AF_INET) ) {
	    localIP = *(struct sockaddr_in *)&ifrptr->ifr_addr;
	}
	else
	if ( (localNS.sns_family == 0) &&
	    (ifrptr->ifr_addr.sa_family == AF_NS) ) {
	    localNS = *(struct sockaddr_ns *)&ifrptr->ifr_addr;
	}
    }
}
