/****************************************************************
 * 28-Jun-1986 oystr
 *   Put in setre[gu]id after binding to Courier port.
 *
 * 20-Mar-1987 oystr
 *   Added actPrefs stuff.
 ****************************************************************/

#include <stdio.h>		/* for lots of things */
#include <errno.h>		/* for EINTR */
#include <signal.h>		/* for signal() */
#include <sys/wait.h>		/* for struct wait and WNOHANG */
#include <sgtty.h>
#include <sys/types.h>		/* for lots of things, e.g. xn.h */
#include <sys/socket.h>		/* for SOCK_STREAM, AF_NS, etc. */
#include <netns/ns.h>		/* for sockaddr_ns, etc. */
#include <netns/sp.h> 
#include <xnscourier/courier.h>	/* for lots of things */
#include <xnscourier/realcourierconnection.h> /* for CourierConnection */
#include <pwd.h>
#include <sys/file.h>
#include <sys/stat.h>

/*
 * HRPC Activation info
 */
#include "actdb.h"
typedef struct {
    ActInfo *actent;
    struct Program *next;
    int notGarbage;
    /*
     * following fields used only "alwaysup" daemons
     */
    int bootTime;
    int numBoots;
    int daemonpid;
} Program;

Program actList;

/*
 * Logging info
 */
char *logfile = "/usr/adm/xnsd.log";
FILE *lf = NULL;
int dolog = 0;
#define LogMsg(x) if ( dolog ) fprintf x

/*
 * Miscellaneous
 */
struct sockaddr_ns here, dest;
int CourierServerDebuggingFlag = 0;
int forkuid, forkgid;

/*
 * Message stream handle.
 */
CourierConnection *_serverConnection = 0;
Unspecified tid;				/* transaction ID */

/*
 * The following procedures are all related
 * the HRPC pre-activation support.
 */

PrintActEnt(actptr)
    ActInfo *actptr;
{
    LogMsg((lf,"pn: %d, proto: %x, pref: %d,\n  exe: %s\n",
	actptr->progNum,actptr->protos,actptr->actPref,
	actptr->exeFile));
}

PrintProgList( title, pptr )
    char *title;
    Program *pptr;
{
    LogMsg((lf,"Prog list: %s.\n",title));
    if ( !pptr ) {
	LogMsg((lf,"***NULL***\n"));
	return;
    }
    while ( pptr ) {
	LogMsg((lf,"NotG: %d, ",pptr->notGarbage));
	PrintActEnt( pptr->actent );
	pptr = (Program *) pptr->next;
    }
}

static void
ChildHandler()
{
    int pid;
    union wait status;
    register Program   *pptr;

    while( (pid = wait3(&status,WNOHANG,0)) > 0 ) {
	LogMsg((lf,"Reaped child %d.\n",pid));
	/*
	 * Look through pid list for pid match.
	 */
	pptr = (Program *) actList.next;
	while ( pptr ) {
	    if ( pptr->daemonpid == pid ) {
		break;
	    }
	    else pptr = (Program *) pptr->next;
	}
	if ( pptr == NULL ) {
	    LogMsg((lf,"...Not a daemon.\n"));
	    continue /* while ( wait() ) */;
	}

	/*
	 * Minimum 5 minute lifetime.
	 */
	if ( ( (time(0) - pptr->bootTime) / pptr->numBoots ) < 300 )
	    continue /* while ( wait() ) */;

	pptr->daemonpid = ForkServer( pptr->actent, -1 );
	pptr->numBoots++;
    }
}

/*
 * Toggle logging on SIGHUP.
 */
int ToggleLog()
{
    int junk;
    
    junk = time(0);
    if ( dolog ) {
	if ( lf != NULL ) {
	    LogMsg((lf,">>Logging terminated by signal at %s",ctime(&junk)));
	    fclose(lf);
	    lf = NULL;
	}
	dolog = 0;
	return;
    }
    lf = fopen(logfile,"a");
    if ( lf == NULL ) return;
    setbuf(lf,NULL);
    fseek(lf,0L,2);
    dolog = 1;
    LogMsg((lf,">>Logging (re)started by signal at %s", ctime(&junk)));
}

int ForkServer( fActPtr, fSfd )
    ActInfo *fActPtr;
    int     fSfd;
{
    char *largv[MAXARGV+2];
    int su, sg, child;
    struct stat stbuf;

    /* Fork child process */
    sigblock(1<<SIGCHLD);
    if ( (child = vfork()) == 0 ) {
	/* 
	 * I'm a little hack job...
	 * close stdout, stderr and everything < sfd.
	 * Then open any logfiles.
	 */
	su = (fSfd > 0) ? fSfd : 8;
	for ( sg = 1; sg < su; sg++ ) {
	    close(sg);
	}
	su = 32767;
	sg = 9999;
	if ( (fActPtr->suid > 4)
	     && (stat(fActPtr->exeFile, &stbuf) >= 0) ) {
	    /*
	     * exe must be suid to owner. We check *every* time.
	     */
	    if ( (stbuf.st_uid == fActPtr->suid)
		  && (stbuf.st_mode & S_ISUID) ) {
		su = fActPtr->suid;
		sg = fActPtr->sgid;
	    }
	}

	setreuid(su,su);
	setregid(sg,sg);
	/*###
	 * Open log file -- count on setre[sg]uid
	 * to enforce access restrictions.
	 *###
	 */
	su = open( (fActPtr->logFile) ? fActPtr->logFile : "/dev/null",
		   O_WRONLY|O_CREAT|O_APPEND, 0664);
	if (su < 0) {
	    su = open("/dev/null",O_WRONLY|O_APPEND,0);
	}
	if ( su != 1 ) {
	    dup2(su,1);
	    close(su);
	}

        if ( fActPtr->errFile == NULL ) {
	    dup2(1,2);
	}
	else {
	    su = open( fActPtr->errFile, O_WRONLY|O_CREAT|O_APPEND, 0664 );
	    if ( su < 0 ) {
		su = open("/dev/null",O_WRONLY|O_APPEND,0);
	    }
	    if ( su != 2 ) {
		dup2(su,2);
		close(su);
	    }
	}

	if ( chdir( fActPtr->chdir ? fActPtr->chdir : "/tmp" ) < 0 ){
	    chdir("/tmp");
	}

	/*
	 * Dup new socket on fd 3.
	 */
	if ( fSfd > 0 ) {
	    dup2(fSfd,3);
	    close(fSfd);
	}
	largv[0] = fActPtr->exeFile;
	bcopy(fActPtr->exeArgs,&largv[1], sizeof(char *) * MAXARGV+1);
	execv(fActPtr->exeFile, largv);
	_exit(1);
    }
    sigsetmask(0);
LogMsg((lf,"Forked prog %d, pid: %d @ %d\n",fActPtr->progNum,child,time(0)));
    return( child );
}

/*
 * Act database has changed, so reload the information.
 */
int ReloadActDB()
{
    register ActInfo *actp1;
    register Program *pptr1, *trailer;
    Program *pptr2;

    LogMsg((lf,"Reloading...\n"));
    CloseActDB();
    if ( OpenActDB( (char *) 0 ) < 0 ) return;

    while ( actp1 = GetActDBEnt() ) {
	PrintActEnt( actp1 );
	
	if ( !(actp1->protos & COURCOURSPP)
	    || (actp1->actPref == AUTO_ACT) ) continue;
	pptr1 = (Program *) actList.next;
	pptr2 = &actList;

	while ( pptr1 ) {
	    if ( pptr1->actent->progNum == actp1->progNum ) {
		FreeActDBEnt( pptr1->actent );
		pptr1->actent = actp1;
		pptr1->notGarbage = 1;
		break;
	    }
	    pptr1 = (Program *) pptr1->next;
	}
	if ( !pptr1 ) {
	    pptr1 = (Program *) calloc(1,sizeof(Program));
	    /*###
	     * if doing alwaysups, must fork process
	     *###
	     */
	    pptr1->actent = actp1;
	    pptr1->notGarbage = 1;
	    pptr1->next = (struct Program *) pptr2->next;
	    pptr2->next = (struct Program *) pptr1;
	}
    } /* while ( GetActDBEnt() ) */

    PrintProgList("BG Act List",actList.next);

    /*
     * Throw out the trash.
     */
    trailer = &actList;
    pptr1 = (Program *) actList.next;
    while ( pptr1 ) {
	if ( pptr1->notGarbage ) {
	    pptr1->notGarbage = 0;
	    trailer = pptr1;
	    pptr1 = (Program *) pptr1->next;
	    continue;
	}
	trailer->next = pptr1->next;
	FreeActDBEnt( pptr1->actent );
	free( pptr1 );
	pptr1 = (Program *) trailer->next;
    }
    PrintProgList("Act List",actList.next);

    /*
     * Now do daemons.  If a new one has arrived, fork it.
     * If it is now garbage, we do not kill it since this
     * would allow whoever edited the actPrefs file to kill
     * arbitrary daemons.  We do not keep track of whether
     * things "change" (except for presence or absence),
     * so to reboot a daemon you must edit the file and then
     * kill the daemon yourself.  ==> need a call to modified
     * in child handler.  Note that there is a race condition
     * in that the new daemon may will not have time to register
     * itself if the call that forced us to reload was an
     * inquiry for that daemon.
     */
    LogMsg((lf,"Starting daemons...\n"));
    trailer = &actList;
    pptr1 = (Program *) actList.next;
    while ( pptr1 ) {
	if ( pptr1->notGarbage ) {
	    pptr1->notGarbage = 0;
	    if ( (pptr1->actent->actPref == ALWAYS_ACT)
		 && (pptr1->daemonpid == 0 ) ) {
		LogMsg((lf,"Daemon is...\n"));
		PrintActEnt(pptr1->actent);
		pptr1->daemonpid = ForkServer(pptr1->actent, -1);
		LogMsg((lf,"Pid is %d.\n",pptr1->daemonpid));
		pptr1->bootTime = time(0);
		pptr1->numBoots++;
	    }
	    trailer = pptr1;
	    pptr1 = (Program *) pptr1->next;
	    continue;
	}
	trailer->next = pptr1->next;
	FreeActDBEnt( pptr1->actent );
	free( pptr1 );
	pptr1 = (Program *) trailer->next;
    }
}

/*
 * Main server routine, much hacked.
 */

main(argc, argv)
    int argc;
    char *argv[];
{
    int s, pid, accfails;
    extern int errno;
    struct passwd *pwptr;
    ActInfo *actptr;
    Program *pptr;

    here.sns_family = AF_NS;
    here.sns_addr.x_port = htons(IDPPORT_COURIER);

#ifndef DEBUG
    if (fork())
	exit(0);
    for (s = 0; s < 10; s++)
	(void) close(s);
    (void) open("/", 0);
    (void) dup2(0, 1);
    (void) dup2(0, 2);
    s = open("/dev/tty", 2);
    if (s > 0) {
	ioctl(s, TIOCNOTTY, 0);
	close(s);
    }
#endif
    if ( dolog ) {
	lf = fopen(logfile,"w");
	if ( lf == NULL ) exit(3);
	setbuf(lf,NULL) /* no buffering */;
    }
    signal(SIGHUP,ToggleLog);

reopen:
    while ((s = socket(AF_NS, SOCK_SEQPACKET, 0)) < 0) {
	perror("xnscourierd: socket");
	sleep(5);
    }
    while (bind(s, &here, sizeof here) < 0) {
	perror("xnscourierd: bind");
	sleep(5);
    }

    pwptr = getpwnam("nobody");
    if ( pwptr == (struct passwd *) 0 ) {
	forkuid = 32767;
	forkgid = 9999;
    }
    else {
	/* Can't set here since may have to do reopen */
	forkuid = pwptr->pw_uid;
	forkgid = pwptr->pw_gid;
    }

    signal(SIGCHLD, ChildHandler);
    listen(s, 10);
    accfails = time(0);
    LogMsg((lf,">>Log reinitialized by %d at %s",getpid(), ctime(&accfails)));
    accfails = 0;
#ifdef SOCKDBG
    if (setsockopt(s,SOL_SOCKET,SO_DEBUG, &accfails, sizeof(accfails))<0){
	LogMsg((lf,"Can't initialize SO_DEBUG\n"));
    }
#endif

    /*
     * Load activation database.
     */
    if ( OpenActDB( (char *) 0 ) >= 0 ) {
	while( actptr = GetActDBEnt() ) {
	    if ( (actptr->protos & (COURCOURSPP))
		  && (actptr->actPref != AUTO_ACT) ) {
		PrintActEnt( actptr );
		pptr = (Program *) calloc(1,sizeof(Program));
		pptr->actent = actptr;
		/*
		 * All our guys go on the actList,
		 * since the only things were are interested
		 * in are pre-activated.
		 */
		pptr->next = (struct Program *) actList.next;
		actList.next = (struct Program *) pptr;
	    }
	    else {
		FreeActDBEnt( actptr );
	    }
	}
    }
    PrintProgList("Pre List",actList.next);

    /*
     * None of our alwaysup are going to talk to us,
     * so fork them all off at once.
     */
    pptr = (Program *) actList.next;
    while ( pptr ) {
	if ( pptr->actent->actPref == ALWAYS_ACT ) {
	    pptr->daemonpid = ForkServer( pptr->actent, -1 );
	    pptr->bootTime = time(0);
	    pptr->numBoots++;
	}
	pptr = (Program *) pptr->next;
    }

    for (;;) {
	struct sockaddr_ns from;
	int s2, fromlen = sizeof(from);

	s2 = accept(s, (caddr_t)&from, &fromlen);
	LogMsg((lf,"Accepted %d from %d\n",s2,s));

	/*
	 * Check if ActDB has changed.  If yes,
	 * reload data and fork any new daemons.
	 */
	if ( ActDBModified() ) {
	    ReloadActDB();
	}
	if (s2 < 0) {
	    LogMsg((lf,"**Accept errno = %d.\n",errno));
	    if ( accfails > 10 ) {
		accfails = time(0);
		LogMsg((lf,"**Exiting at %s",ctime(&accfails)));
		exit( 1 );
	    }
	    accfails++;
	    if (errno == EINTR)
		continue;
	    if ( (errno == ECONNABORTED) || (errno == ECONNREFUSED) ) {
		close( s );
		sleep( 5 );
		LogMsg((lf,"Got errno %d, trying reopen.\n",errno));
		goto reopen;
	    }
	    perror("xnscourierd: accept");
	    sleep(1);
	    continue;
	}
	accfails = 0;
#ifndef DEBUGDBX
	if ((pid = fork()) < 0) {
	    perror("xnscourierd: Out of processes");
	    LogMsg((lf,"**Out of processes: %d.\n",errno));
	    sleep(5);
	}
	else
	if (pid == 0) {
	    /* child */
	    signal(SIGCHLD, SIG_DFL);
	    close(s);	/* don't keep accepting */
	    /*
	     * Get down to half-safe uid/gid
	     */
	    setregid(forkgid,forkgid);
	    setreuid(forkuid,forkuid);
	    doit(s2, &from);
	    /*NOTREACHED*/
	}
	LogMsg((lf,"Forked child %d.\n",pid));
#else
	signal(SIGCHLD, SIG_DFL);
	doit(s2, &from);
#endif
	LogMsg((lf,"Closing %d.\n",s2));
	close(s2);
    }
    /*NOTREACHED*/
}

/*
 * f is the socket on which we have gotten an SPP connection.
 * who is the sockaddr_ns for the other end.  Modified for
 * HRPC pre-activation.
 */
static CourierConnection connblock;

doit(f, who)
    int f;
    struct sockaddr_ns *who;
{
    LongCardinal programnum;
    Cardinal versionnum;
    int skipcount;
    Unspecified skippedwords[8];
    Unspecified *bp;
    static Cardinal ourversion = COURIERVERSION;
    int acttype;
    char junk[80];
    Program *pptr;
	
    /*
     * set up the CourierConnection data
     */
    _serverConnection = &connblock;
    _serverConnection->fd = f;
    _serverConnection->state = wantversion;
    _serverConnection->bdtstate = wantdata;

    /*
     * send our version number
     */
    bp = skippedwords;
    bp += externalize_Cardinal(&ourversion, bp);
    bp += externalize_Cardinal(&ourversion, bp);
    CourierWrite(_serverConnection, (bp-skippedwords), skippedwords,
		 0, (Unspecified*) NULL);

    /*
     * read and process a connection message
     */
    for (;;) {
	skipcount = LookAheadCallMsg(&programnum, &versionnum, skippedwords);
	if (skipcount < 0) fatal("connection timed out");

LogMsg((lf,"Request for %d/%d. Skip=%d\n",programnum, versionnum, skipcount));

	/*
	 * Find out of this is a preactivated program.
	 */
	pptr = (Program *) actList.next;
	while ( pptr ) {
	    if ( pptr->actent->progNum == programnum ) {
		break;
	    }
	    else pptr = (Program *) pptr->next;
	}
	if ( pptr ) {
	    LogMsg((lf,"  ...PREACTIVATED...\n"));
	    PrintActEnt( pptr->actent );
	    if ( !HandOffDescr( f, programnum, versionnum ) ) {
		LogMsg((lf,"  Descriptor handed off.\n"));
		close(f);
		_exit(0);
	    }
	    LogMsg((lf,"  Descriptor handoff failed.\n"));
	}
	ExecCourierProgram(programnum, versionnum, skipcount,
			   skippedwords);
    }
}

/*
 * Mighty hacks start here...
 */
#include <sys/un.h>
#include <sys/uio.h>
char *courSockName = "/tmp/xnscourierd";

int HandOffDescr( fConn, fProgN, fVersN )
    int fConn;
    LongCardinal fProgN;
    Cardinal fVersN;
{
    int courfd;
    struct sockaddr_un myUnAddr;
    struct sockaddr_un itsUnAddr;
    int addrLen;
    struct msghdr msg;
    struct iovec  numbersvec;
    int numbers[5];
    char socknamebuf[30];
    int i,j,k;

    /*
     * create a little socket for ourselves.  This
     * should be done only once, but we will dink
     * with that later.
     */
    if ( (courfd = socket(AF_UNIX,SOCK_DGRAM,0)) < 0 ) {
	LogMsg((lf,"Can't make AF_UNIX socket: %d.\n",errno));
	return( -1 );
    }
    myUnAddr.sun_family = AF_UNIX;
    strcpy(myUnAddr.sun_path,courSockName);
    if ( bind(courfd, &myUnAddr, 2+strlen(courSockName)) < 0 ) {
	LogMsg((lf,"Can't bind AF_UNIX socket: %d.\n",errno));
	return( -1 );
    }

    /*
     * Construct the message (prog #, vers #, new socket)
     */
    numbers[0] = (int) fProgN;
    numbers[1] = (int) fVersN;
    numbersvec.iov_base = (char *) numbers;
    numbersvec.iov_len  = 2 * sizeof(int);
    msg.msg_iov = &numbersvec;
    msg.msg_iovlen = 1;
    msg.msg_accrights = (char *)&fConn;
    msg.msg_accrightslen = sizeof(fConn);

    /*
     * Construct address.
     */
    itsUnAddr.sun_family = AF_UNIX;
    sprintf(socknamebuf,"/tmp/%d.%d",fProgN,fVersN);
    strcpy(itsUnAddr.sun_path,socknamebuf);
    msg.msg_name = (char *)&itsUnAddr;
    msg.msg_namelen = 2+strlen(socknamebuf);
    LogMsg((lf,"Sending connection to %s.\n",socknamebuf));
    j = sendmsg(courfd, &msg, 0);
    if ( j < 0 ) {
	LogMsg((lf,"Sendmsg failed: %d.\n",errno));
    }

    close(courfd);
    unlink(courSockName);
    return( (j > 0) ? 0 : j );
}


fatal(msg)
    char *msg;
{
    (void) fprintf(stderr, "xnscourierd: %s.\n", msg);
    LogMsg((lf,"xnscourierd (fatal): %s.\n",msg));
    exit(1);
}
