#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pwd.h>
#include "actdb.h"

static char *actdbDefault = "~oystr/HRPC/Binding/Activation/actPrefs";
static char actdbFile[100];

static FILE *actf = NULL;

/* "forward" */
extern char *TildeExpand();
extern char *ActStrDup();
extern char *ActItem();
extern char *ActNextLine();
extern char *ActSubStr();
extern char *ActNonBlank();

/*
 * This routine is specific to binding agents.  Not
 * for general use.  Avoids overhead of allocating
 * all that space.
 */

int GetActPrefs( fProgN, fStayOpen, fProto, fExeName )
    long fProgN;
    int  fStayOpen;
    char *fProto;
    char *fExeName;
{
    long lpn;
    int  retval = NOPREF_ACT;
    int  loops = 0;
    char *cp;
    char *cp2;

    if ( actf == NULL ) {
	if ( actdbFile[0] == '\0' ) {
	    if ( actdbDefault[0] == '~' ) {
		cp = TildeExpand( actdbDefault );
	    }
	    else {
		cp = actdbDefault;
	    }
	    strcpy(actdbFile,cp);
	}
	actf = fopen(actdbFile,"r");
	if ( actf == NULL ) {
	    return( NOPREF_ACT );
	}
    }
    else fseek(actf,0L,0);
    
    while ( (cp = ActNextLine(actf)) ) {
	cp2 = ActItem("progn=",cp);
	lpn = atoi(cp2);
	if ( lpn != fProgN ) continue;
	cp2 = ActItem("useprog=",cp);
	if ( cp2 ) {
	    if ( loops ) {
		retval = NOPREF_ACT;
		break;
	    }
	    fProgN = atoi(cp2);
	    fseek(actf,0L,0);
	    loops++;
	    continue;
	}

	cp2 = ActItem("protos=",cp);
	if ( !cp2 || !ActSubStr(fProto,cp2) ) {
	    retval = NOPREF_ACT;
	    break;
	}
	
	cp2 = ActItem("act=",cp);
	if ( !cp2 ) {
	    retval = NOPREF_ACT;
	    break;
	}
	
	if ( !strcmp("pre",cp2) || !strcmp("alwaysup",cp2) ) {
	    retval = PRE_ACT;
	    break;
	}

	if ( !strcmp("auto",cp2) ) {
	    retval = AUTO_ACT;
	    cp2 = ActItem("exe=",cp);
	    if ( !cp2 ) {
		retval = NOPREF_ACT;
		break;
	    }
	    if ( *cp2 == '/' ) {
		strcpy(fExeName,cp2);
		break;
	    }
	    if ( *cp2 != '~' ) {
		retval = NOPREF_ACT;
		break;
	    }
	    cp2 = TildeExpand(cp2);
	    if ( *cp2 == '~' ) retval = NOPREF_ACT;
	    else
	        strcpy(fExeName,cp2);
	    break;
	}
    }
    if ( !fStayOpen ) {
	fclose( actf );
	actf = NULL;
    }
    return( retval );
}

