#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pwd.h>
#include "actdb.h"

char *actdbDefault = "~oystr/HRPC/Binding/Activation/actPrefs";
char actdbFile[100];

static FILE *actf = NULL;

/* "forward" */
char *TildeExpand();
char *ActStrDup();
char *ActItem();
char *ActNextLine();
char *ActSubStr();
char *ActNonBlank();

/*
 * This routine is specific to binding agents.  Not
 * for general use.  Avoids overhead of allocating
 * all that space.
 */

int GetActPrefs( fProgN, fStayOpen, fProto, fExeName )
    long fProgN;
    int  fStayOpen;
    char *fProto;
    char *fExeName;
{
    long lpn;
    int  retval = NOPREF_ACT;
    int  loops = 0;
    char *cp;
    char *cp2;

    if ( actf == NULL ) {
	if ( actdbFile[0] == '\0' ) {
	    if ( actdbDefault[0] == '~' ) {
		cp = TildeExpand( actdbDefault );
	    }
	    else {
		cp = actdbDefault;
	    }
	    strcpy(actdbFile,cp);
	}
	actf = fopen(actdbFile,"r");
	if ( actf == NULL ) {
	    return( NOPREF_ACT );
	}
    }
    else fseek(actf,0L,0);
    
    while ( (cp = ActNextLine(actf)) ) {
	cp2 = ActItem("progn=",cp);
	lpn = atoi(cp2);
	if ( lpn != fProgN ) continue;
	cp2 = ActItem("useprog=",cp);
	if ( cp2 ) {
	    if ( loops ) {
		retval = NOPREF_ACT;
		break;
	    }
	    fProgN = atoi(cp2);
	    fseek(actf,0L,0);
	    loops++;
	    continue;
	}

	cp2 = ActItem("protos=",cp);
	if ( !cp2 || !ActSubStr(fProto,cp2) ) {
	    retval = NOPREF_ACT;
	    break;
	}
	
	cp2 = ActItem("act=",cp);
	if ( !cp2 ) {
	    retval = NOPREF_ACT;
	    break;
	}
	
	if ( !strcmp("pre",cp2) || !strcmp("alwaysup",cp2) ) {
	    retval = PRE_ACT;
	    break;
	}

	if ( !strcmp("auto",cp2) ) {
	    retval = AUTO_ACT;
	    cp2 = ActItem("exe=",cp);
	    if ( !cp2 ) {
		retval = NOPREF_ACT;
		break;
	    }
	    if ( *cp2 == '/' ) {
		strcpy(fExeName,cp2);
		break;
	    }
	    if ( *cp2 != '~' ) {
		retval = NOPREF_ACT;
		break;
	    }
	    cp2 = TildeExpand(cp2);
	    if ( *cp2 == '~' ) retval = NOPREF_ACT;
	    else
	        strcpy(fExeName,cp2);
	    break;
	}
    }
    if ( !fStayOpen ) {
	fclose( actf );
	actf = NULL;
    }
    return( retval );
}

char *TildeExpand( fName )
    char *fName;
{
    static char tildeBuf[120];
    register char *cp, *cp2;
    struct passwd *pwptr;

#ifdef DEBUG
printf("TildeExpand: %s.\n",fName);
#endif
    cp2 = tildeBuf;
    cp  = &fName[1];
    while (*cp != '/' ) *cp2++ = *cp++;
    *cp2 = '\0';

    pwptr = getpwnam( tildeBuf );
    if ( !pwptr ) {
	return( fName );
    }
    strcpy( tildeBuf,pwptr->pw_dir );
    strcat( tildeBuf, cp );
#ifdef DEBUG
printf("  returns: %s.\n",tildeBuf);
#endif
    return( tildeBuf );
}

    
/*
 *		>>>> WARNING <<<<
 * This is NOT a general purpose substring finder.
 * Don't use it for anything else.
 */

char *ActSubStr( fPat, fStr )
    char *fPat;
    char *fStr;
{
    register char *pat;
    register char *str;

#ifdef DEBUG
printf("ActSubStr looking for: %s\n",fPat);
#endif
    pat = fPat;
    str = fStr;

    while ( *str ) {
	if ( *str != *pat ) {
	    str++;
	    continue;
	}
	while ( *pat ) {
	    if ( *pat != *str ) {
		pat = fPat;
		break;
	    }
	    pat++; str++;
	}
	if ( !*pat ) {
#ifdef DEBUG
printf("  Found: %s.\n",str);
#endif
	    return( str );
	}
    }
    return( 0 );
}

/*
 * Open the activation "database".  If no name
 * given, use default.
 */

int OpenActDB( fName )
    char *fName;
{
    char *cp, *cp1;

    if ( fName ) {
	cp = fName;
    }
    else
    if (actdbFile[0] == '\0') {
	cp = actdbDefault;
    }
    strcpy(actdbFile, (*cp == '~') ? TildeExpand(cp) : cp );

    if ( actf != NULL ) {
	fclose(actf);
    }
    actf = fopen(actdbFile,"r");
    if ( actf == NULL ) {
	return( -1 );
    }
    return( 0 );
}

int RewindActDB()
{
    if ( actf != NULL ) {
	return( fseek(actf, 0L, 0) );
    }
    else return( -1 );
}

int CloseActDB()
{
    int retval;
    
    if ( actf == NULL ) return( -1 );
    retval = fclose(actf);
    actf = NULL;
    return(retval);
}

char *ActItem( fItem, fString )
    char *fItem;
    char *fString;
{
    char *cp1, *cp2;
    static char strbuf[100];
    char termch;

#ifdef DEBUG
printf("ActItem: %s.\n",fItem);
#endif    
    if ( cp1 = ActSubStr( fItem, fString ) ) {
	if ( *cp1 == '"' ) {
	    cp1++;
	    termch = '"';
	}
	else {
	    termch = ' ';
	}
	
	cp2 = strbuf;
	while( *cp1 && (*cp1 != termch) ) {
	    *cp2++ = *cp1++;
	}
	*cp2 = '\0';
#ifdef DEBUG
printf("  Found: %s.\n",strbuf);
#endif
	return(strbuf);
    }
    return( (char *) 0 );
}

/*
 * Get next entry in activation "database".  Return NULL on any error.
 * This is copied almost directly from the 4.3 inetd.
 */

ActInfo *GetActDBEnt()
{
	register ActInfo *actent;
	char *cp, *arg, *cp2;
	int argc;
	long pos = 0;
	int target;
	struct passwd *pwptr;
	struct stat statbuf;

	cp = ActNextLine(actf);
	if (cp == NULL)
		return ((ActInfo *)0);

	actent = (ActInfo *) calloc(1,sizeof(ActInfo));
	if ( actent == (ActInfo *) 0 ) return( (ActInfo *) 0 );

	arg = ActItem("progn=",cp);
	if ( !arg ) return( (ActInfo *) 0 );
	actent->progNum = atoi(arg);

	arg = ActItem("useprog=",cp);
	if ( arg ) {
	    pos = ftell(actf);
	    fseek(actf, 0L, 0);
	    target = atoi(arg);
more:
	    cp = ActNextLine(actf);
	    if ( cp == NULL ) {
		fseek(actf,pos,0);
		return( (ActInfo *) 0 );
	    }
	    arg = ActItem("progn=",cp);
	    if ( arg && ( atoi(arg) != target ) ) goto more;
	}

	arg = ActItem("protos=",cp);
	if ( ActSubStr("sun_xdr_udp", arg) )
	    actent->protos |= SUNXDRUDP;
	if ( ActSubStr("sun_xdr_tcp", arg) )
	    actent->protos |= SUNXDRTCP;
	if ( ActSubStr("cour_cour_spp", arg) )
	    actent->protos |= COURCOURSPP;
	if ( ActSubStr("dec_src_udp", arg) )
	    actent->protos |= DECSRCUDP;
	if ( ActSubStr("raw_raw_udp", arg) )
	    actent->protos |= RAWRAWUDP;
	if ( ActSubStr("raw_raw_tcp", arg) )
	    actent->protos |= RAWRAWTCP;

	actent->actPref = NOPREF_ACT;
	arg = ActItem("act=",cp);
	if ( !strcmp(arg,"pre") ) {
	    actent->actPref = PRE_ACT;
	}
	else
	if ( !strcmp(arg,"auto") ) {
	    actent->actPref = AUTO_ACT;
	}
	else
	if ( !strcmp(arg,"alwaysup") ) {
	    actent->actPref = ALWAYS_ACT;
	}
	
	arg = ActItem("exe=",cp);
	if ( arg ) {
	    if ( arg[0] == '~' ) {
	        actent->exeFile = ActStrDup( TildeExpand(arg) );
	    }
	    else {
	        actent->exeFile = ActStrDup( arg );
	    }
	}

	arg = ActItem("logf=",cp);
	if ( arg ) {
	    if ( arg[0] == '~' ) {
	        actent->logFile = ActStrDup( TildeExpand(arg) );
	    }
	    else {
	        actent->logFile = ActStrDup( arg );
	    }
	}

	arg = ActItem("su=",cp);
	actent->suid = 32767;
	actent->sgid = 9999;
	if ( arg ) {
	    pwptr = getpwnam(arg);
	    if ( pwptr && (pwptr->pw_uid > 10) ) {
		actent->suid = pwptr->pw_uid;
		actent->sgid = pwptr->pw_gid;
	    }
	}

	arg = ActItem("dir=",cp);
	if ( arg ) {
	    if ( arg[0] == '~' ) {
		actent->chdir = ActStrDup( TildeExpand(arg) );
	    }
	    else {
		actent->chdir = ActStrDup(arg);
	    }
	    if ( stat(actent->chdir,&statbuf) ||
		 (statbuf.st_uid != actent->suid) ) {
		free(actent->chdir);
		actent->chdir = ActStrDup( "/tmp" );
	    }
	}
	
	arg = ActItem("args=",cp);
	if ( arg ) {
	    argc = 0;
	    cp = arg;
#ifdef DEBUG
printf("args: %s.\n",cp);
#endif
	    for (arg = ActNonBlank(&cp); cp; arg = ActNonBlank(&cp)) {
#ifdef DEBUG
printf("arg %d: %s.\n",argc,arg);
#endif
		if (argc < MAXARGV)
			actent->exeArgs[argc++] = ActStrDup(arg);
	    }
	}	    
	while (argc <= MAXARGV)
		actent->exeArgs[argc++] = NULL;
	if ( pos ) fseek(actf,pos,0);
	return (actent);
}
    

FreeActDBEnt( fEnt )
	register ActInfo *fEnt;
{
	int i;

	if (fEnt->exeFile)
		free(fEnt->exeFile);
	if (fEnt->chdir)
		free(fEnt->chdir);
	for (i = 0; i < MAXARGV; i++)
		if (fEnt->exeArgs[i])
			free(fEnt->exeArgs[i]);
	free( fEnt );
}

char *
ActNonBlank(cpp)
	char **cpp;
{
	register char *cp = *cpp;
	char *start;

again:
	while (*cp == ' ' || *cp == '\t')
		cp++;
	if (*cp == '\0') {
		char c;

		c = getc(actf);
		ungetc(c, actf);
		if (c == ' ' || c == '\t')
			if (cp = ActNextLine(actf))
				goto again;
		*cpp = (char *)0;
		return ((char *)0);
	}
	start = cp;
	while (*cp && *cp != ' ' && *cp != '\t')
		cp++;
	if (*cp != '\0')
		*cp++ = '\0';
	*cpp = cp;
	return (start);
}

static char actLineBuf[256];

char *
ActNextLine(fd)
	FILE *fd;
{
	char *cp;
	int space;

	cp = actLineBuf;
	space = sizeof(actLineBuf);
	
	while ( space > 0 ) {
	    if (fgets(cp, space, fd) == NULL)
		return ((char *)0);
	    if ( *cp == '#' ) continue;
	    cp = (char *) index(actLineBuf, '\n');
	    if (cp) {
		*cp = '\0';
		if ( *(cp-1) == '\\' ) {
		    cp--;
		    space = (int) (cp - actLineBuf);
		}
		else break;
	    }
	    else break;
	}
	return (actLineBuf);
}

char *
ActStrDup(cp)
	char *cp;
{
	char *new;

	if (cp == NULL)
		cp = "";
	new = (char *) malloc(strlen(cp) + 1);
	if (new == (char *)0) {
		/* syslog(LOG_ERR, "Out of memory."); */
		exit(-1);
	}
	strcpy(new, cp);
	return (new);
}
