#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pwd.h>
#include "actdb.h"

/* "forward" */
extern char *TildeExpand();
extern char *ActStrDup();
extern char *ActItem();
extern char *ActNextLine();
extern char *ActSubStr();
extern char *ActNonBlank();

char *ActItem( fItem, fString )
    char *fItem;
    char *fString;
{
    char *cp1, *cp2;
    static char strbuf[100];
    char termch;

#ifdef DEBUG
printf("ActItem: %s.\n",fItem);
#endif    
    if ( cp1 = ActSubStr( fItem, fString ) ) {
	if ( *cp1 == '"' ) {
	    cp1++;
	    termch = '"';
	}
	else {
	    termch = ' ';
	}
	
	cp2 = strbuf;
	while( *cp1 && (*cp1 != termch) ) {
	    *cp2++ = *cp1++;
	}
	*cp2 = '\0';
#ifdef DEBUG
printf("  Found: %s.\n",strbuf);
#endif
	return(strbuf);
    }
    return( (char *) 0 );
}

char *
ActNonBlank(cpp)
	char **cpp;
{
	register char *cp = *cpp;
	char *start;

again:
	while (*cp == ' ' || *cp == '\t')
		cp++;
	if (*cp == '\0') {
		*cpp = (char *)0;
		return ((char *)0);
	}
	start = cp;
	while (*cp && *cp != ' ' && *cp != '\t')
		cp++;
	if (*cp != '\0')
		*cp++ = '\0';
	*cpp = cp;
	return (start);
}

static char actLineBuf[256];

char *
ActNextLine(fd)
	FILE *fd;
{
	char *cp;
	int space;

	cp = actLineBuf;
	space = sizeof(actLineBuf);
	
	while ( space > 0 ) {
	    if (fgets(cp, space, fd) == NULL)
		return ((char *)0);
	    if ( *cp == '#' ) continue;
	    cp = (char *) index(actLineBuf, '\n');
	    if (cp) {
		*cp = '\0';
		if ( *(cp-1) == '\\' ) {
		    cp--;
		    space = sizeof(actLineBuf) - (int) (cp - actLineBuf);
		}
		else break;
	    }
	    else break;
	}
	return (actLineBuf);
}

char *
ActStrDup(cp)
	char *cp;
{
	char *new;

	if (cp == NULL)
		cp = "";
	new = (char *) malloc(strlen(cp) + 1);
	if (new == (char *)0) {
		/* syslog(LOG_ERR, "Out of memory."); */
		exit(-1);
	}
	strcpy(new, cp);
	return (new);
}
char *TildeExpand( fName )
    char *fName;
{
    static char tildeBuf[120];
    register char *cp, *cp2;
    struct passwd *pwptr;

#ifdef DEBUG
printf("TildeExpand: %s.\n",fName);
#endif
    cp2 = tildeBuf;
    cp  = &fName[1];
    while (*cp != '/' ) *cp2++ = *cp++;
    *cp2 = '\0';

    pwptr = getpwnam( tildeBuf );
    if ( !pwptr ) {
	return( fName );
    }
    strcpy( tildeBuf,pwptr->pw_dir );
    strcat( tildeBuf, cp );
#ifdef DEBUG
printf("  returns: %s.\n",tildeBuf);
#endif
    return( tildeBuf );
}

    
/*
 *		>>>> WARNING <<<<
 * This is NOT a general purpose substring finder.
 * Don't use it for anything else.
 */

char *ActSubStr( fPat, fStr )
    char *fPat;
    char *fStr;
{
    register char *pat;
    register char *str;

#ifdef DEBUG
printf("ActSubStr looking for: %s\n",fPat);
#endif
    pat = fPat;
    str = fStr;

    while ( *str ) {
	if ( *str != *pat ) {
	    str++;
	    continue;
	}
	while ( *pat ) {
	    if ( *pat != *str ) {
		pat = fPat;
		break;
	    }
	    pat++; str++;
	}
	if ( !*pat ) {
#ifdef DEBUG
printf("  Found: %s.\n",str);
#endif
	    return( str );
	}
    }
    return( 0 );
}
